/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.classdepend;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageClasses {
    private final Set directories = new HashSet();
    private final Set jarContents = new HashSet();

    public static void main(String[] args) throws IOException {
        String classpath;
        if (args.length == 1) {
            classpath = System.getProperty("java.class.path");
        } else if (args.length == 2) {
            classpath = args[1];
        } else {
            throw new IllegalArgumentException("Usage: java " + PackageClasses.class.getName() + " package [classpath]");
        }
        PackageClasses pc = new PackageClasses(classpath);
        TreeSet classes = new TreeSet(pc.compute(args[0]));
        Iterator classesIter = classes.iterator();
        while (classesIter.hasNext()) {
            System.out.println(classesIter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageClasses(String classpath) throws IOException {
        if (classpath == null) {
            throw new NullPointerException("The classpath cannot be null");
        }
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            JarFile jarFile;
            File file;
            String token = tokens.nextToken();
            if (token.equals("")) {
                token = ".";
            }
            if (!(file = new File(token)).exists()) {
                throw new FileNotFoundException("File or directory not found: " + file);
            }
            if (file.isDirectory()) {
                String path = file.getPath();
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                this.directories.add(path);
                continue;
            }
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                IOException e2 = new IOException("Problem accessing file or directory: " + file);
                e2.initCause(e);
                throw e2;
            }
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    this.jarContents.add(entry.getName());
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Set compute(String[] packages) throws IOException {
        return this.compute(false, packages);
    }

    public Set compute(String packAge) throws IOException {
        String[] packages = new String[]{packAge};
        return this.compute(false, packages);
    }

    public Set compute(boolean recurse, String[] packages) throws IOException {
        if (packages == null) {
            throw new NullPointerException("The packages argument cannot be null");
        }
        HashSet<String> classes = new HashSet<String>();
        for (String pkg : packages) {
            if (pkg == null) {
                throw new NullPointerException("Elements of the packages argument cannot be null");
            }
            String pkgFileName = pkg.replace('.', File.separatorChar);
            if (!"".equals(pkgFileName)) {
                pkgFileName = pkgFileName + File.separatorChar;
            }
            for (String dir : this.directories) {
                Object file = new File(dir, pkgFileName);
                if (!((File)file).exists()) continue;
                PackageClasses.collectClasses((File)file, recurse, pkg, classes);
            }
            if (File.separatorChar != '/') {
                pkgFileName = pkgFileName.replace(File.separatorChar, '/');
            }
            for (Object file : this.jarContents) {
                if (!((String)file).startsWith(pkgFileName) || !((String)file).endsWith(".class")) continue;
                file = PackageClasses.removeDotClass((String)file);
                if (!recurse && ((String)file).indexOf(47, pkgFileName.length() + 1) >= 0) continue;
                classes.add(((String)file).replace('/', '.'));
            }
        }
        return classes;
    }

    public Set compute(boolean recurse, String packAge) throws IOException {
        String[] packages = new String[]{packAge};
        return this.compute(recurse, packages);
    }

    private static void collectClasses(File directory, final boolean recurse, final String pkg, final Set classes) throws IOException {
        final IOException[] failed = new IOException[]{null};
        File[] result = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                String name = child.getName();
                if (name != null) {
                    if (name.endsWith(".class") && child.isFile()) {
                        String classname = PackageClasses.removeDotClass(name);
                        if (!"".equals(pkg)) {
                            classname = pkg + '.' + classname;
                        }
                        classes.add(classname);
                    } else if (recurse && child.isDirectory()) {
                        String subpackage = "".equals(pkg) ? name : pkg + '.' + name;
                        try {
                            PackageClasses.collectClasses(child, recurse, subpackage, classes);
                        }
                        catch (IOException e) {
                            failed[0] = e;
                        }
                    }
                }
                return false;
            }
        });
        if (failed[0] != null) {
            throw failed[0];
        }
        if (result == null) {
            throw new IOException("A problem occurred accessing directory: " + directory);
        }
    }

    private static String removeDotClass(String s) {
        return s.substring(0, s.length() - 6);
    }
}

