/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck;

import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Plugin;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.Util;
import java.util.ResourceBundle;

public abstract class AbstractPlugin
implements Plugin {
    private ResourceBundle bundle = Util.getResourceBundle(this.getClass());
    private static ResourceBundle abstractBundle = Util.getResourceBundle(EnvCheck.class);

    protected AbstractPlugin() {
    }

    @Override
    public boolean isPluginOption(String opt) {
        return false;
    }

    protected ResourceBundle getBundle() {
        return this.bundle;
    }

    protected String getString(String key) {
        return Util.getString(key, this.bundle);
    }

    protected String getString(String key, Object val) {
        return Util.getString(key, this.bundle, val);
    }

    protected String getString(String key, Object val1, Object val2) {
        return Util.getString(key, this.bundle, val1, val2);
    }

    protected String getString(String key, Object v1, Object v2, Object v3) {
        return Util.getString(key, this.bundle, v1, v2, v3);
    }

    protected String taskName(String name) {
        return this.getClass().getName() + "$" + name;
    }

    protected void handleUnexpectedSubtaskReturn(Object returnedValue, String source) {
        if (returnedValue == null) {
            Reporter.Message message = new Reporter.Message(2, Util.getString("abstractPlugin.nullvalue", abstractBundle), null);
            Reporter.print(message, source);
            Thread.dumpStack();
        } else if (!(returnedValue instanceof Throwable)) {
            Reporter.Message message = new Reporter.Message(2, Util.getString("abstractPlugin.unknownObject", abstractBundle, returnedValue.toString()), null);
            Reporter.print(message, source);
            Thread.dumpStack();
        } else {
            Throwable t = (Throwable)returnedValue;
            Reporter.Message message = new Reporter.Message(2, Util.getString("abstractPlugin.excReturn", abstractBundle, t.getMessage()), null);
            System.err.println(Util.getString("abstractPlugin.excReturn", abstractBundle, t.getMessage()));
            Reporter.print(message, source);
            t.printStackTrace();
        }
    }
}

