/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck;

import com.sun.jini.resource.Service;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.SharedActivatableServiceDescriptor;
import com.sun.jini.start.SharedActivationGroupDescriptor;
import com.sun.jini.tool.envcheck.Plugin;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import com.sun.jini.tool.envcheck.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;

public class EnvCheck {
    private ArrayList pluginList = new ArrayList();
    private boolean printStackTraces = false;
    private String[] args;
    private ServiceDescriptor[] descriptors = new ServiceDescriptor[0];
    private static ResourceBundle bundle;
    private String javaCmd;
    String[] options = new String[0];
    Properties properties = new Properties();
    String classpath = null;
    String mainClass = null;
    String jarToRun = null;
    static ArrayList pluginJarList;
    ClassLoader pluginLoader = EnvCheck.class.getClassLoader();
    static String combinedClasspath;

    public static void main(String[] args) {
        System.setProperty("java.protocol.handler.pkgs", "net.jini.url");
        bundle = Util.getResourceBundle(EnvCheck.class);
        if (args.length == 0) {
            EnvCheck.usage();
            System.exit(1);
        }
        EnvCheck.findPlugins(args);
        new EnvCheck().run(args);
    }

    private static void usage() {
        System.err.println(Util.getString("envcheck.usage", bundle));
    }

    private String getString(String key) {
        return Util.getString(key, bundle);
    }

    private String getString(String key, String val) {
        return Util.getString(key, bundle, val);
    }

    private static void findPlugins(String[] cmdLine) {
        String arg;
        int index = 0;
        while ((arg = cmdLine[index++]).startsWith("-")) {
            if (arg.equals("-plugin")) {
                String pluginName;
                if (!new File(pluginName = cmdLine[index++]).exists()) {
                    System.err.println(Util.getString("envcheck.noplugin", bundle, pluginName));
                    System.exit(1);
                }
                combinedClasspath = combinedClasspath + File.pathSeparator + pluginName;
                try {
                    pluginJarList.add(new URL("file:" + pluginName));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            if (!arg.equals("-level")) continue;
            ++index;
        }
    }

    private void parseArgs(String[] cmdLine) {
        int index = 0;
        try {
            while (true) {
                String arg;
                if ((arg = cmdLine[index++]).equals("-traces")) {
                    this.printStackTraces = true;
                    Reporter.setPrintTraces(true);
                    continue;
                }
                if (arg.equals("-explain")) {
                    Reporter.setExplanation(true);
                    continue;
                }
                if (arg.equals("-level")) {
                    String val;
                    if ((val = cmdLine[index++]).equals("info")) {
                        Reporter.setLevel(0);
                        continue;
                    }
                    if (val.equals("warning")) {
                        Reporter.setLevel(1);
                        continue;
                    }
                    if (val.equals("error")) {
                        Reporter.setLevel(2);
                        continue;
                    }
                    System.err.println(this.getString("envcheck.badlevel"));
                    EnvCheck.usage();
                    System.exit(1);
                    continue;
                }
                if (arg.equals("-plugin")) {
                    ++index;
                    continue;
                }
                if (this.isPluginOption(arg)) continue;
                if (arg.startsWith("-")) {
                    System.err.println(this.getString("envcheck.illegalopt", arg));
                    EnvCheck.usage();
                    System.exit(1);
                    continue;
                }
                if (arg.endsWith("java")) {
                    this.javaCmd = arg;
                    break;
                }
                System.err.println(this.getString("envcheck.nojavacmd"));
                EnvCheck.usage();
                System.exit(1);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(this.getString("envcheck.nocmdargs"));
            EnvCheck.usage();
            System.exit(1);
        }
        try {
            ArrayList<String> optList = new ArrayList<String>();
            while (true) {
                String opt;
                if (!(opt = cmdLine[index++]).startsWith("-")) {
                    this.mainClass = opt;
                    break;
                }
                if (opt.startsWith("-D")) {
                    int valueIndex = opt.indexOf("=");
                    String key = opt.substring(2, valueIndex);
                    String value = opt.substring(valueIndex + 1);
                    this.properties.put(key, value);
                    continue;
                }
                if (opt.equals("-cp") || opt.equals("-classpath")) {
                    this.classpath = cmdLine[index++];
                    continue;
                }
                if (opt.equals("-jar")) {
                    this.jarToRun = cmdLine[index++];
                    break;
                }
                optList.add(opt);
            }
            this.options = optList.toArray(new String[optList.size()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(this.getString("noexecutable"));
            EnvCheck.usage();
            System.exit(1);
        }
        ArrayList<String> argList = new ArrayList<String>();
        while (index < cmdLine.length) {
            argList.add(cmdLine[index++]);
        }
        this.args = argList.toArray(new String[argList.size()]);
    }

    public ServiceDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public SharedActivationGroupDescriptor getGroupDescriptor() {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!(this.descriptors[i] instanceof SharedActivationGroupDescriptor)) continue;
            return (SharedActivationGroupDescriptor)this.descriptors[i];
        }
        return null;
    }

    private void run(String[] cmdLine) {
        int errorCount;
        if (pluginJarList.size() > 0) {
            URL[] urls = pluginJarList.toArray(new URL[pluginJarList.size()]);
            this.pluginLoader = new URLClassLoader(urls, this.pluginLoader);
        }
        this.loadPlugins();
        this.parseArgs(cmdLine);
        if (this.jarToRun == null && this.classpath == null) {
            System.err.println(this.getString("envcheck.missingclasspath"));
            System.exit(1);
        }
        this.loadConfiguration();
        for (Plugin plugin : this.pluginList) {
            try {
                plugin.run(this);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        int warningCount = Reporter.getWarningCount();
        if (warningCount + (errorCount = Reporter.getErrorCount()) > 0) {
            System.out.println();
            System.out.println();
            System.out.println(this.getString("envcheck.summaryseparator"));
        }
        if (warningCount > 0) {
            System.out.println(this.getString("envcheck.warningheader") + warningCount);
        }
        if (errorCount > 0) {
            System.out.println(this.getString("envcheck.errorheader") + errorCount);
        }
    }

    private boolean isPluginOption(String arg) {
        boolean gotOne = false;
        for (Plugin plugin : this.pluginList) {
            if (!plugin.isPluginOption(arg)) continue;
            gotOne = true;
        }
        return gotOne;
    }

    private void loadConfiguration() {
        Object lobj;
        if (this.jarToRun != null) {
            if (!this.jarToRun.endsWith("start.jar")) {
                return;
            }
            File starterFile = new File(this.jarToRun);
            File jskLibDir = starterFile.getParentFile();
            File jskplatform = new File(jskLibDir, "jsk-platform.jar");
            if (!jskplatform.exists()) {
                return;
            }
        } else if (!this.mainClass.equals("com.sun.jini.start.ServiceStarter")) {
            return;
        }
        if ((lobj = this.launch("com.sun.jini.tool.envcheck.EnvCheck$GetDescriptors", this.args)) instanceof ServiceDescriptor[]) {
            this.descriptors = (ServiceDescriptor[])lobj;
            if (this.descriptors.length == 0) {
                Reporter.print(new Reporter.Message(2, this.getString("envcheck.emptyconfig"), null));
            }
        } else if (lobj instanceof ConfigurationException) {
            System.err.println(this.getString("envcheck.ssdescfailed"));
            ((Throwable)lobj).printStackTrace();
            System.exit(1);
        } else {
            System.err.println(this.getString("envcheck.subtaskex", lobj.toString()));
            ((Throwable)lobj).printStackTrace();
            System.exit(1);
        }
    }

    private void loadPlugins() {
        Package pkg = this.getClass().getPackage();
        String pkgName = "";
        if (pkg != null) {
            pkgName = pkg.getName();
        }
        if ((pkgName = pkgName.replace('.', '/')).length() > 0) {
            pkgName = pkgName + "/";
        }
        Iterator plugins = Service.providers(Plugin.class, this.pluginLoader);
        while (plugins.hasNext()) {
            this.pluginList.add(plugins.next());
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean printStacks() {
        return this.printStackTraces;
    }

    public Object launch(String task, String[] args) {
        String cp = this.jarToRun != null ? this.jarToRun + File.pathSeparator : this.classpath + File.pathSeparator;
        cp = cp + combinedClasspath;
        String[] opts = new String[this.options.length + 2];
        opts[0] = "-cp";
        opts[1] = cp;
        System.arraycopy(this.options, 0, opts, 2, this.options.length);
        if (args == null) {
            args = new String[]{};
        }
        String[] subvmArgs = new String[args.length + 1];
        subvmArgs[0] = task;
        System.arraycopy(args, 0, subvmArgs, 1, args.length);
        return this.launch(this.javaCmd, this.properties, opts, subvmArgs);
    }

    public Object launch(String task) {
        return this.launch(task, null);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public Object launch(String javaCmd, Properties props, String[] opts, String[] args) {
        int i;
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("No class name in args[0]");
        }
        String taskName = args[0];
        try {
            Class<?> taskClass = Class.forName(taskName, true, this.pluginLoader);
            if (!SubVMTask.class.isAssignableFrom(taskClass)) {
                throw new IllegalArgumentException(taskName + " does not implement " + "SubVMTask");
            }
            if (taskClass.getDeclaringClass() != null && (taskClass.getModifiers() & 8) == 0) {
                throw new IllegalArgumentException(taskName + " must be a static class");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + taskName);
        }
        if (javaCmd == null) {
            javaCmd = System.getProperty("java.home");
            javaCmd = javaCmd + File.separator + "bin" + File.separator + "java";
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(javaCmd);
        boolean gotClasspath = false;
        if (opts != null) {
            for (i = 0; i < opts.length; ++i) {
                if ((opts[i].equals("-cp") || opts[i].equals("-classpath")) && i + 1 == opts.length) {
                    throw new IllegalArgumentException("classpath option does not have a value");
                }
                gotClasspath = true;
                cmdList.add(opts[i]);
            }
        }
        if (!gotClasspath) {
            throw new IllegalArgumentException("no classpath defined");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = props.getProperty(key);
                cmdList.add("-D" + key + "=" + value);
            }
        }
        cmdList.add("com.sun.jini.tool.envcheck.SubVM");
        for (i = 0; i < args.length; ++i) {
            cmdList.add(args[i]);
        }
        try {
            String[] argList = cmdList.toArray(new String[cmdList.size()]);
            Process p = Runtime.getRuntime().exec(argList);
            Pipe pipe = new Pipe("errorPipe", p.getErrorStream(), System.err, "Child VM: ");
            ObjectInputStream s = new ObjectInputStream(p.getInputStream());
            Object o = s.readObject();
            pipe.waitTillEmpty(5000);
            return o;
        }
        catch (Exception e) {
            return e;
        }
    }

    public Object launch(NonActivatableServiceDescriptor d, SharedActivationGroupDescriptor gd, String taskName) {
        return this.launch(d, gd, taskName, null);
    }

    public Object launch(NonActivatableServiceDescriptor d, SharedActivationGroupDescriptor gd, String taskName, String[] args) {
        if (d == null && gd == null) {
            return this.launch(taskName, args);
        }
        if (args == null) {
            if (d != null) {
                args = d.getServerConfigArgs();
                if (args == null || args.length == 0) {
                    return new IllegalArgumentException("No configuration args in descriptor");
                }
            } else {
                args = new String[]{};
            }
        }
        String[] taskArgs = new String[args.length + 1];
        taskArgs[0] = taskName;
        System.arraycopy(args, 0, taskArgs, 1, args.length);
        if (d == null && gd != null) {
            Properties props = gd.getServerProperties();
            props.put("java.security.policy", gd.getPolicy());
            ArrayList<String> l = new ArrayList<String>();
            String[] opts = gd.getServerOptions();
            if (opts != null) {
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equals("-cp")) {
                        ++i;
                        continue;
                    }
                    l.add(opts[i]);
                }
            }
            l.add("-cp");
            l.add(gd.getClasspath() + File.pathSeparator + combinedClasspath);
            opts = l.toArray(new String[l.size()]);
            String cmd = gd.getServerCommand();
            if (cmd == null) {
                cmd = this.javaCmd;
            }
            return this.launch(cmd, props, opts, taskArgs);
        }
        if (d != null && gd == null) {
            if (d instanceof SharedActivatableServiceDescriptor) {
                throw new IllegalArgumentException("no group for service");
            }
            Properties props = this.getProperties();
            props.put("java.security.policy", d.getPolicy());
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < this.options.length; ++i) {
                if (this.options[i].equals("-cp") || this.options[i].equals("-classpath")) {
                    ++i;
                    continue;
                }
                l.add(this.options[i]);
            }
            l.add("-cp");
            l.add(d.getImportCodebase() + File.pathSeparator + combinedClasspath);
            String[] opts = l.toArray(new String[l.size()]);
            return this.launch(this.javaCmd, props, opts, taskArgs);
        }
        if (d != null && gd != null) {
            Properties props = this.getProperties();
            String[] opts = this.options;
            String vm = null;
            if (d instanceof SharedActivatableServiceDescriptor) {
                props = gd.getServerProperties();
                if (props == null) {
                    props = new Properties();
                }
                opts = gd.getServerOptions();
                vm = gd.getServerCommand();
            }
            if (vm == null) {
                vm = this.javaCmd;
            }
            props.put("java.security.policy", d.getPolicy());
            ArrayList<String> l = new ArrayList<String>();
            if (opts != null) {
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equals("-cp") || opts[i].equals("-classpath")) {
                        ++i;
                        continue;
                    }
                    l.add(opts[i]);
                }
            }
            l.add("-cp");
            l.add(d.getImportCodebase() + File.pathSeparator + combinedClasspath);
            opts = l.toArray(new String[l.size()]);
            return this.launch(vm, props, opts, taskArgs);
        }
        throw new IllegalStateException("Should never get here");
    }

    public String getJavaCmd() {
        return this.javaCmd;
    }

    public String checkFile(String prop, String desc) {
        String name = this.getProperty(prop);
        if (name == null) {
            return this.getString("util.undef", desc);
        }
        return Util.checkFileName(name, desc);
    }

    public String getJarToRun() {
        return this.jarToRun;
    }

    public String getClasspath() {
        if (this.jarToRun != null) {
            return this.jarToRun;
        }
        return this.classpath;
    }

    static {
        pluginJarList = new ArrayList();
        combinedClasspath = System.getProperty("java.class.path");
    }

    private class Pipe
    implements Runnable {
        private static final byte SEPARATOR = 10;
        private ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        private InputStream in;
        private PrintStream stream;
        private String annotation;
        private Thread outThread;

        Pipe(String name, InputStream in, PrintStream stream, String a) {
            this.in = in;
            this.stream = stream;
            this.annotation = a;
            this.outThread = new Thread((Runnable)this, name);
            this.outThread.setDaemon(true);
            this.outThread.start();
        }

        void waitTillEmpty(int timeout) {
            try {
                this.outThread.join(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            byte[] buf = new byte[256];
            try {
                int count;
                while ((count = this.in.read(buf)) != -1) {
                    this.write(buf, count);
                }
                String lastInBuffer = this.bufOut.toString();
                this.bufOut.reset();
                if (lastInBuffer.length() > 0) {
                    if (this.annotation != null) {
                        this.stream.print(this.annotation);
                    }
                    this.stream.println(lastInBuffer);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void write(byte[] b, int len) throws IOException {
            if (len < 0) {
                throw new ArrayIndexOutOfBoundsException(len);
            }
            for (int i = 0; i < len; ++i) {
                this.write(b[i]);
            }
        }

        private void write(byte b) throws IOException {
            this.bufOut.write(b);
            if (b == 10) {
                String s = this.bufOut.toString();
                this.bufOut.reset();
                if (this.annotation != null) {
                    this.stream.print(this.annotation);
                }
                this.stream.print(s);
            }
        }
    }

    static class GetDescriptors
    implements SubVMTask {
        GetDescriptors() {
        }

        @Override
        public Object run(String[] args) {
            Configuration starterConfig = null;
            try {
                starterConfig = ConfigurationProvider.getInstance(args);
            }
            catch (ConfigurationException e) {
                return e;
            }
            try {
                ServiceDescriptor[] d1 = (ServiceDescriptor[])starterConfig.getEntry("com.sun.jini.start", "serviceDescriptors", ServiceDescriptor[].class, new ServiceDescriptor[0]);
                ServiceDescriptor[] d2 = (ServiceDescriptor[])starterConfig.getEntry("com.sun.jini.start", "serviceDestructors", ServiceDescriptor[].class, new ServiceDescriptor[0]);
                ServiceDescriptor[] descriptors = new ServiceDescriptor[d1.length + d2.length];
                System.arraycopy(d1, 0, descriptors, 0, d1.length);
                System.arraycopy(d2, 0, descriptors, d1.length, d2.length);
                return descriptors;
            }
            catch (ConfigurationException e) {
                return e;
            }
        }
    }
}

