/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.SharedActivationGroupDescriptor;
import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class CheckCodebase
extends AbstractPlugin {
    EnvCheck envCheck;

    @Override
    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        if (envCheck.getDescriptors().length == 0) {
            String source = this.getString("propsource");
            String codebase = envCheck.getProperty("java.rmi.server.codebase");
            this.doChecks(null, null, source, codebase);
        } else {
            ServiceDescriptor[] sd = envCheck.getDescriptors();
            SharedActivationGroupDescriptor g = envCheck.getGroupDescriptor();
            for (int i = 0; i < sd.length; ++i) {
                if (!(sd[i] instanceof NonActivatableServiceDescriptor)) continue;
                NonActivatableServiceDescriptor d = (NonActivatableServiceDescriptor)sd[i];
                String source = this.getString("desc") + " " + d.getImplClassName();
                String codebase = d.getExportCodebase();
                this.doChecks(d, g, source, codebase);
            }
        }
    }

    private void doChecks(NonActivatableServiceDescriptor d, SharedActivationGroupDescriptor g, String source, String codebase) {
        if (this.checkExistance(source, codebase)) {
            StringTokenizer tok = new StringTokenizer(codebase);
            while (tok.hasMoreTokens()) {
                String urlToken = tok.nextToken();
                URL url = this.checkURL(d, g, source, urlToken);
                if (url == null) continue;
                this.checkForFQDomain(url, source);
                this.checkForMD5(url, source);
                this.checkForKnownHost(url, source);
                this.checkForLocalHost(url, source);
                this.checkAccessibility(url, source);
            }
        }
    }

    private boolean checkExistance(String source, String codebase) {
        boolean gotCodebase;
        Reporter.Message message;
        if (codebase != null && codebase.trim().length() > 0) {
            message = new Reporter.Message(0, this.getString("codebaseIs") + " " + codebase, this.getString("existenceExp"));
            gotCodebase = true;
        } else {
            message = new Reporter.Message(0, this.getString("nocodebase"), this.getString("existenceExp"));
            gotCodebase = false;
        }
        Reporter.print(message, source);
        return gotCodebase;
    }

    private URL checkURL(NonActivatableServiceDescriptor d, SharedActivationGroupDescriptor g, String source, String urlToken) {
        URL url = null;
        String[] args = new String[]{urlToken};
        Object lobj = this.envCheck.launch(d, g, this.taskName("GetURLTask"), args);
        if (lobj instanceof URL) {
            url = (URL)lobj;
        } else if (lobj instanceof String) {
            String cause = (String)lobj;
            if (cause.equals("nohandler")) {
                Reporter.Message message = new Reporter.Message(2, this.getString("nohandler", urlToken), this.getString("httpmdExp"));
                Reporter.print(message, source);
                try {
                    url = new URL(urlToken);
                }
                catch (MalformedURLException e) {
                    message = new Reporter.Message(2, this.getString("badURL", urlToken), e, null);
                    Reporter.print(message, source);
                }
            } else {
                Reporter.Message message = new Reporter.Message(2, this.getString("badURL", urlToken) + ": " + cause, null);
                Reporter.print(message, source);
            }
        } else {
            this.handleUnexpectedSubtaskReturn(lobj, source);
        }
        return url;
    }

    private void checkForKnownHost(URL url, String source) {
        try {
            InetAddress.getByName(url.getHost()).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            Reporter.Message message = new Reporter.Message(2, this.getString("noHost", url.getHost(), url), null);
            Reporter.print(message, source);
        }
    }

    private void checkForLocalHost(URL url, String source) {
        try {
            if (InetAddress.getByName(url.getHost()).isLoopbackAddress()) {
                Reporter.Message message = new Reporter.Message(1, this.getString("usedLocalhost", url), this.getString("localhostExp"));
                Reporter.print(message, source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAccessibility(URL url, String source) {
        URLAccessor accessor = new URLAccessor(url);
        Thread t = new Thread(accessor);
        t.setDaemon(true);
        t.start();
        try {
            t.join(5000L, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Reporter.Message message = t.isAlive() ? new Reporter.Message(2, this.getString("noresponse", url), null) : (accessor.getException() == null ? new Reporter.Message(0, this.getString("available", url), null) : new Reporter.Message(2, this.getString("unavailable", url), accessor.getException(), null));
        Reporter.print(message, source);
    }

    private void checkForFQDomain(URL url, String source) {
        String[] topLevelDomains = new String[]{"aero", "biz", "com", "coop", "edu", "gov", "info", "int", "mil", "museum", "name", "net", "org", "pro"};
        String hostName = url.getHost();
        int lastDot = hostName.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < hostName.length() - 1) {
            String tld = hostName.substring(lastDot + 1);
            if (tld.length() == 2) {
                return;
            }
            for (int i = 0; i < topLevelDomains.length; ++i) {
                if (!tld.equals(topLevelDomains[i])) continue;
                return;
            }
        }
        Reporter.Message message = new Reporter.Message(1, this.getString("unqualified", url.getHost()), this.getString("unqualifiedExp"));
        Reporter.print(message, source);
    }

    private void checkForMD5(URL url, String source) {
        int lastSemi;
        if (!url.getProtocol().equalsIgnoreCase("httpmd")) {
            return;
        }
        String target = url.getFile();
        String hash = target.substring((lastSemi = target.lastIndexOf(59)) + 1);
        if (hash.startsWith("md5")) {
            Reporter.Message message = new Reporter.Message(1, this.getString("usesmd5", url), this.getString("usesmd5Exp"));
            Reporter.print(message, source);
        }
    }

    public static class GetURLTask
    implements SubVMTask {
        @Override
        public Object run(String[] args) {
            URL url;
            String urlToken = args[0];
            try {
                url = new URL(urlToken);
            }
            catch (MalformedURLException e) {
                String protocol;
                int firstColon = urlToken.indexOf(58);
                if (firstColon > 0 && (protocol = urlToken.substring(0, firstColon)).equalsIgnoreCase("httpmd") && !this.httpmdHandlerInstalled()) {
                    return "nohandler";
                }
                return e.getMessage();
            }
            return url;
        }

        private boolean httpmdHandlerInstalled() {
            try {
                new URL("httpmd://localhost/foo;sha=0");
            }
            catch (MalformedURLException e) {
                return false;
            }
            return true;
        }
    }

    private class URLAccessor
    implements Runnable {
        URL url;
        Throwable exception = null;

        URLAccessor(URL url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                URLConnection con = this.url.openConnection();
                InputStream inputStream = con.getInputStream();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        Throwable getException() {
            return this.exception;
        }
    }
}

