/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import net.jini.config.ConfigurationProvider;

public class CheckConfig
extends AbstractPlugin {
    private EnvCheck envCheck;

    @Override
    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        ServiceDescriptor[] d = envCheck.getDescriptors();
        for (int i = 0; i < d.length; ++i) {
            String source;
            NonActivatableServiceDescriptor serviceDesc;
            if (!(d[i] instanceof NonActivatableServiceDescriptor) || !this.checkArgs(serviceDesc = (NonActivatableServiceDescriptor)d[i], source = this.getString("descfor") + " " + serviceDesc.getImplClassName())) continue;
            this.checkServiceConfig(serviceDesc, source);
        }
    }

    private boolean checkArgs(NonActivatableServiceDescriptor d, String source) {
        String[] args = d.getServerConfigArgs();
        if (args == null || args.length == 0) {
            Reporter.Message message = new Reporter.Message(2, this.getString("emptydesclist"), this.getString("emptydesclistExp"));
            Reporter.print(message, source);
            return false;
        }
        return true;
    }

    private void checkServiceConfig(NonActivatableServiceDescriptor d, String source) {
        if (this.checkConfigLoad(d, source)) {
            this.checkForAllGroups(d, source);
        }
    }

    private boolean checkConfigLoad(NonActivatableServiceDescriptor d, String source) {
        String task = this.taskName("ConfigTask");
        boolean ret = false;
        Object o = this.envCheck.launch(d, this.envCheck.getGroupDescriptor(), task);
        if (o instanceof Boolean) {
            Reporter.Message message;
            if (((Boolean)o).booleanValue()) {
                message = new Reporter.Message(0, this.getString("ssconfigOK"), this.getString("ssconfigExp"));
                ret = true;
            } else {
                message = new Reporter.Message(2, this.getString("loadfailed"), this.getString("ssconfigExp"));
            }
            Reporter.print(message, source);
        } else if (o instanceof ConfigurationException) {
            Reporter.Message message = new Reporter.Message(2, this.getString("loadfailed"), (Throwable)o, this.getString("ssconfigExp"));
            Reporter.print(message, source);
        } else {
            this.handleUnexpectedSubtaskReturn(o, source);
        }
        return ret;
    }

    private void checkForAllGroups(NonActivatableServiceDescriptor d, String source) {
        String task = this.taskName("GetGroupsTask");
        Object o = this.envCheck.launch(d, this.envCheck.getGroupDescriptor(), task);
        if (o instanceof GroupInfo[]) {
            GroupInfo[] info = (GroupInfo[])o;
            if (info.length == 0) {
                Reporter.Message message = new Reporter.Message(0, this.getString("notallgroup"), this.getString("allgroupExp"));
                Reporter.print(message, source);
            } else {
                for (int i = 0; i < info.length; ++i) {
                    Reporter.Message message;
                    GroupInfo gi = info[i];
                    if (gi.groups == null) {
                        message = new Reporter.Message(1, this.getString("allgroup"), this.getString("allgroupExp"));
                    } else {
                        StringBuffer groupList = new StringBuffer();
                        for (int j = 0; j < gi.groups.length; ++j) {
                            String group = gi.groups[j];
                            if (group.equals("")) {
                                group = "public";
                            }
                            if (j > 0) {
                                groupList.append(",");
                            }
                            groupList.append(group);
                        }
                        message = new Reporter.Message(0, this.getString("groups", groupList.toString()), this.getString("allgroupExp"));
                    }
                    Reporter.print(message, source + ": " + gi.entryName);
                }
            }
        } else {
            this.handleUnexpectedSubtaskReturn(o, source);
        }
    }

    public static class ConfigTask
    implements SubVMTask {
        @Override
        public Object run(String[] args) {
            try {
                ConfigurationProvider.getInstance(args);
                return new Boolean(true);
            }
            catch (Exception e) {
                return e;
            }
        }
    }

    public static class GetGroupsTask
    implements SubVMTask {
        @Override
        public Object run(String[] args) {
            try {
                Configuration config = ConfigurationProvider.getInstance(args);
                return this.getGroups(config);
            }
            catch (Exception e) {
                return e;
            }
        }

        private Object getGroups(Configuration conf) {
            ConfigurationFile cf = (ConfigurationFile)conf;
            ArrayList<GroupInfo> list = new ArrayList<GroupInfo>();
            Set names = cf.getEntryNames();
            for (String name : names) {
                int lastDot = name.lastIndexOf(".initialLookupGroups");
                if (lastDot <= 0) continue;
                String component = name.substring(0, lastDot);
                try {
                    String[] groups = (String[])conf.getEntry(component, "initialLookupGroups", String[].class);
                    list.add(new GroupInfo(name, groups));
                }
                catch (ConfigurationException e) {
                    return e;
                }
            }
            return list.toArray(new GroupInfo[list.size()]);
        }
    }

    private static class GroupInfo
    implements Serializable {
        String entryName;
        String[] groups;

        GroupInfo(String entryName, String[] groups) {
            this.entryName = entryName;
            this.groups = groups;
        }
    }
}

