/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.SharedActivatableServiceDescriptor;
import com.sun.jini.start.SharedActivationGroupDescriptor;
import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import com.sun.jini.tool.envcheck.Util;
import java.io.File;
import java.rmi.RMISecurityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import net.jini.config.ConfigurationProvider;

public class CheckPersistence
extends AbstractPlugin {
    EnvCheck envCheck;

    @Override
    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        ServiceDescriptor[] d = envCheck.getDescriptors();
        for (int i = 0; i < d.length; ++i) {
            if (!(d[i] instanceof SharedActivatableServiceDescriptor)) continue;
            SharedActivatableServiceDescriptor sd = (SharedActivatableServiceDescriptor)d[i];
            this.checkDirectory(sd);
        }
    }

    private void checkDirectory(SharedActivatableServiceDescriptor d) {
        SharedActivationGroupDescriptor gd = this.envCheck.getGroupDescriptor();
        String source = this.getString("descfor", d.getImplClassName());
        Object o = this.envCheck.launch(d, gd, this.taskName("GetEntriesTask"));
        if (o instanceof String[]) {
            this.checkEntries((String[])o, d, source);
        } else if (o instanceof String) {
            Reporter.Message message = new Reporter.Message(1, (String)o, this.getString("dirExp"));
            Reporter.print(message, source);
        } else {
            this.handleUnexpectedSubtaskReturn(o, source);
        }
    }

    private void checkEntries(String[] entries, SharedActivatableServiceDescriptor d, String source) {
        if (entries.length == 0) {
            Reporter.Message message = new Reporter.Message(1, this.getString("noentry"), this.getString("dirExp"));
            Reporter.print(message, source);
        }
        for (int i = 0; i < entries.length; i += 2) {
            Reporter.Message message;
            String name = entries[i];
            String dir = entries[i + 1];
            String loopSource = source + ": " + name + "=" + dir;
            Object lobj = this.checkDir(dir, d);
            if (lobj == null) {
                message = new Reporter.Message(0, this.getString("dirOK"), this.getString("dirExp"));
                Reporter.print(message, loopSource);
                continue;
            }
            if (lobj instanceof String) {
                message = new Reporter.Message(2, (String)lobj, this.getString("dirExp"));
                Reporter.print(message, loopSource);
                continue;
            }
            this.handleUnexpectedSubtaskReturn(lobj, loopSource);
        }
    }

    private Object checkDir(String dir, SharedActivatableServiceDescriptor d) {
        if (dir == null) {
            return this.getString("nulldir");
        }
        String taskName = this.taskName("CheckDirTask");
        String[] args = new String[]{dir};
        SharedActivationGroupDescriptor g = this.envCheck.getGroupDescriptor();
        return this.envCheck.launch(d, g, taskName, args);
    }

    public static class GetEntriesTask
    implements SubVMTask {
        private ResourceBundle bundle = Util.getResourceBundle(CheckPersistence.class);

        @Override
        public Object run(String[] args) {
            try {
                Configuration config = ConfigurationProvider.getInstance(args);
                return this.getEntries(config);
            }
            catch (ConfigurationException e) {
                return Util.getString("configproblem", this.bundle, e.getMessage());
            }
            catch (Exception e) {
                return e;
            }
        }

        private Object getEntries(Configuration conf) {
            ConfigurationFile cf = (ConfigurationFile)conf;
            ArrayList<String> list = new ArrayList<String>();
            Set names = cf.getEntryNames();
            Iterator it = names.iterator();
            String s = "";
            while (it.hasNext()) {
                String name = (String)it.next();
                s = s + name + "\n";
                int lastDot = name.lastIndexOf(".persistenceDirectory");
                if (lastDot <= 0) continue;
                String component = name.substring(0, lastDot);
                try {
                    String dir = (String)conf.getEntry(component, "persistenceDirectory", String.class, null);
                    list.add(name);
                    list.add(dir);
                }
                catch (ConfigurationException e) {
                    return e;
                }
            }
            return list.toArray(new String[list.size()]);
        }
    }

    public static class CheckDirTask
    implements SubVMTask {
        private ResourceBundle bundle = Util.getResourceBundle(CheckPersistence.class);

        @Override
        public Object run(String[] args) {
            System.setSecurityManager(new RMISecurityManager());
            String dir = args[0];
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                return null;
            }
            if (!dirFile.isDirectory()) {
                return Util.getString("notadir", this.bundle, dir);
            }
            File[] contents = dirFile.listFiles();
            if (contents == null) {
                return Util.getString("emptylist", this.bundle, dir);
            }
            if (contents.length > 0) {
                return Util.getString("dirnotempty", this.bundle, dir);
            }
            return null;
        }
    }
}

