/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.sun.jini.logging.Levels;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.jini.config.AbstractConfiguration;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationNotFoundException;
import net.jini.config.NoSuchEntryException;
import net.jini.config.UnicodeEscapesDecodingReader;
import net.jini.config.Utilities;
import net.jini.security.Security;

public class ConfigurationFile
extends AbstractConfiguration {
    private static final Class[] primitives;
    private static final int INT_INDEX = 4;
    private static final int BYTE_INDEX = 1;
    private static final Set prohibitedMethods;
    private static final String moreProhibitedMethods = "net/jini/config/resources/ConfigurationFile.moreProhibitedMethods";
    private static final PrivilegedAction contextClassLoader;
    static final RuntimePermission getClassLoaderPermission;
    final Map entries = new HashMap(11);
    final Map classImports = new HashMap(1);
    final List onDemandImports = new ArrayList(1);
    private String location;
    private int override = 0;
    private final ClassLoader cl;
    private final boolean nonNullLoaderSupplied;
    private final Object resolveLock = new Object();

    public ConfigurationFile(String[] options) throws ConfigurationException {
        this(options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationFile(String[] options, ClassLoader cl) throws ConfigurationException {
        options = this.checkOptions(options);
        this.nonNullLoaderSupplied = cl != null;
        ClassLoader classLoader = this.cl = this.nonNullLoaderSupplied ? cl : (ClassLoader)Security.doPrivileged(contextClassLoader);
        if (this.location == null) {
            new Parser(null, options);
        } else {
            InputStream in = null;
            try {
                try {
                    URL url = new URL(this.location);
                    in = url.openStream();
                }
                catch (MalformedURLException e) {
                    in = new FileInputStream(this.location);
                }
                new Parser(new InputStreamReader(in), options);
            }
            catch (FileNotFoundException e) {
                ErrorDescriptor ed = new ErrorDescriptor(0, 0, "configuration file not found", this.location, e);
                this.throwConfigurationException(new ConfigurationNotFoundException(ed.toString(), e), Collections.singletonList(ed));
                throw new AssertionError((Object)"throwConfigurationException must throw an exception");
            }
            catch (IOException e) {
                this.oops("problem reading configuration file", 0, 0, e);
            }
            catch (RuntimeException e) {
                this.oops("problem reading configuration file", 0, 0, e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        logger.log(Level.FINER, "created {0}", this);
    }

    private String[] checkOptions(String[] options) throws ConfigurationException {
        if (options == null) {
            return new String[0];
        }
        if (options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                if (options[i] != null) continue;
                this.oops("option is null", 0, i);
            }
            if (!"-".equals(options[0])) {
                this.location = options[0];
            }
        }
        return options;
    }

    public ConfigurationFile(Reader reader, String[] options) throws ConfigurationException {
        this(reader, options, null);
    }

    public ConfigurationFile(Reader reader, String[] options, ClassLoader cl) throws ConfigurationException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        options = this.checkOptions(options);
        this.nonNullLoaderSupplied = cl != null;
        this.cl = this.nonNullLoaderSupplied ? cl : (ClassLoader)Security.doPrivileged(contextClassLoader);
        new Parser(reader, options);
        logger.log(Level.FINER, "created {0}", this);
    }

    protected void throwConfigurationException(ConfigurationException defaultException, List errors) throws ConfigurationException {
        if (errors == null) {
            throw new NullPointerException("errors parameter cannot be null");
        }
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("error list must contain at least one error");
        }
        ConfigurationException exception = null;
        if (errors.size() > 1) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            for (ErrorDescriptor error : errors) {
                pw.print("\n" + error.toString());
                Throwable cause = error.getCause();
                if (cause == null) continue;
                pw.print("\ncaused by: ");
                cause.printStackTrace(pw);
            }
            pw.flush();
            exception = new ConfigurationException(sw.toString());
        } else {
            ErrorDescriptor error = (ErrorDescriptor)errors.iterator().next();
            exception = new ConfigurationException(error.toString(), error.getCause());
        }
        if (defaultException != null) {
            throw defaultException;
        }
        throw exception;
    }

    @Override
    protected Object getEntryInternal(String component, String name, Class type, Object data) throws ConfigurationException {
        Class entryType;
        if (component == null || name == null || type == null) {
            throw new NullPointerException("component, name and type cannot be null");
        }
        Entry entry = (Entry)this.entries.get(component + '.' + name);
        if (entry == null || entry.isPrivate) {
            this.oopsNoSuchEntry("entry not found for component " + component + ", name " + name);
        }
        if (!ConfigurationFile.assignable(entryType = entry.resolve(null), type)) {
            Object narrow;
            if (entryType != null && entryType.isPrimitive() && entry.isConstant() && (narrow = this.narrowingAssignable(entry.eval(NO_DATA), type)) != null) {
                return new AbstractConfiguration.Primitive(narrow);
            }
            this.oops("entry of wrong type for component " + component + ", name " + name + ": expected " + Utilities.typeString(type) + ", found " + Utilities.typeString(entryType), entry.lineno, entry.override);
        }
        Object result = entry.eval(data);
        if (entryType != null && entryType.isPrimitive()) {
            if (entryType != type) {
                result = ConfigurationFile.convertPrimitive(result, type);
            }
            return new AbstractConfiguration.Primitive(result);
        }
        return result;
    }

    public Set getEntryNames() {
        HashSet<String> result = new HashSet<String>(this.entries.size());
        for (Entry entry : this.entries.values()) {
            if (entry.isPrivate) continue;
            result.add(entry.fullName);
        }
        return result;
    }

    public Class getEntryType(String component, String name) throws ConfigurationException {
        ConfigurationException configEx;
        if (component == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (!ConfigurationFile.validQualifiedIdentifier(component)) {
            throw new IllegalArgumentException("component must be a valid qualified identifier");
        }
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (!ConfigurationFile.validIdentifier(name)) {
            throw new IllegalArgumentException("name must be a valid identifier");
        }
        Entry entry = (Entry)this.entries.get(component + '.' + name);
        if (entry == null || entry.isPrivate) {
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "entry for component {0}, name {1} not found in {2}", new Object[]{component, name, this});
            }
            this.oopsNoSuchEntry("entry not found for component " + component + ", name " + name);
        }
        try {
            Class result = entry.resolve(null);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0}, component {1}, name {2}: returns {3}", new Object[]{this, component, name, result});
            }
            return result;
        }
        catch (ConfigurationException e) {
            configEx = e;
        }
        catch (RuntimeException e) {
            String description = "problem getting type of entry for component " + component + ", name " + name;
            configEx = null;
            try {
                this.oops(description, entry.lineno, entry.override, e);
            }
            catch (ConfigurationException ce) {
                configEx = ce;
            }
        }
        if (logger.isLoggable(Levels.FAILED)) {
            this.logThrow("getEntryType", "{0}, component {1}, name {2}: throws", new Object[]{this, component, name}, configEx);
        }
        throw configEx;
    }

    protected Class getSpecialEntryType(String name) throws ConfigurationException {
        this.oopsNoSuchEntry("entry not found: " + name);
        return null;
    }

    protected Object getSpecialEntry(String name) throws ConfigurationException {
        this.oopsNoSuchEntry("entry not found: " + name);
        return null;
    }

    Class findClass(String name, int lineno, int override) throws ConfigurationException {
        return this.findClass(name, lineno, override, false);
    }

    Class findClass(String name, int lineno, int override, boolean returnIfNotFound) throws ConfigurationException {
        Class c;
        Class primitiveClass = ConfigurationFile.findPrimitiveClass(name);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        int dot = name.indexOf(46);
        String n = dot < 0 ? name : name.substring(0, dot);
        String classImport = (String)this.classImports.get(n);
        if (classImport != null) {
            if (dot >= 0) {
                classImport = classImport + name.substring(dot).replace('.', '$');
            }
            if ((c = this.findClassNoImports(classImport, lineno, override)) != null) {
                return c;
            }
        }
        if ((c = this.findClassNoImports(name, lineno, override)) != null) {
            return c;
        }
        String inner = name.replace('.', '$');
        Class found = null;
        int i = this.onDemandImports.size();
        while (--i >= 0) {
            String pkgOrClass = (String)this.onDemandImports.get(i);
            for (int j = 0; j < 2; ++j) {
                char sep = j == 0 ? (char)'.' : '$';
                Class next = this.findClassExact(pkgOrClass + sep + inner, lineno, override);
                if (next == null) continue;
                if (found != null) {
                    this.oops("ambiguous class: " + name, lineno, override);
                }
                found = next;
            }
        }
        if (found == null && !returnIfNotFound) {
            this.oops("class not found: " + name, lineno, override);
        }
        return found;
    }

    static Class findPrimitiveClass(String name) {
        if (name.indexOf(46) < 0) {
            int i = primitives.length;
            while (--i >= 0) {
                if (!name.equals(primitives[i].getName())) continue;
                return primitives[i];
            }
        }
        return null;
    }

    Class findClassNoImports(String name, int lineno, int override) throws ConfigurationException {
        int dot;
        Class c = this.findClassExact(name, lineno, override);
        if (c != null) {
            return c;
        }
        while ((dot = name.lastIndexOf(46)) >= 0) {
            c = this.findClassExact(name = name.substring(0, dot) + '$' + name.substring(dot + 1), lineno, override);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    Class findClassExact(String name, int lineno, int override) throws ConfigurationException {
        try {
            Class<?> result;
            Class<?> c = result = Class.forName(name, false, this.cl);
            do {
                if (Modifier.isPublic(c.getModifiers())) continue;
                name = name.replace('$', '.');
                if (c == result) {
                    this.oops("class not public: " + name, lineno, override);
                    continue;
                }
                this.oops("class " + name + " is not accessible: " + "declaring class " + c.getName().replace('$', '.') + " is not public", lineno, override);
            } while ((c = c.getDeclaringClass()) != null);
            return result;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    Field findField(String name, int lineno, int override) throws ConfigurationException {
        String className;
        Class c;
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            this.oops("entry not found: " + name, lineno, override);
        }
        if ((c = this.findClass(className = name.substring(0, dot), lineno, override, true)) == null) {
            this.oops("entry or field not found: " + name, lineno, override);
        }
        String fieldName = name.substring(dot + 1);
        ConfigurationFile.checkPackageAccess(c);
        try {
            Field field = c.getField(fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                this.oops(fieldName + " is not a static field of class " + className, lineno, override);
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            this.oops(fieldName + " is not a public field of class " + className, lineno, override);
            return null;
        }
    }

    private static void checkPackageAccess(Class type) {
        String name;
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (name = type.getName()).lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(name.substring(0, i));
        }
    }

    Method findMethod(String fullName, Class[] argumentTypes, int lineno, int override) throws ConfigurationException {
        int dot = fullName.lastIndexOf(46);
        String typeName = fullName.substring(0, dot);
        String methodName = fullName.substring(dot + 1);
        Class type = this.findClass(typeName, lineno, override, true);
        if (type == null) {
            this.oops("declaring class: " + typeName + ", for method: " + fullName + " was not found", lineno, override);
        }
        Method method = null;
        ConfigurationFile.checkPackageAccess(type);
        Method[] meths = type.getMethods();
        boolean check = false;
        int i = meths.length;
        while (--i >= 0) {
            if (!methodName.equals(meths[i].getName()) || !Modifier.isStatic(meths[i].getModifiers()) || !ConfigurationFile.compatible(meths[i].getParameterTypes(), argumentTypes)) continue;
            if (method == null) {
                method = meths[i];
                continue;
            }
            if (ConfigurationFile.assignable(meths[i].getParameterTypes(), method.getParameterTypes()) && ConfigurationFile.assignable(meths[i].getDeclaringClass(), method.getDeclaringClass())) {
                method = meths[i];
                continue;
            }
            check = true;
        }
        if (method == null) {
            this.oops("no applicable public static method found: " + type.getName() + '.' + methodName + ConfigurationFile.typesString(argumentTypes), lineno, override);
        } else if (prohibitedMethods.contains(method.getDeclaringClass().getName() + '.' + methodName)) {
            this.oops("call to method prohibited: " + fullName, lineno, override);
        } else if (check) {
            i = meths.length;
            while (--i >= 0) {
                if (meths[i] == method || !methodName.equals(meths[i].getName()) || !Modifier.isStatic(meths[i].getModifiers()) || !ConfigurationFile.compatible(meths[i].getParameterTypes(), argumentTypes) || ConfigurationFile.assignable(method.getParameterTypes(), meths[i].getParameterTypes()) && ConfigurationFile.assignable(method.getDeclaringClass(), meths[i].getDeclaringClass())) continue;
                this.oops("ambiguous method invocation: " + type.getName() + '.' + methodName + ConfigurationFile.typesString(argumentTypes), lineno, override);
            }
        }
        return method;
    }

    Constructor findConstructor(String typeName, Class[] argumentTypes, int lineno, int override) throws ConfigurationException {
        Class type = this.findClass(typeName, lineno, override);
        if (Modifier.isInterface(type.getModifiers())) {
            this.oops("calling constructor for interface class: " + type.getName(), lineno, override);
        } else if (type.isPrimitive()) {
            this.oops("calling constructor for primitive class: " + type.getName(), lineno, override);
        } else if (Modifier.isAbstract(type.getModifiers())) {
            this.oops("calling constructor for abstract class: " + type.getName(), lineno, override);
        }
        ConfigurationFile.checkPackageAccess(type);
        Constructor<?>[] cons = type.getConstructors();
        Constructor<?> constructor = null;
        boolean check = false;
        int i = cons.length;
        while (--i >= 0) {
            if (!ConfigurationFile.compatible(cons[i].getParameterTypes(), argumentTypes)) continue;
            if (constructor == null || ConfigurationFile.assignable(cons[i].getParameterTypes(), constructor.getParameterTypes())) {
                constructor = cons[i];
                continue;
            }
            check = true;
        }
        if (constructor == null) {
            this.oops("no public constructor found: " + type.getName() + ConfigurationFile.typesString(argumentTypes), lineno, override);
        } else if (check) {
            i = cons.length;
            while (--i >= 0) {
                if (cons[i] == constructor || !ConfigurationFile.compatible(cons[i].getParameterTypes(), argumentTypes) || ConfigurationFile.assignable(constructor.getParameterTypes(), cons[i].getParameterTypes())) continue;
                this.oops("ambiguous constructor invocation: " + type.getName() + ConfigurationFile.typesString(argumentTypes), lineno, override);
            }
        }
        return constructor;
    }

    private static boolean compatible(Class[] parameterTypes, Class[] argumentTypes) {
        return parameterTypes.length == argumentTypes.length && ConfigurationFile.assignable(argumentTypes, parameterTypes);
    }

    private static boolean assignable(Class[] from, Class[] to) {
        int i = from.length;
        while (--i >= 0) {
            if (ConfigurationFile.assignable(from[i], to[i])) continue;
            return false;
        }
        return true;
    }

    static boolean assignable(Class from, Class to) {
        if (from == null) {
            return !to.isPrimitive();
        }
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (to.isPrimitive() && from.isPrimitive()) {
            if (from == Byte.TYPE && to == Short.TYPE) {
                return true;
            }
            int j = primitives.length;
            while (--j >= 4) {
                if (to != primitives[j]) continue;
                while (--j >= 1) {
                    if (from != primitives[j]) continue;
                    return true;
                }
                break block0;
            }
        }
        return false;
    }

    Object narrowingAssignable(Object from, Class to) {
        if (from instanceof Byte || from instanceof Character || from instanceof Short || from instanceof Integer) {
            int val;
            int n = val = from instanceof Character ? ((Character)from).charValue() : ((Number)from).intValue();
            if (to == Byte.TYPE) {
                if (val >= -128 && val <= 127) {
                    return (byte)val;
                }
            } else if (to == Character.TYPE) {
                if (val >= 0 && val <= 65535) {
                    return Character.valueOf((char)val);
                }
            } else if (to == Short.TYPE && val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
                return (short)val;
            }
        }
        return null;
    }

    static Object convertPrimitive(Object obj, Class primitiveType) {
        Number n;
        Number number = n = obj instanceof Character ? (Number)Integer.valueOf(((Character)obj).charValue()) : (Number)((Number)obj);
        if (primitiveType == Byte.TYPE) {
            return n.byteValue();
        }
        if (primitiveType == Character.TYPE) {
            return Character.valueOf((char)n.intValue());
        }
        if (primitiveType == Short.TYPE) {
            return n.shortValue();
        }
        if (primitiveType == Integer.TYPE) {
            return n.intValue();
        }
        if (primitiveType == Long.TYPE) {
            return n.longValue();
        }
        if (primitiveType == Float.TYPE) {
            return Float.valueOf(n.floatValue());
        }
        if (primitiveType == Double.TYPE) {
            return n.doubleValue();
        }
        return null;
    }

    static boolean compatibleMethods(Class c1, Class c2) {
        Method[] meths = c1.getMethods();
        int i = meths.length;
        while (--i >= 0) {
            Method m1 = meths[i];
            try {
                Method m2 = c2.getMethod(m1.getName(), m1.getParameterTypes());
                if (m2 == null || m1.getReturnType() == m2.getReturnType()) continue;
                return false;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return true;
    }

    private static String typesString(Class[] types) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(Utilities.typeString(types[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    String expandStringProperties(String value, int lineno) throws ConfigurationException {
        StringBuffer sb;
        block8: {
            int pe;
            int p = value.indexOf("${", 0);
            if (p == -1) {
                return value;
            }
            int max = value.length();
            sb = new StringBuffer(max);
            int i = 0;
            do {
                if (p > i) {
                    sb.append(value.substring(i, p));
                    i = p;
                }
                if ((pe = value.indexOf(125, p + 2)) == -1) {
                    sb.append(value.substring(p, max));
                    break block8;
                }
                String prop = value.substring(p + 2, pe);
                if (prop.equals("/")) {
                    sb.append(File.separatorChar);
                    continue;
                }
                try {
                    String val;
                    String string = val = prop.length() == 0 ? null : System.getProperty(prop);
                    if (val != null) {
                        sb.append(val);
                        continue;
                    }
                    this.oops("problem expanding system property '" + prop + "'", lineno, this.override);
                }
                catch (SecurityException e) {
                    this.oops("problem expanding system property '" + prop + "'", lineno, this.override, e);
                }
            } while ((p = value.indexOf("${", i = pe + 1)) != -1);
            if (i >= max) break block8;
            sb.append(value.substring(i, max));
        }
        return sb.toString();
    }

    private void oops(String what, int lineno, int override) throws ConfigurationException {
        this.oops(what, lineno, override, null);
    }

    private void oops(String what, int lineno, int override, Throwable t) throws ConfigurationException {
        ErrorDescriptor error = new ErrorDescriptor(lineno, override, what, this.location, t);
        this.throwConfigurationException(new ConfigurationException(error.toString(), t), Collections.singletonList(error));
        throw new AssertionError((Object)"throwConfigurationException must throw an exception");
    }

    private void oopsNoSuchEntry(String what) throws ConfigurationException {
        ErrorDescriptor error = new ErrorDescriptor(0, 0, what, this.location);
        this.throwConfigurationException(new NoSuchEntryException(error.toString()), Collections.singletonList(error));
        throw new AssertionError((Object)"throwConfigurationException must throw an exception");
    }

    public String toString() {
        return "ConfigurationFile@" + Integer.toHexString(this.hashCode()) + (this.location == null ? "" : "{" + this.location + "}");
    }

    static {
        block13: {
            primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
            prohibitedMethods = new HashSet<String>(Arrays.asList("java.lang.Class.forName", "java.lang.ClassLoader.getSystemClassLoader", "java.lang.Package.getPackage", "java.lang.Package.getPackages", "java.lang.System.load", "java.lang.System.loadLibrary", "java.security.AccessController.doPrivileged", "java.sql.DriverManager.deregisterDriver", "java.sql.DriverManager.getConnection", "java.sql.DriverManager.getDriver", "java.sql.DriverManager.getDrivers", "net.jini.security.Security.doPrivileged"));
            InputStream in = null;
            try {
                String line;
                ClassLoader cl = ConfigurationFile.class.getClassLoader();
                if (cl == null) {
                    cl = Utilities.bootstrapResourceLoader;
                }
                if ((in = cl.getResourceAsStream(moreProhibitedMethods)) == null) break block13;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                while (true) {
                    if ((line = reader.readLine()) == null) {
                        break block13;
                    }
                    logger.log(Level.FINER, "Adding prohibited method: {0}", line);
                    if (!ConfigurationFile.validQualifiedIdentifier(line)) break;
                    prohibitedMethods.add(line);
                }
                logger.log(Level.SEVERE, "Problem adding prohibited method: {0}", line);
                throw new ExceptionInInitializerError("Problem adding prohibited method: " + line);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Problem reading prohibited methods resource", e);
                throw new ExceptionInInitializerError(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        contextClassLoader = new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        getClassLoaderPermission = new RuntimePermission("getClassLoader");
    }

    public static class ErrorDescriptor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int lineno;
        private final int override;
        private final String description;
        private final String locationName;
        private final Throwable t;

        public ErrorDescriptor(int lineno, int override, String description, String locationName, Throwable t) {
            if (lineno < 0) {
                throw new IllegalArgumentException("line number must be greater than 0");
            }
            if (override < 0) {
                throw new IllegalArgumentException("override argument must be greater than 0");
            }
            if (description == null) {
                throw new IllegalArgumentException("description of the error cannot be null");
            }
            if (t instanceof Error) {
                throw new IllegalArgumentException("t cannot be an instance of java.lang.Error");
            }
            this.lineno = lineno;
            this.override = override;
            this.description = description;
            this.locationName = locationName;
            this.t = t;
        }

        public ErrorDescriptor(int lineno, int override, String description, String locationName) {
            this(lineno, override, description, locationName, null);
        }

        public ErrorDescriptor(int lineno, int override, String description) {
            this(lineno, override, description, null);
        }

        public int getLineNumber() {
            return this.lineno;
        }

        public int getOverride() {
            return this.override;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLocationName() {
            return this.locationName;
        }

        public Throwable getCause() {
            return this.t;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.override > 0) {
                buffer.append("Override " + this.override + ": ");
                if (this.lineno > 0) {
                    buffer.append("Line " + this.lineno + ": ");
                }
            } else if (this.locationName == null && this.lineno > 0) {
                buffer.append("Line " + this.lineno + ": ");
            } else if (this.locationName != null) {
                buffer.append(this.locationName + ":");
                if (this.lineno > 0) {
                    buffer.append(this.lineno + ": ");
                }
            }
            buffer.append(this.description);
            return buffer.toString();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.lineno < 0) {
                throw new InvalidObjectException("line number must be greater than 0");
            }
            if (this.override < 0) {
                throw new InvalidObjectException("override argument must be greater than 0");
            }
            if (this.description == null) {
                throw new InvalidObjectException("description of the error cannot be null");
            }
            if (this.t instanceof Error) {
                throw new InvalidObjectException("t cannot be an instance of java.lang.Error");
            }
        }

        private void readObjectNoData() throws ObjectStreamException {
            throw new InvalidObjectException("no data");
        }
    }

    private class Parser {
        private StreamTokenizer st;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Parser(Reader reader, String[] options) throws ConfigurationException {
            try {
                ConfigurationFile.this.onDemandImports.add("java.lang");
                if (reader != null) {
                    if (!(reader instanceof BufferedReader)) {
                        reader = new BufferedReader(reader);
                    }
                    this.createTokenizer(reader);
                    this.parseSource();
                }
                for (int i = 1; i < options.length; ++i) {
                    ConfigurationFile.this.override = i;
                    this.createTokenizer(new StringReader(options[i]));
                    this.parseOverride();
                }
            }
            catch (IOException e) {
                ConfigurationFile.this.oops("problem reading configuration file", 0, 0, e);
            }
            finally {
                ConfigurationFile.this.override = 0;
            }
        }

        private void createTokenizer(Reader reader) {
            reader = new UnicodeEscapesDecodingReader(reader);
            this.st = new PushbackStreamTokenizer(reader);
            this.st.ordinaryChar(46);
            this.st.wordChars(46, 46);
            this.st.ordinaryChars(48, 57);
            this.st.wordChars(48, 57);
            this.st.ordinaryChar(45);
            this.st.wordChars(45, 45);
            this.st.wordChars(95, 95);
            this.st.wordChars(36, 36);
            this.st.ordinaryChar(47);
            this.st.slashSlashComments(true);
            this.st.slashStarComments(true);
        }

        private void parseSource() throws ConfigurationException, IOException {
            int t;
            while ((t = this.st.nextToken()) != -1) {
                this.st.pushBack();
                String val = this.token("keyword 'import', 'static' or 'private', or component");
                if ("import".equals(val)) {
                    this.parseImport();
                    continue;
                }
                this.parseComponent(val);
            }
        }

        private void parseImport() throws ConfigurationException, IOException {
            if (!ConfigurationFile.this.entries.isEmpty()) {
                this.oops("import follows entry");
            }
            this.st.wordChars(42, 42);
            String value = this.token("import package or type");
            this.st.ordinaryChar(42);
            boolean onDemand = value.endsWith(".*");
            if (onDemand) {
                value = value.substring(0, value.length() - 2);
            }
            if (!AbstractConfiguration.validQualifiedIdentifier(value)) {
                this.syntax("import package or type");
            }
            this.token(';');
            if (onDemand) {
                if (!ConfigurationFile.this.onDemandImports.contains(value)) {
                    Class c = ConfigurationFile.this.findClassNoImports(value, this.st.lineno(), ConfigurationFile.this.override);
                    if (c != null && c.getName().indexOf(46) < 0) {
                        this.oops("import from unnamed package");
                    }
                    ConfigurationFile.this.onDemandImports.add(value);
                }
            } else {
                Class c;
                int dot = value.lastIndexOf(46);
                if (dot < 0) {
                    this.oops("import from unnamed package");
                }
                if ((c = ConfigurationFile.this.findClassNoImports(value, this.st.lineno(), ConfigurationFile.this.override)) == null) {
                    this.oops("class not found: " + value);
                } else if (c.getName().indexOf(46) < 0) {
                    this.oops("import from unnamed package");
                }
                String simple = value.substring(dot + 1);
                if (ConfigurationFile.this.classImports.containsKey(simple) && !ConfigurationFile.this.classImports.get(simple).equals(value)) {
                    this.oops("conflicting imports: " + ConfigurationFile.this.classImports.get(simple) + " and " + value);
                }
                ConfigurationFile.this.classImports.put(simple, value);
            }
        }

        private void parseComponent(String component) throws ConfigurationException, IOException {
            if (!AbstractConfiguration.validQualifiedIdentifier(component)) {
                this.oops("invalid component: '" + component + "'");
            }
            this.token('{');
            while (true) {
                int t;
                if ((t = this.st.nextToken()) == -3) {
                    this.parseEntry(component, this.st.sval);
                    continue;
                }
                if (t == 125) break;
                this.syntax("'}', keyword 'static' or 'private', or entry name");
            }
        }

        private void parseEntry(String component, String name) throws ConfigurationException, IOException {
            String fullName;
            boolean isPrivate = false;
            boolean isStatic = false;
            while (true) {
                if ("private".equals(name)) {
                    if (isPrivate) {
                        this.oops("duplicate 'private'");
                    }
                    isPrivate = true;
                } else {
                    if (!"static".equals(name)) break;
                    if (isStatic) {
                        this.oops("duplicate 'static'");
                    }
                    isStatic = true;
                }
                name = this.token("keyword 'static' or 'private', or entry name");
            }
            if (!AbstractConfiguration.validIdentifier(name)) {
                this.oops("illegal entry name: " + name);
            }
            if (ConfigurationFile.this.entries.containsKey(fullName = component + '.' + name)) {
                this.oops("duplicate entry name: " + name);
            }
            this.token('=');
            Entry entry = new Entry(component, fullName, isPrivate, isStatic, false, this.st.lineno(), this);
            this.token(';');
            ConfigurationFile.this.entries.put(fullName, entry);
        }

        private void parseOverride() throws ConfigurationException, IOException {
            Entry entry;
            String name;
            boolean isPrivate = false;
            boolean isStatic = false;
            while (true) {
                if ("private".equals(name = this.token("keyword 'static' or 'private', or fully qualified entry name"))) {
                    if (isPrivate) {
                        this.oops("duplicate 'private'");
                    }
                    isPrivate = true;
                    continue;
                }
                if (!"static".equals(name)) break;
                if (isStatic) {
                    this.oops("duplicate 'static'");
                }
                isStatic = true;
            }
            int dot = name.lastIndexOf(46);
            if (!AbstractConfiguration.validQualifiedIdentifier(name) || dot < 0) {
                this.syntax("fully qualified entry name");
            }
            if ((entry = (Entry)ConfigurationFile.this.entries.get(name)) != null && entry.isOverride) {
                this.oops("duplicate override: " + name);
            }
            this.token('=');
            String component = name.substring(0, dot);
            entry = new Entry(component, name, isPrivate, isStatic, true, this.st.lineno(), this);
            int t = this.st.nextToken();
            if (t != -1) {
                this.syntax("no more characters");
            }
            ConfigurationFile.this.entries.put(name, entry);
        }

        private ParseNode[] parseArgs(Entry inEntry, char close) throws ConfigurationException, IOException {
            boolean arrayArgs;
            ArrayList<ParseNode> args = new ArrayList<ParseNode>(1);
            int t = this.st.nextToken();
            boolean bl = arrayArgs = close == '}';
            if (t != close) {
                if (t == 44 && arrayArgs) {
                    t = this.st.nextToken();
                    if (t != close) {
                        this.syntax("'" + close + "'");
                    }
                } else {
                    this.st.pushBack();
                    while (true) {
                        args.add(this.parseExpr(inEntry));
                        t = this.st.nextToken();
                        if (t == close) break;
                        if (t != 44) {
                            this.syntax("',' or '" + close + "'");
                            continue;
                        }
                        if (!arrayArgs) continue;
                        t = this.st.nextToken();
                        if (t == close) break;
                        this.st.pushBack();
                    }
                }
            }
            return args.toArray(new ParseNode[args.size()]);
        }

        ParseNode parseExpr(Entry inEntry) throws ConfigurationException, IOException {
            ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
            do {
                nodes.add(this.parseSubExpr(inEntry));
            } while (this.st.nextToken() == 43);
            this.st.pushBack();
            if (nodes.size() == 1) {
                return (ParseNode)nodes.get(0);
            }
            return new StringConcatenation(nodes.toArray(new ParseNode[nodes.size()]), this.st.lineno());
        }

        ParseNode parseSubExpr(Entry inEntry) throws ConfigurationException, IOException {
            int t = this.st.nextToken();
            String val = this.st.sval;
            if (t == 39) {
                if (val.length() != 1) {
                    this.oops("invalid character: '" + val + "'");
                }
                return new Literal(Character.TYPE, Character.valueOf(val.charAt(0)), this.st.lineno());
            }
            if (t == 34) {
                return new StringLiteral(val, this.st.lineno());
            }
            if (t == 40) {
                int lineno = this.st.lineno();
                String type = this.token("type");
                t = this.st.nextToken();
                boolean isArray = false;
                if (t == 91) {
                    isArray = true;
                    this.token(']');
                    t = this.st.nextToken();
                }
                if (t != 41) {
                    this.syntax("')'");
                }
                return new Cast(type, isArray, this.parseExpr(inEntry), lineno);
            }
            this.st.pushBack();
            val = this.token("expression");
            if (Character.isDigit(val.charAt(0)) || val.charAt(0) == '-') {
                return this.getNumber(val);
            }
            if ("true".equals(val)) {
                return new Literal(Boolean.TYPE, Boolean.TRUE, this.st.lineno());
            }
            if ("false".equals(val)) {
                return new Literal(Boolean.TYPE, Boolean.FALSE, this.st.lineno());
            }
            if ("null".equals(val)) {
                return new Literal(null, null, this.st.lineno());
            }
            if ("new".equals(val)) {
                return this.parseNewInstance(inEntry);
            }
            if ("this".equals(val)) {
                return new ThisRef(this.st.lineno());
            }
            if (val.endsWith(".class")) {
                if (ConfigurationFile.findPrimitiveClass(val = val.substring(0, val.length() - 6)) == null && !AbstractConfiguration.validQualifiedIdentifier(val)) {
                    this.oops("illegal class name: " + val);
                }
                return new ClassLiteral(val, false, this.st.lineno());
            }
            t = this.st.nextToken();
            if (t == 91) {
                int lineno = this.st.lineno();
                this.token(']');
                if (!".class".equals(this.token("'.class'"))) {
                    this.syntax("'.class'");
                } else if (ConfigurationFile.findPrimitiveClass(val) == null && !AbstractConfiguration.validQualifiedIdentifier(val)) {
                    this.oops("illegal class name: " + val);
                }
                return new ClassLiteral(val, true, lineno);
            }
            this.st.pushBack();
            if (!AbstractConfiguration.validQualifiedIdentifier(val)) {
                if (t == 40) {
                    this.oops("illegal method name: " + val);
                } else {
                    this.oops("illegal field or entry name: " + val);
                }
            }
            if (t == 40) {
                return this.parseMethodCall(inEntry, val);
            }
            if ("$data".equals(val)) {
                if (inEntry.isStatic) {
                    this.oops("cannot use '$data' in a static entry");
                }
                inEntry.setRefersToData();
            }
            return new NameRef(inEntry.component, val, this.st.lineno());
        }

        private Literal getNumber(String val) throws ConfigurationException, IOException {
            char c = val.charAt(val.length() - 1);
            try {
                if (c == 'l' || c == 'L') {
                    return new Literal(Long.TYPE, Long.decode(val.substring(0, val.length() - 1)), this.st.lineno());
                }
                if (c == 'f' || c == 'F') {
                    return new Literal(Float.TYPE, Float.valueOf(val.substring(0, val.length() - 1)), this.st.lineno());
                }
                if (c == 'd' || c == 'D') {
                    return new Literal(Double.TYPE, Double.valueOf(val.substring(0, val.length() - 1)), this.st.lineno());
                }
                if (val.indexOf(101) > 0 || val.indexOf(69) > 0 || val.indexOf(46) > 0) {
                    return new Literal(Double.TYPE, Double.valueOf(val), this.st.lineno());
                }
                return new Literal(Integer.TYPE, Integer.decode(val), this.st.lineno());
            }
            catch (NumberFormatException e) {
                this.oops("bad numeric literal: " + val);
                return null;
            }
        }

        private ParseNode parseNewInstance(Entry inEntry) throws ConfigurationException, IOException {
            int lineno = this.st.lineno();
            String typeName = this.token("type name");
            int t = this.st.nextToken();
            if (t == 91) {
                this.token(']');
                this.token('{');
                return new ArrayConstructor(typeName, this.parseArgs(inEntry, '}'), lineno);
            }
            if (t != 40) {
                this.syntax("'(' or '['");
            }
            return new ConstructorCall(typeName, this.parseArgs(inEntry, ')'), lineno);
        }

        private MethodCall parseMethodCall(Entry inEntry, String name) throws ConfigurationException, IOException {
            if (!AbstractConfiguration.validQualifiedIdentifier(name) || name.indexOf(46) < 0) {
                this.syntax("method name");
            }
            int lineno = this.st.lineno();
            this.token('(');
            return new MethodCall(name, this.parseArgs(inEntry, ')'), lineno);
        }

        private void token(char c) throws ConfigurationException, IOException {
            int t = this.st.nextToken();
            if (t != c) {
                if (c == '\"') {
                    this.syntax("a String");
                } else {
                    this.syntax(new String(new char[]{'\'', c, '\''}));
                }
            }
        }

        private String token(String what) throws ConfigurationException, IOException {
            int t = this.st.nextToken();
            if (t != -3) {
                this.syntax(what);
            }
            if (this.st.sval.indexOf(46) >= 0 || AbstractConfiguration.validIdentifier(this.st.sval) || ConfigurationFile.findPrimitiveClass(this.st.sval) != null) {
                StringBuilder result = new StringBuilder(120);
                result.append(this.st.sval);
                while (true) {
                    int p;
                    if ((p = this.st.nextToken()) != -3 || result.lastIndexOf(".") != result.length() - 1 && !this.st.sval.startsWith(".")) break;
                    result.append(this.st.sval);
                }
                this.st.pushBack();
                this.st.sval = result.toString();
            }
            return this.st.sval;
        }

        private void syntax(String what) throws ConfigurationException {
            this.oops("expected " + what + ", found " + this.describeCurrentToken());
        }

        private String describeCurrentToken() {
            switch (this.st.ttype) {
                case -1: {
                    return "end of file";
                }
                case 10: {
                    return "end of line";
                }
                case -3: {
                    return "'" + this.st.sval + "'";
                }
                case -2: {
                    return "'" + this.st.nval + "'";
                }
                case 34: {
                    return "\"" + this.st.sval + "\"";
                }
                case 39: {
                    return "'" + this.st.sval.charAt(0) + "'";
                }
            }
            return "'" + (char)this.st.ttype + "'";
        }

        private void oops(String what) throws ConfigurationException {
            ConfigurationFile.this.oops(what, this.st.lineno(), ConfigurationFile.this.override, null);
        }
    }

    private class ArrayConstructor
    extends Call {
        private final String typeName;
        private Class type;

        ArrayConstructor(String typeName, ParseNode[] args, int lineno) {
            super(args, lineno);
            this.typeName = typeName;
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            this.type = ConfigurationFile.this.findClass(this.typeName, this.lineno, this.override);
            Class[] types = this.resolveArgs(inEntry);
            for (int i = 0; i < types.length; ++i) {
                Object narrow;
                if (ConfigurationFile.assignable(types[i], this.type)) continue;
                if (this.args[i] instanceof Literal && (narrow = ConfigurationFile.this.narrowingAssignable(this.args[i].eval(Configuration.NO_DATA), this.type)) != null) {
                    this.args[i] = new Literal(Utilities.getPrimitiveType(narrow.getClass()), narrow, this.args[i].lineno);
                    continue;
                }
                this.oops("array element " + i + " has incorrect type", this.args[i].lineno);
            }
            return Array.newInstance(this.type, 0).getClass();
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            Object[] contents = this.evalArgs(data);
            Object result = Array.newInstance(this.type, this.args.length);
            for (int i = 0; i < contents.length; ++i) {
                Class<?> valueType;
                Object value = contents[i];
                Class<?> clazz = valueType = value == null ? null : value.getClass();
                if (!this.type.isPrimitive() && !ConfigurationFile.assignable(valueType, this.type)) {
                    this.oops("array element " + i + " has incorrect type", this.args[i].lineno);
                }
                Array.set(result, i, value);
            }
            return result;
        }
    }

    private class MethodCall
    extends Call {
        final String fullName;
        private Method method;

        MethodCall(String fullName, ParseNode[] args, int lineno) {
            super(args, lineno);
            this.fullName = fullName;
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            this.method = ConfigurationFile.this.findMethod(this.fullName, this.resolveArgs(inEntry), this.lineno, this.override);
            Class<?> c = this.method.getReturnType();
            if (c == Void.TYPE) {
                this.oops("method has void return type: " + this.fullName);
            }
            return c;
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            Throwable except;
            Object[] evaluatedArgs = this.evalArgs(data);
            try {
                return this.method.invoke(null, evaluatedArgs);
            }
            catch (InvocationTargetException e) {
                except = e.getTargetException();
                if (except instanceof Error) {
                    throw (Error)except;
                }
            }
            catch (Exception e) {
                except = e;
            }
            this.oops("problem invoking method " + this.fullName, except);
            return null;
        }
    }

    private class ConstructorCall
    extends Call {
        private final String typeName;
        private Constructor constructor;

        ConstructorCall(String typeName, ParseNode[] args, int lineno) {
            super(args, lineno);
            this.typeName = typeName;
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            this.constructor = ConfigurationFile.this.findConstructor(this.typeName, this.resolveArgs(inEntry), this.lineno, this.override);
            return this.constructor.getDeclaringClass();
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            Throwable except;
            Object[] evaluatedArgs = this.evalArgs(data);
            try {
                return this.constructor.newInstance(evaluatedArgs);
            }
            catch (InvocationTargetException e) {
                except = e.getTargetException();
                if (except instanceof Error) {
                    throw (Error)except;
                }
            }
            catch (Exception e) {
                except = e;
            }
            this.oops("problem invoking constructor for " + this.typeName, except);
            return null;
        }
    }

    private class StringConcatenation
    extends Call {
        StringConcatenation(ParseNode[] args, int lineno) {
            super(args, lineno);
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            Class[] types = this.resolveArgs(inEntry);
            if (types[0] != String.class && types[1] != String.class) {
                this.oops("The static type of the first or second operand in a string concatenation expression must be java.lang.String.  The static types of the first and second operands in the string concatenation expression are " + types[0] + " and " + types[1] + ", respectively");
            }
            return String.class;
        }

        @Override
        boolean isConstant() {
            return false;
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            StringBuffer value = new StringBuffer();
            Object[] evaledArgs = this.evalArgs(data);
            for (int i = 0; i < evaledArgs.length; ++i) {
                Object o1 = evaledArgs[i];
                value.append(o1);
            }
            return value.toString();
        }
    }

    private abstract class Call
    extends ParseNode {
        final ParseNode[] args;

        Call(ParseNode[] args, int lineno) {
            super(lineno);
            this.args = args;
        }

        @Override
        boolean isConstant() {
            return false;
        }

        Class[] resolveArgs(Entry inEntry) throws ConfigurationException {
            Class[] types = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                types[i] = this.args[i].resolve(inEntry);
            }
            return types;
        }

        Object[] evalArgs(Object data) throws ConfigurationException {
            Object[] result = new Object[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                result[i] = this.args[i].eval(data);
            }
            return result;
        }
    }

    private class Cast
    extends ParseNode {
        private final String typeName;
        private final boolean isArray;
        private final ParseNode arg;
        private Class type;

        Cast(String typeName, boolean isArray, ParseNode arg, int lineno) {
            super(lineno);
            this.typeName = typeName;
            this.isArray = isArray;
            this.arg = arg;
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            Class argType;
            this.type = ConfigurationFile.this.findClass(this.typeName, this.lineno, this.override);
            if (this.isArray) {
                this.type = Array.newInstance(this.type, 0).getClass();
            }
            if (this.type == (argType = this.arg.resolve(inEntry))) {
                return this.type;
            }
            if (this.type.isPrimitive()) {
                if (this.type != Boolean.TYPE && argType != Boolean.TYPE && argType != null && argType.isPrimitive()) {
                    return this.type;
                }
            } else {
                if (argType == null || this.type.isAssignableFrom(argType) || argType.isAssignableFrom(this.type)) {
                    return this.type;
                }
                if (this.type.isInterface() && argType.isInterface() ? ConfigurationFile.compatibleMethods(this.type, argType) : this.type.isInterface() && !argType.isArray() && !Modifier.isFinal(argType.getModifiers()) || argType.isInterface() && !this.type.isArray() && !Modifier.isFinal(this.type.getModifiers())) {
                    return this.type;
                }
            }
            this.oops("cannot convert '" + Utilities.typeString(argType) + "' to '" + Utilities.typeString(this.type) + "'");
            return null;
        }

        @Override
        boolean isConstant() throws ConfigurationException {
            return this.arg.isConstant();
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            Object val = this.arg.eval(data);
            if (this.type.isPrimitive()) {
                if (Utilities.getPrimitiveType(val.getClass()) != this.type) {
                    val = ConfigurationFile.convertPrimitive(val, this.type);
                }
            } else if (val != null && !this.type.isInstance(val)) {
                this.oops("cannot convert '" + Utilities.typeString(val.getClass()) + "' to '" + Utilities.typeString(this.type) + "'");
            }
            return val;
        }
    }

    private class ClassLiteral
    extends ParseNode {
        private final String className;
        private final boolean isArray;
        private Class value;

        ClassLiteral(String className, boolean isArray, int lineno) {
            super(lineno);
            this.className = className;
            this.isArray = isArray;
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            Class<?> c = ConfigurationFile.this.findClass(this.className, this.lineno, this.override);
            if (this.isArray) {
                c = Array.newInstance(c, 0).getClass();
            }
            this.value = c;
            return Class.class;
        }

        @Override
        boolean isConstant() {
            return true;
        }

        @Override
        Object eval(Object data) {
            return this.value;
        }
    }

    private class StringLiteral
    extends ParseNode {
        private final String value;

        StringLiteral(String value, int lineno) {
            super(lineno);
            this.value = value;
        }

        @Override
        Class resolve(Entry inEntry) {
            return String.class;
        }

        @Override
        boolean isConstant() {
            return this.value.indexOf("${") < 0;
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            return ConfigurationFile.this.expandStringProperties(this.value, this.lineno);
        }
    }

    private class ThisRef
    extends Literal {
        ThisRef(int lineno) {
            super(ConfigurationFile.class, ConfigurationFile.this, lineno);
        }
    }

    private class Literal
    extends ParseNode {
        private final Class type;
        private final Object value;

        Literal(Class type, Object value, int lineno) {
            super(lineno);
            this.type = type;
            this.value = value;
        }

        @Override
        Class resolve(Entry inEntry) {
            return this.type;
        }

        @Override
        boolean isConstant() {
            return true;
        }

        @Override
        Object eval(Object data) {
            return this.value;
        }
    }

    private class NameRef
    extends ParseNode {
        private final String name;
        private final String fullName;
        private Entry entry;
        private Field field;

        NameRef(String component, String name, int lineno) {
            super(lineno);
            this.name = name;
            this.fullName = name.indexOf(46) < 0 ? component + '.' + name : name;
        }

        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            this.entry = (Entry)ConfigurationFile.this.entries.get(this.fullName);
            if (this.entry != null) {
                Class result = this.entry.resolve(inEntry);
                if (this.entry.getRefersToData()) {
                    if (inEntry.isStatic) {
                        this.oops("static entry '" + inEntry.fullName + "' cannot refer to entry '" + this.fullName + "', which uses '$data'");
                    }
                    inEntry.setRefersToData();
                }
                return result;
            }
            if (this.name.equals("$data")) {
                return Object.class;
            }
            if (this.name.equals("$loader")) {
                return ClassLoader.class;
            }
            if (this.name.startsWith("$") && this.name.indexOf(46) == -1) {
                try {
                    return ConfigurationFile.this.getSpecialEntryType(this.name);
                }
                catch (NoSuchEntryException e) {
                    this.oops("entry not found: " + this.name, this.lineno);
                }
                catch (ConfigurationException e) {
                    this.oops("problem referring to entry '" + this.name + "'", e);
                }
                catch (RuntimeException e) {
                    this.oops("problem referring to entry '" + this.name + "'", e);
                }
                return null;
            }
            this.field = ConfigurationFile.this.findField(this.name, this.lineno, this.override);
            return this.field.getType();
        }

        @Override
        boolean isConstant() throws ConfigurationException {
            return this.entry != null && this.entry.isConstant();
        }

        @Override
        Object eval(Object data) throws ConfigurationException {
            if (this.entry != null) {
                return this.entry.eval(data);
            }
            if (this.field != null) {
                try {
                    return this.field.get(null);
                }
                catch (IllegalAccessException e) {
                    this.oops("problem accessing field '" + this.name + "'", e);
                    return null;
                }
            }
            if (this.name.equals("$data")) {
                if (data == Configuration.NO_DATA) {
                    this.oops("no data specified for '$data'");
                }
                return data;
            }
            if (this.name.equals("$loader")) {
                SecurityManager sm;
                if (!ConfigurationFile.this.nonNullLoaderSupplied && (sm = System.getSecurityManager()) != null) {
                    sm.checkPermission(getClassLoaderPermission);
                }
                return ConfigurationFile.this.cl;
            }
            try {
                return ConfigurationFile.this.getSpecialEntry(this.name);
            }
            catch (ConfigurationException e) {
                this.oops("problem referring to entry '" + this.name + "'", e);
            }
            catch (RuntimeException e) {
                this.oops("problem referring to entry '" + this.name + "'", e);
            }
            return null;
        }
    }

    private class Entry
    extends ParseNode {
        final String component;
        final String fullName;
        private final ParseNode node;
        final boolean isPrivate;
        final boolean isStatic;
        final boolean isOverride;
        private Class type;
        private boolean resolved;
        private boolean resolving;
        private boolean isConstant;
        private boolean refersToData;
        private boolean evaluated;
        private boolean evaluating;
        private Object value;

        Entry(String component, String fullName, boolean isPrivate, boolean isStatic, boolean isOverride, int lineno, Parser parser) throws ConfigurationException, IOException {
            super(lineno);
            this.component = component;
            this.fullName = fullName;
            this.isPrivate = isPrivate;
            this.isStatic = isStatic;
            this.isOverride = isOverride;
            this.node = parser.parseExpr(this);
        }

        boolean getRefersToData() {
            return this.refersToData;
        }

        void setRefersToData() {
            this.refersToData = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Class resolve(Entry inEntry) throws ConfigurationException {
            Object object = ConfigurationFile.this.resolveLock;
            synchronized (object) {
                if (!this.resolved) {
                    if (this.resolving) {
                        this.oops("entry with circular reference: " + this.fullName);
                    }
                    this.resolving = true;
                    try {
                        this.type = this.node.resolve(this);
                        this.isConstant = this.node.isConstant();
                    }
                    finally {
                        this.resolving = false;
                    }
                    this.resolved = true;
                }
            }
            return this.type;
        }

        @Override
        boolean isConstant() throws ConfigurationException {
            this.resolve(this);
            return this.isConstant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object eval(Object data) throws ConfigurationException {
            this.resolve(this);
            if (!this.isStatic) {
                return this.node.eval(data);
            }
            Entry entry = this;
            synchronized (entry) {
                if (!this.evaluated) {
                    if (this.evaluating) {
                        this.oops("entry with circular reference: " + this.fullName);
                    }
                    this.evaluating = true;
                    try {
                        this.value = this.node.eval(Configuration.NO_DATA);
                    }
                    finally {
                        this.evaluating = false;
                    }
                    this.evaluated = true;
                }
            }
            return this.value;
        }
    }

    private abstract class ParseNode {
        final int lineno;
        final int override;

        ParseNode(int lineno) {
            this.lineno = lineno;
            this.override = ConfigurationFile.this.override;
        }

        abstract Class resolve(Entry var1) throws ConfigurationException;

        abstract boolean isConstant() throws ConfigurationException;

        abstract Object eval(Object var1) throws ConfigurationException;

        void oops(String what) throws ConfigurationException {
            ConfigurationFile.this.oops(what, this.lineno, this.override, null);
        }

        void oops(String what, int lineno) throws ConfigurationException {
            ConfigurationFile.this.oops(what, lineno, this.override, null);
        }

        void oops(String what, Throwable t) throws ConfigurationException {
            ConfigurationFile.this.oops(what, this.lineno, this.override, t);
        }
    }

    private static class PushbackStreamTokenizer
    extends StreamTokenizer {
        private boolean gotToken;
        private boolean pushedBack;
        private double savedNval;
        private String savedSval;
        private int savedTtype;
        private int savedLineno;

        PushbackStreamTokenizer(Reader reader) {
            super(reader);
        }

        @Override
        public int nextToken() throws IOException {
            if (this.pushedBack) {
                this.nval = this.savedNval;
                this.sval = this.savedSval;
                this.ttype = this.savedTtype;
                this.pushedBack = false;
            } else {
                this.savedNval = this.nval;
                this.savedSval = this.sval;
                this.savedTtype = this.ttype;
                this.savedLineno = this.lineno();
                super.nextToken();
                this.gotToken = true;
            }
            return this.ttype;
        }

        @Override
        public void pushBack() {
            if (this.gotToken && !this.pushedBack) {
                double tempNval = this.savedNval;
                this.savedNval = this.nval;
                this.nval = tempNval;
                String tempSval = this.savedSval;
                this.savedSval = this.sval;
                this.sval = tempSval;
                int tempTtype = this.savedTtype;
                this.savedTtype = this.ttype;
                this.ttype = tempTtype;
                this.pushedBack = true;
            }
        }

        @Override
        public int lineno() {
            return this.pushedBack ? this.savedLineno : super.lineno();
        }
    }
}

