/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import net.jini.core.constraint.ArraySet;
import net.jini.core.constraint.Constraint;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class ConstraintAlternatives
implements RelativeTimeConstraint,
Serializable {
    private static final long serialVersionUID = 7214615235302870613L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("constraints", InvocationConstraint[].class, true)};
    private final InvocationConstraint[] constraints;
    private transient boolean rel = false;

    public ConstraintAlternatives(InvocationConstraint[] constraints) {
        this.constraints = ConstraintAlternatives.reduce((InvocationConstraint[])constraints.clone());
        this.setRelative();
    }

    public ConstraintAlternatives(Collection c) {
        try {
            this.constraints = ConstraintAlternatives.reduce(c.toArray(new InvocationConstraint[c.size()]));
        }
        catch (ArrayStoreException e) {
            throw new IllegalArgumentException("element of collection is not an InvocationConstraint");
        }
        this.setRelative();
    }

    public static InvocationConstraint create(InvocationConstraint[] constraints) {
        return ConstraintAlternatives.reduce((InvocationConstraint[])constraints.clone(), false);
    }

    public static InvocationConstraint create(Collection c) {
        try {
            return ConstraintAlternatives.reduce(c.toArray(new InvocationConstraint[c.size()]), false);
        }
        catch (ArrayStoreException e) {
            throw new IllegalArgumentException("element of collection is not an InvocationConstraint");
        }
    }

    private ConstraintAlternatives(InvocationConstraint[] constraints, boolean allAbs) {
        this.constraints = constraints;
        if (!allAbs) {
            this.setRelative();
        }
    }

    private void setRelative() {
        int i = this.constraints.length;
        while (--i >= 0) {
            if (!(this.constraints[i] instanceof RelativeTimeConstraint)) continue;
            this.rel = true;
            return;
        }
    }

    boolean relative() {
        return this.rel;
    }

    private static InvocationConstraint reduce(InvocationConstraint[] constraints, boolean allAbs) {
        ConstraintAlternatives.verify(constraints, 1);
        int n = ConstraintAlternatives.reduce0(constraints);
        if (n == 1) {
            return constraints[0];
        }
        return new ConstraintAlternatives((InvocationConstraint[])Constraint.trim(constraints, n), allAbs);
    }

    private static void verify(InvocationConstraint[] constraints, int min) {
        if (constraints.length < min) {
            throw new IllegalArgumentException("cannot create constraint with " + (min == 1 ? "no" : "less than " + min) + " elements");
        }
        int i = constraints.length;
        while (--i >= 0) {
            InvocationConstraint c = constraints[i];
            if (c == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (!(c instanceof ConstraintAlternatives)) continue;
            throw new IllegalArgumentException("elements cannot be ConstraintAlternatives instances");
        }
    }

    private static InvocationConstraint[] reduce(InvocationConstraint[] constraints) {
        ConstraintAlternatives.verify(constraints, 2);
        int n = ConstraintAlternatives.reduce0(constraints);
        if (n == 1) {
            throw new IllegalArgumentException("reduced to less than 2 elements");
        }
        return (InvocationConstraint[])Constraint.trim(constraints, n);
    }

    private static int reduce0(InvocationConstraint[] constraints) {
        int i = 0;
        for (int j = 0; j < constraints.length; ++j) {
            InvocationConstraint c = constraints[j];
            if (Constraint.contains(constraints, i, c)) continue;
            constraints[i++] = c;
        }
        return i;
    }

    public Set elements() {
        return new ArraySet(this.constraints);
    }

    InvocationConstraint[] getConstraints() {
        return this.constraints;
    }

    @Override
    public InvocationConstraint makeAbsolute(long baseTime) {
        if (!this.rel) {
            return this;
        }
        InvocationConstraint[] vals = new InvocationConstraint[this.constraints.length];
        int i = vals.length;
        while (--i >= 0) {
            InvocationConstraint c = this.constraints[i];
            if (c instanceof RelativeTimeConstraint) {
                c = ((RelativeTimeConstraint)c).makeAbsolute(baseTime);
            }
            vals[i] = c;
        }
        return ConstraintAlternatives.reduce(vals, true);
    }

    public int hashCode() {
        return Constraint.hash(this.constraints);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConstraintAlternatives && Constraint.equal(this.constraints, ((ConstraintAlternatives)obj).constraints);
    }

    public String toString() {
        return "ConstraintAlternatives" + Constraint.toString(this.constraints);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.constraints == null) {
            throw new InvalidObjectException("cannot create constraint with no elements");
        }
        try {
            ConstraintAlternatives.verify(this.constraints, 2);
        }
        catch (RuntimeException e) {
            if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
                InvalidObjectException ee = new InvalidObjectException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
            throw e;
        }
        int i = this.constraints.length;
        while (--i >= 0) {
            if (!Constraint.contains(this.constraints, i, this.constraints[i])) continue;
            throw new InvalidObjectException("cannot create constraint with duplicate elements");
        }
        this.setRelative();
    }
}

