/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.discovery;

import com.sun.jini.jeri.internal.runtime.Util;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.SocketFactory;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupLocator
implements Serializable {
    private static final long serialVersionUID = 1448769379829432795L;
    private static final short discoveryPort = 4160;
    private static final int protoVersion = 1;
    protected String host;
    protected int port;
    protected SocketFactory sf;
    static final int defaultTimeout = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            Integer timeout = 60000;
            try {
                Integer val = Integer.getInteger("net.jini.discovery.timeout", timeout);
                return val < 0 ? timeout : val;
            }
            catch (SecurityException e) {
                return timeout;
            }
        }
    });

    public LookupLocator(String url) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            MalformedURLException mue = new MalformedURLException("URI parsing failure: " + url);
            mue.initCause(e);
            throw mue;
        }
        if (!uri.isAbsolute()) {
            throw new MalformedURLException("no scheme specified: " + url);
        }
        if (uri.isOpaque()) {
            throw new MalformedURLException("not a hierarchical url: " + url);
        }
        if (!uri.getScheme().toLowerCase().equals("jini")) {
            throw new MalformedURLException("Invalid URL scheme: " + url);
        }
        String uriPath = uri.getPath();
        if (uriPath.length() != 0 && !uriPath.equals("/")) {
            throw new MalformedURLException("URL path contains path segments: " + url);
        }
        if (uri.getQuery() != null) {
            throw new MalformedURLException("invalid character, '?', in URL: " + url);
        }
        if (uri.getFragment() != null) {
            throw new MalformedURLException("invalid character, '#', in URL: " + url);
        }
        try {
            uri = uri.parseServerAuthority();
            if (uri.getUserInfo() != null) {
                throw new MalformedURLException("invalid character, '@', in URL host: " + url);
            }
            this.host = uri.getHost();
            if (this.host == null) {
                throw new MalformedURLException("Not a hierarchical URL: " + url);
            }
            this.port = uri.getPort();
            if (this.port == -1) {
                this.port = 4160;
            }
        }
        catch (URISyntaxException e) {
            this.handle3986Authority(uri);
        }
        if (this.port <= 0 || this.port >= 65536) {
            throw new MalformedURLException("port number out of range: " + url);
        }
    }

    public LookupLocator(String host, int port) {
        URI uri;
        block8: {
            if (host == null) {
                throw new NullPointerException("null host");
            }
            if (port <= 0 || port >= 65536) {
                throw new IllegalArgumentException("port number out of range");
            }
            try {
                uri = new URI(null, null, host, port, null, null, null);
                if (uri.getUserInfo() != null) {
                    throw new IllegalArgumentException("invalid character, '@', in host: " + host);
                }
                this.host = host;
                this.port = port;
            }
            catch (URISyntaxException e) {
                uri = this.try3986Authority(host, port);
                if ($assertionsDisabled || this.port > 0 && this.port < 65536) break block8;
                throw new AssertionError();
            }
        }
        String uriPath = uri.getPath();
        if (uriPath.length() != 0) {
            throw new IllegalArgumentException("invalid character, '/', in host: " + host);
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("invalid character, '?', in host: " + host);
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("invalid character, '#', in host: " + host);
        }
    }

    public LookupLocator(String host, int port, SocketFactory sf) {
        this(host, port);
        this.sf = sf;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServiceRegistrar getRegistrar() throws IOException, ClassNotFoundException {
        return this.getRegistrar(defaultTimeout);
    }

    public ServiceRegistrar getRegistrar(int timeout) throws IOException, ClassNotFoundException {
        InetAddress[] addrs = null;
        try {
            addrs = InetAddress.getAllByName(this.host);
        }
        catch (UnknownHostException uhe) {
            Socket sock = this.sf == null ? new Socket(this.host, this.port) : this.sf.createSocket(this.host, this.port);
            return LookupLocator.getRegistrarFromSocket(sock, timeout);
        }
        IOException ioEx = null;
        SecurityException secEx = null;
        ClassNotFoundException cnfEx = null;
        for (int i = 0; i < addrs.length; ++i) {
            try {
                Socket sock = this.sf == null ? new Socket(addrs[i], this.port) : this.sf.createSocket(addrs[i], this.port);
                return LookupLocator.getRegistrarFromSocket(sock, timeout);
            }
            catch (ClassNotFoundException ex) {
                cnfEx = ex;
                continue;
            }
            catch (IOException ex) {
                ioEx = ex;
                continue;
            }
            catch (SecurityException ex) {
                secEx = ex;
            }
        }
        if (cnfEx != null) {
            throw cnfEx;
        }
        if (ioEx != null) {
            throw ioEx;
        }
        assert (secEx != null);
        throw secEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceRegistrar getRegistrarFromSocket(Socket sock, int timeout) throws IOException, ClassNotFoundException {
        try {
            sock.setSoTimeout(timeout);
            try {
                sock.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                // empty catch block
            }
            try {
                sock.setKeepAlive(true);
            }
            catch (SocketException e) {
                // empty catch block
            }
            DataOutputStream dstr = new DataOutputStream(sock.getOutputStream());
            dstr.writeInt(1);
            dstr.flush();
            ObjectInputStream istr = new ObjectInputStream(sock.getInputStream());
            ServiceRegistrar registrar = (ServiceRegistrar)((MarshalledObject)istr.readObject()).get();
            int grpCount = istr.readInt();
            while (--grpCount >= 0) {
                istr.readUTF();
            }
            ServiceRegistrar serviceRegistrar = registrar;
            return serviceRegistrar;
        }
        finally {
            try {
                sock.close();
            }
            catch (IOException e) {}
        }
    }

    public String toString() {
        if (this.port != 4160) {
            return "jini://" + LookupLocator.getHost0(this.host) + ":" + this.port + "/";
        }
        return "jini://" + LookupLocator.getHost0(this.host) + "/";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LookupLocator) {
            LookupLocator oo = (LookupLocator)o;
            return this.port == oo.port && this.host.equalsIgnoreCase(oo.host) && Util.sameClassAndEquals(this.sf, oo.sf);
        }
        return false;
    }

    public int hashCode() {
        return this.host.toLowerCase().hashCode() ^ this.port ^ (this.sf != null ? this.sf.hashCode() : 0);
    }

    private static String getHost0(String host) {
        if (host.indexOf(58) >= 0 && host.charAt(0) != '[') {
            return '[' + host + ']';
        }
        return host;
    }

    private URI try3986Authority(String host, int port) {
        try {
            URI u = new URI("jini://" + host + ":" + port);
            this.handle3986Authority(u);
            return u;
        }
        catch (URISyntaxException use) {
            IllegalArgumentException iae = new IllegalArgumentException("syntax error in host: " + host);
            iae.initCause(use);
            throw iae;
        }
        catch (MalformedURLException mue) {
            IllegalArgumentException iae = new IllegalArgumentException("syntax error in host: " + host);
            iae.initCause(mue);
            throw iae;
        }
    }

    private void handle3986Authority(URI uri) throws MalformedURLException {
        assert (!uri.isOpaque());
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new MalformedURLException("Missing authority: " + uri);
        }
        if (authority.indexOf(64) != -1) {
            throw new MalformedURLException("invalid character, '@', in host: " + uri);
        }
        this.parseHostPort(authority, uri);
    }

    private void parseHostPort(String authority, URI uri) throws MalformedURLException {
        int portInt;
        int index = authority.lastIndexOf(58);
        if (index == -1) {
            this.port = 4160;
            this.host = authority;
            return;
        }
        if (authority.indexOf(58) != index) {
            throw new MalformedURLException(": not allowed in host name: " + uri);
        }
        String portString = authority.substring(index + 1);
        if (portString.length() == 0) {
            throw new MalformedURLException("invalid port in authority: " + uri);
        }
        try {
            portInt = Integer.parseInt(portString);
        }
        catch (NumberFormatException ne) {
            MalformedURLException mue = new MalformedURLException("invalid port in authority: " + uri);
            mue.initCause(ne);
            throw mue;
        }
        this.port = portInt;
        this.host = authority.substring(0, index);
        if (this.host.length() == 0) {
            throw new MalformedURLException("zero length host name: " + uri);
        }
    }
}

