/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.UnicastSocketTimeout;
import com.sun.jini.discovery.internal.MultiIPDiscovery;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.ArrayList;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;

public final class ConstrainableLookupLocator
extends LookupLocator
implements RemoteMethodControl {
    private static final long serialVersionUID = 7061417093114347317L;
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final Method getRegistrarMethod;
    private static final Method getRegistrarTimeoutMethod;
    private final MethodConstraints constraints;

    public ConstrainableLookupLocator(String url, MethodConstraints constraints) throws MalformedURLException {
        super(url);
        this.constraints = constraints;
    }

    public ConstrainableLookupLocator(String host, int port, MethodConstraints constraints) {
        super(host, port);
        this.constraints = constraints;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 79 * hash + (this.constraints != null ? this.constraints.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof ConstrainableLookupLocator) {
            ConstrainableLookupLocator that = (ConstrainableLookupLocator)o;
            if (this.constraints != null ? this.constraints.equals(that.constraints) : this.constraints == that.constraints) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ServiceRegistrar getRegistrar() throws IOException, ClassNotFoundException {
        return this.getRegistrar(this.constraints != null ? this.constraints.getConstraints(getRegistrarMethod) : InvocationConstraints.EMPTY);
    }

    @Override
    public ServiceRegistrar getRegistrar(int timeout) throws IOException, ClassNotFoundException {
        InvocationConstraints ic = this.constraints != null ? this.constraints.getConstraints(getRegistrarTimeoutMethod) : InvocationConstraints.EMPTY;
        ArrayList<UnicastSocketTimeout> reqs = new ArrayList<UnicastSocketTimeout>(ic.requirements());
        reqs.add(new UnicastSocketTimeout(timeout));
        return this.getRegistrar(new InvocationConstraints(reqs, ic.preferences()));
    }

    @Override
    public String toString() {
        return "ConstrainableLookupLocator[[" + super.toString() + "], [" + this.constraints + "]]";
    }

    @Override
    public RemoteMethodControl setConstraints(MethodConstraints constraints) {
        return new ConstrainableLookupLocator(this.host, this.port, constraints);
    }

    @Override
    public MethodConstraints getConstraints() {
        return this.constraints;
    }

    private ServiceRegistrar getRegistrar(InvocationConstraints constraints) throws IOException, ClassNotFoundException {
        UnicastResponse resp = new MultiIPDiscovery(){

            @Override
            protected UnicastResponse performDiscovery(Discovery disco, DiscoveryConstraints dc, Socket s) throws IOException, ClassNotFoundException {
                return disco.doUnicastDiscovery(s, dc.getUnfulfilledConstraints(), null, null, null);
            }
        }.getResponse(this.host, this.port, constraints);
        return resp.getRegistrar();
    }

    static {
        try {
            getRegistrarMethod = LookupLocator.class.getMethod("getRegistrar", new Class[0]);
            getRegistrarTimeoutMethod = LookupLocator.class.getMethod("getRegistrar", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

