/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import net.jini.core.lookup.ServiceID;

public class IncomingMulticastRequest {
    protected InetAddress addr;
    protected int port;
    protected ServiceID[] serviceIDs;
    protected String[] groups;
    protected final int protoVersion = 1;

    public IncomingMulticastRequest(DatagramPacket dgram) throws IOException {
        ByteArrayInputStream bs = new ByteArrayInputStream(dgram.getData());
        DataInputStream ds = new DataInputStream(bs);
        int proto = ds.readInt();
        if (proto != 1) {
            throw new IOException("unsupported protocol version: " + proto);
        }
        this.port = ds.readInt();
        if (this.port <= 0 || this.port >= 65536) {
            throw new IOException("port number out of range: " + this.port);
        }
        int sidCount = ds.readInt();
        if (sidCount < 0 || sidCount > bs.available() / 8) {
            throw new IOException("service ID count invalid: " + sidCount);
        }
        this.serviceIDs = new ServiceID[sidCount];
        for (int i = 0; i < this.serviceIDs.length; ++i) {
            this.serviceIDs[i] = new ServiceID(ds);
        }
        int grpCount = ds.readInt();
        if (grpCount < 0 || grpCount > bs.available() / 2) {
            throw new IOException("group count invalid: " + grpCount);
        }
        this.groups = new String[grpCount];
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = ds.readUTF();
        }
        this.addr = dgram.getAddress();
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public ServiceID[] getServiceIDs() {
        return this.serviceIDs;
    }

    public int hashCode() {
        int i;
        byte[] foo = this.addr.getAddress();
        int code = foo[0] << 3 ^ foo[1] << 7 ^ foo[2] << 5 ^ foo[3] << 1 ^ ~this.port;
        for (i = 0; i < this.groups.length; ++i) {
            code ^= this.groups[i].hashCode() << i;
        }
        for (i = 0; i < this.serviceIDs.length; ++i) {
            code ^= this.serviceIDs[i].hashCode() << i;
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof IncomingMulticastRequest) {
            IncomingMulticastRequest oo = (IncomingMulticastRequest)o;
            if (oo.addr.equals(this.addr) && oo.port == this.port && oo.groups.length == this.groups.length && oo.serviceIDs.length == this.serviceIDs.length) {
                int i;
                for (i = 0; i < this.groups.length; ++i) {
                    if (this.groups[i].equals(oo.groups[i])) continue;
                    return false;
                }
                for (i = 0; i < this.serviceIDs.length; ++i) {
                    if (this.serviceIDs[i].equals(oo.serviceIDs[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

