/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Vector;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.Constants;

public class OutgoingMulticastAnnouncement {
    protected static final int minMaxPacketSize = 512;
    protected static final int maxPacketSize = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return Integer.getInteger("net.jini.discovery.mtu", 512);
            }
            catch (SecurityException e) {
                return 512;
            }
        }
    });
    protected static final int protocolVersion = 1;

    public static DatagramPacket[] marshal(ServiceID id, LookupLocator loc, String[] groups) throws IOException {
        if (maxPacketSize < 512) {
            throw new RuntimeException("value of net.jini.discovery.mtu property is less than 512");
        }
        ByteArrayOutputStream hbs = new ByteArrayOutputStream();
        DataOutputStream hos = new DataOutputStream(hbs);
        hos.writeInt(1);
        hos.writeUTF(loc.getHost());
        hos.writeInt(loc.getPort());
        id.writeBytes(hos);
        byte[] marshaledHeader = hbs.toByteArray();
        if (marshaledHeader.length > maxPacketSize) {
            throw new IllegalArgumentException("host name marshals too large");
        }
        byte[][] marshaledGroups = new byte[groups.length][];
        int longestGroup = -1;
        for (int i = 0; i < groups.length; ++i) {
            ByteArrayOutputStream gbs = new ByteArrayOutputStream();
            DataOutputStream gos = new DataOutputStream(gbs);
            gos.writeUTF(groups[i]);
            gos.flush();
            marshaledGroups[i] = gbs.toByteArray();
            if (marshaledHeader.length + 4 + 4 + marshaledGroups[i].length > maxPacketSize) {
                throw new IllegalArgumentException("group name marshals too large (" + marshaledGroups[i].length + " bytes)");
            }
            if (marshaledGroups[i].length <= longestGroup) continue;
            longestGroup = marshaledGroups[i].length;
        }
        Vector<DatagramPacket> reqs = new Vector<DatagramPacket>();
        InetAddress addr = Constants.getAnnouncementAddress();
        if (groups.length == 0) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(maxPacketSize);
            DataOutputStream os = new DataOutputStream(bs);
            os.write(marshaledHeader);
            os.writeInt(0);
            byte[] payload = bs.toByteArray();
            reqs.add(new DatagramPacket(payload, payload.length, addr, 4160));
        } else {
            int curr = 0;
            while (curr < marshaledGroups.length) {
                int last;
                ByteArrayOutputStream bs = new ByteArrayOutputStream(maxPacketSize);
                DataOutputStream os = new DataOutputStream(bs);
                os.write(marshaledHeader);
                os.flush();
                int bytes = bs.size() + 4;
                for (last = curr; last < marshaledGroups.length && bytes + marshaledGroups[last].length <= maxPacketSize; ++last) {
                    bytes += marshaledGroups[last].length;
                }
                os.writeInt(last - curr);
                while (curr < last) {
                    os.write(marshaledGroups[curr++]);
                }
                os.flush();
                byte[] payload = bs.toByteArray();
                reqs.add(new DatagramPacket(payload, payload.length, addr, 4160));
            }
        }
        Iterator iter2 = reqs.iterator();
        DatagramPacket[] ary = new DatagramPacket[reqs.size()];
        int i = 0;
        while (iter2.hasNext()) {
            ary[i] = (DatagramPacket)iter2.next();
            ++i;
        }
        return ary;
    }
}

