/*
 * Decompiled with CFR 0.152.
 */
package net.jini.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.jini.core.entry.Entry;

public abstract class AbstractEntry
implements Entry {
    static final long serialVersionUID = 5071868345060424804L;
    private static WeakHashMap fieldArrays;

    protected AbstractEntry() {
    }

    public boolean equals(Object other) {
        if (!(other instanceof Entry)) {
            return false;
        }
        return AbstractEntry.equals(this, (Entry)other);
    }

    public static boolean equals(Entry e1, Entry e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.getClass() != e2.getClass()) {
            return false;
        }
        Field[] fields = AbstractEntry.fieldInfo(e1);
        try {
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Object ov = f.get(e1);
                Object tv = f.get(e2);
                if (tv == ov) continue;
                if (tv == null || ov == null) {
                    return false;
                }
                if (tv.equals(ov)) continue;
                return false;
            }
            return true;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return AbstractEntry.hashCode(this);
    }

    public static int hashCode(Entry entry) {
        if (entry == null) {
            return 0;
        }
        int hash = 0;
        Field[] fields = AbstractEntry.fieldInfo(entry);
        try {
            for (int i = 0; i < fields.length; ++i) {
                Object tv = fields[i].get(entry);
                if (tv == null) continue;
                hash ^= tv.hashCode();
            }
            return hash;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return AbstractEntry.toString(this);
    }

    public static String toString(Entry entry) {
        if (entry == null) {
            return "null";
        }
        Field[] fields = AbstractEntry.fieldInfo(entry);
        StringBuffer str = new StringBuffer(entry.getClass().getName());
        str.append('(');
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field f = fields[i];
                if (i > 0) {
                    str.append(',');
                }
                str.append(f.getName());
                str.append('=');
                str.append(f.get(entry));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        str.append(')');
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field[] fieldInfo(Entry entry) {
        Field[] fields = null;
        Class<AbstractEntry> clazz = AbstractEntry.class;
        synchronized (AbstractEntry.class) {
            if (fieldArrays == null) {
                fieldArrays = new WeakHashMap();
            } else {
                fields = (Field[])fieldArrays.get(entry.getClass());
                if (fields != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return fields;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int SKIP_MODIFIERS = 152;
            fields = entry.getClass().getFields();
            ArrayList<Field> usable = null;
            for (int i = 0; i < fields.length; ++i) {
                if ((fields[i].getModifiers() & 0x98) != 0 || fields[i].getType().isPrimitive()) {
                    if (usable != null) continue;
                    usable = new ArrayList<Field>();
                    for (int j = 0; j < i; ++j) {
                        usable.add(fields[j]);
                    }
                    continue;
                }
                if (usable == null) continue;
                usable.add(fields[i]);
            }
            if (usable != null) {
                fields = usable.toArray(new Field[usable.size()]);
            }
            Class<AbstractEntry> clazz2 = AbstractEntry.class;
            synchronized (AbstractEntry.class) {
                fieldArrays.put(entry.getClass(), fields);
                // ** MonitorExit[var4_7] (shouldn't be in output)
                return fields;
            }
        }
    }
}

