/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.ExportPermission;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.Security;

public abstract class AbstractILFactory
implements InvocationLayerFactory {
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    private final ClassLoader loader;

    protected AbstractILFactory() {
        this(null);
    }

    protected AbstractILFactory(ClassLoader loader) {
        this.loader = loader;
    }

    private static Class[] combineInterfaces(Class[] i1, Class[] i2) {
        ArrayList list = new ArrayList(i1.length + i2.length);
        AbstractILFactory.addInterfaces(list, i1);
        AbstractILFactory.addInterfaces(list, i2);
        return list.toArray(new Class[list.size()]);
    }

    private static void addInterfaces(ArrayList list, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Class cl = interfaces[i];
            if (cl == null) {
                throw new NullPointerException("array contains null element");
            }
            if (list.contains(cl)) continue;
            list.add(cl);
        }
    }

    protected final ClassLoader getClassLoader() {
        return this.loader;
    }

    protected Class[] getProxyInterfaces(Remote impl) throws ExportException {
        return AbstractILFactory.combineInterfaces(this.getRemoteInterfaces(impl), this.getExtraProxyInterfaces(impl));
    }

    protected Class[] getRemoteInterfaces(Remote impl) throws ExportException {
        if (impl == null) {
            throw new NullPointerException("impl is null");
        }
        try {
            return Util.getRemoteInterfaces(impl.getClass());
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("cannot get proxy interfaces", e);
        }
    }

    protected Class[] getExtraProxyInterfaces(Remote impl) throws ExportException {
        if (impl == null) {
            throw new NullPointerException("impl is null");
        }
        return new Class[]{RemoteMethodControl.class};
    }

    protected Collection getInvocationDispatcherMethods(Remote impl) throws ExportException {
        Class[] interfaces = this.getRemoteInterfaces(impl);
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            Class intf = interfaces[i];
            boolean nonpublic = AbstractILFactory.checkNonPublicInterface(intf);
            Util.checkPackageAccess(intf);
            Method[] interfaceMethods = intf.getMethods();
            for (int j = interfaceMethods.length - 1; j >= 0; --j) {
                final Method m = interfaceMethods[j];
                if (nonpublic) {
                    Security.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            m.setAccessible(true);
                            return null;
                        }
                    });
                }
                methodMap.put(Util.getMethodNameAndDescriptor(m), m);
            }
        }
        HashSet methods = new HashSet();
        methods.addAll(methodMap.values());
        return methods;
    }

    private static boolean checkNonPublicInterface(Class intf) {
        if (!Modifier.isPublic(intf.getModifiers())) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                String pString = "exportRemoteInterface." + intf.getName();
                sm.checkPermission(new ExportPermission(pString));
            }
            return true;
        }
        return false;
    }

    protected abstract InvocationHandler createInvocationHandler(Class[] var1, Remote var2, ObjectEndpoint var3) throws ExportException;

    protected abstract InvocationDispatcher createInvocationDispatcher(Collection var1, Remote var2, ServerCapabilities var3) throws ExportException;

    @Override
    public InvocationLayerFactory.Instances createInstances(Remote impl, ObjectEndpoint oe, ServerCapabilities caps) throws ExportException {
        Remote proxy;
        ClassLoader proxyLoader;
        if (impl == null || oe == null || caps == null) {
            throw new NullPointerException();
        }
        Class[] interfaces = this.getProxyInterfaces(impl);
        InvocationHandler handler = this.createInvocationHandler(interfaces, impl, oe);
        if (this.loader != null) {
            proxyLoader = this.loader;
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(getClassLoaderPermission);
            }
            proxyLoader = impl.getClass().getClassLoader();
        }
        for (int i = 0; i < interfaces.length; ++i) {
            Util.checkPackageAccess(interfaces[i].getClass());
        }
        try {
            proxy = (Remote)Proxy.newProxyInstance(proxyLoader, interfaces, handler);
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("unable to create proxy", e);
        }
        InvocationDispatcher dispatcher = this.createInvocationDispatcher(this.getInvocationDispatcherMethods(impl), impl, caps);
        return new InvocationLayerFactory.Instances(proxy, dispatcher);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && ((AbstractILFactory)obj).loader == this.loader;
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

