/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.connection;

import com.sun.jini.jeri.internal.mux.MuxServer;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;

public final class ServerConnectionManager {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.ServerConnectionManager");

    private static void logThrow(Logger logger, String method, String msg, Object[] args, Exception e) {
        LogRecord lr = new LogRecord(Levels.HANDLED, msg);
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(ServerConnectionManager.class.getName());
        lr.setSourceMethodName(method);
        lr.setParameters(args);
        lr.setThrown(e);
        logger.log(lr);
    }

    public void handleConnection(ServerConnection conn, RequestDispatcher dispatcher) {
        if (conn == null || dispatcher == null) {
            throw new NullPointerException();
        }
        InboundMux.create(conn, dispatcher);
    }

    private static final class InboundMux
    extends MuxServer {
        private final ServerConnection c;

        private InboundMux(ServerConnection c, RequestDispatcher dispatcher) throws IOException {
            super(c.getOutputStream(), c.getInputStream(), dispatcher);
            this.c = c;
        }

        private InboundMux(ServerConnection c, RequestDispatcher dispatcher, boolean ignore) throws IOException {
            super(c.getChannel(), dispatcher);
            this.c = c;
        }

        static void create(ServerConnection c, RequestDispatcher dispatcher) {
            Dispatcher d = new Dispatcher(dispatcher, c);
            try {
                if (c.getChannel() == null) {
                    new InboundMux(c, (RequestDispatcher)d).start();
                } else {
                    new InboundMux(c, d, true).start();
                }
            }
            catch (IOException e) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    ServerConnectionManager.logThrow(logger, "handleConnection", "{0} throws", new Object[]{c}, e);
                }
                try {
                    c.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void handleDown() {
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class Inbound
    implements InboundRequest {
        private final InboundRequest req;
        private final ServerConnection c;
        private final InboundRequestHandle handle;

        Inbound(InboundRequest req, ServerConnection c, InboundRequestHandle handle) {
            this.req = req;
            this.c = c;
            this.handle = handle;
        }

        @Override
        public void populateContext(Collection context) {
            this.req.populateContext(context);
            this.c.populateContext(this.handle, context);
        }

        @Override
        public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
            return this.c.checkConstraints(this.handle, constraints);
        }

        @Override
        public void checkPermissions() {
            this.c.checkPermissions(this.handle);
        }

        @Override
        public InputStream getRequestInputStream() {
            return this.req.getRequestInputStream();
        }

        @Override
        public OutputStream getResponseOutputStream() {
            return this.req.getResponseOutputStream();
        }

        @Override
        public void abort() {
            this.req.abort();
        }
    }

    private static final class Dispatcher
    implements RequestDispatcher {
        private final RequestDispatcher dispatcher;
        private final ServerConnection c;

        Dispatcher(RequestDispatcher dispatcher, ServerConnection c) {
            this.dispatcher = dispatcher;
            this.c = c;
        }

        @Override
        public void dispatch(InboundRequest req) {
            block2: {
                try {
                    Inbound sreq = new Inbound(req, this.c, this.c.processRequestData(req.getRequestInputStream(), req.getResponseOutputStream()));
                    sreq.checkPermissions();
                    this.dispatcher.dispatch(sreq);
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block2;
                    ServerConnectionManager.logThrow(logger, "dispatchRequest", "{0} throws", new Object[]{this.c}, e);
                }
            }
        }
    }
}

