/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.logging.Levels;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.jeri.ssl.FilterX509TrustManager;
import net.jini.jeri.ssl.SubjectCredentials;

abstract class AuthManager
extends FilterX509TrustManager
implements X509KeyManager {
    private final WeakReference subjectRef;
    final boolean subjectIsReadOnly;
    private final Set permittedLocalPrincipals;

    AuthManager(Subject subject, Set permittedLocalPrincipals, Set permittedRemotePrincipals) throws NoSuchAlgorithmException {
        super(permittedRemotePrincipals);
        this.subjectRef = new WeakReference<Subject>(subject);
        this.subjectIsReadOnly = subject == null || subject.isReadOnly();
        this.permittedLocalPrincipals = permittedLocalPrincipals == null ? null : new HashSet(permittedLocalPrincipals);
    }

    abstract X500PrivateCredential getPrivateCredential(X509Certificate var1);

    abstract Logger getLogger();

    Subject getSubject() {
        return (Subject)this.subjectRef.get();
    }

    String[] getAliases(String keyType, Principal[] issuers) {
        List certPaths = SubjectCredentials.getCertificateChains(this.getSubject());
        if (certPaths == null) {
            return null;
        }
        ArrayList<String> result = null;
        int i = certPaths.size();
        while (--i >= 0) {
            Logger logger;
            Exception exception;
            CertPath chain = (CertPath)certPaths.get(i);
            try {
                if (this.checkChain(chain, keyType, issuers) == null) continue;
                if (result == null) {
                    result = new ArrayList<String>(certPaths.size());
                }
                result.add(SubjectCredentials.getCertificateName(AuthManager.firstX509Cert(chain)));
                continue;
            }
            catch (GeneralSecurityException e) {
                exception = e;
            }
            catch (SecurityException e) {
                exception = e;
            }
            if (!(logger = this.getLogger()).isLoggable(Levels.HANDLED)) continue;
            AuthManager.logThrow(logger, Levels.HANDLED, AuthManager.class, "getAliases", "get aliases for key type {0}\nand issuers {1}\ncaught exception", new Object[]{keyType, AuthManager.toString(issuers)}, exception);
        }
        if (result == null) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    X500PrivateCredential chooseCredential(String keyType, Principal[] issuers) throws GeneralSecurityException {
        List certPaths = SubjectCredentials.getCertificateChains(this.getSubject());
        if (certPaths == null) {
            return null;
        }
        ArrayList<GeneralSecurityException> exceptions = null;
        int i = certPaths.size();
        while (--i >= 0) {
            Exception exception;
            CertPath chain = (CertPath)certPaths.get(i);
            try {
                X500PrivateCredential pc = this.checkChain(chain, keyType, issuers);
                if (pc == null) continue;
                return pc;
            }
            catch (GeneralSecurityException e) {
                exception = e;
            }
            catch (SecurityException e) {
                exception = e;
            }
            if (exceptions == null) {
                exceptions = new ArrayList<GeneralSecurityException>();
            }
            exceptions.add((GeneralSecurityException)exception);
            Logger logger = this.getLogger();
            if (!logger.isLoggable(Levels.HANDLED)) continue;
            AuthManager.logThrow(logger, Levels.HANDLED, AuthManager.class, "chooseCredential", "choose credential for key type {0}\nand issuers {1}\ncaught exception", new Object[]{keyType, AuthManager.toString(issuers)}, exception);
        }
        if (exceptions == null) {
            return null;
        }
        if (exceptions.size() > 1) {
            i = exceptions.size();
            while (--i >= 0) {
                Exception e = (Exception)exceptions.get(i);
                if (e instanceof SecurityException) continue;
                throw new GeneralSecurityException(((Object)exceptions).toString());
            }
            throw new SecurityException(((Object)exceptions).toString());
        }
        if (exceptions.get(0) instanceof SecurityException) {
            throw (SecurityException)exceptions.get(0);
        }
        throw (GeneralSecurityException)exceptions.get(0);
    }

    private X500PrivateCredential checkChain(CertPath chain, String keyType, Principal[] issuers) throws GeneralSecurityException {
        X509Certificate head = AuthManager.firstX509Cert(chain);
        String certKeyType = head.getPublicKey().getAlgorithm();
        if (!certKeyType.equals(keyType)) {
            return null;
        }
        Subject subject = this.getSubject();
        X500Principal principal = SubjectCredentials.getPrincipal(subject, head);
        if (principal == null) {
            throw new GeneralSecurityException("Principal not found: " + head.getSubjectDN());
        }
        if (this.permittedLocalPrincipals != null && !this.permittedLocalPrincipals.contains(principal)) {
            throw new GeneralSecurityException("Local principal not permitted: " + head.getSubjectDN());
        }
        X500Principal[] x500Issuers = null;
        if (issuers != null) {
            x500Issuers = new X500Principal[issuers.length];
            int i = issuers.length;
            while (--i >= 0) {
                x500Issuers[i] = issuers[i] instanceof X500Principal ? (X500Principal)issuers[i] : new X500Principal(issuers[i].getName());
            }
        }
        AuthManager.checkValidity(chain, x500Issuers);
        boolean[] keyUsage = head.getKeyUsage();
        if (keyUsage != null && keyUsage.length > 0 && !keyUsage[0]) {
            throw new CertificateException("Certificate not permitted for digital signatures: " + head);
        }
        X500PrivateCredential xpc = this.getPrivateCredential(head);
        if (xpc == null) {
            throw new KeyException("Private key not found for certificate: " + head);
        }
        return xpc;
    }

    static long certificatesValidUntil(CertPath chain) {
        long result = Long.MAX_VALUE;
        List<? extends Certificate> certs = chain.getCertificates();
        int i = certs.size();
        while (--i >= 0) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            long until = cert.getNotAfter().getTime();
            if (until >= result) continue;
            result = until;
        }
        return result;
    }

    static long certificatesValidUntil(X509Certificate[] chain) {
        long result = Long.MAX_VALUE;
        int i = chain.length;
        while (--i >= 0) {
            X509Certificate cert = chain[i];
            long until = cert.getNotAfter().getTime();
            if (until >= result) continue;
            result = until;
        }
        return result;
    }

    boolean equalPrivateCredentials(X500PrivateCredential cred1, X500PrivateCredential cred2) {
        if (cred1 == null || cred2 == null) {
            return false;
        }
        X509Certificate cert1 = cred1.getCertificate();
        X509Certificate cert2 = cred2.getCertificate();
        if (cert1 == null || cert2 == null || !AuthManager.safeEquals(cert1.getSubjectDN(), cert2.getSubjectDN())) {
            return false;
        }
        PrivateKey key1 = cred1.getPrivateKey();
        return key1 != null && key1.equals(cred2.getPrivateKey());
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        CertPath chain = SubjectCredentials.getCertificateChain(this.getSubject(), alias);
        List<? extends Certificate> certs = chain.getCertificates();
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        block4: {
            CertPath chain = SubjectCredentials.getCertificateChain(this.getSubject(), alias);
            if (chain != null) {
                try {
                    X500PrivateCredential xpc = this.getPrivateCredential(AuthManager.firstX509Cert(chain));
                    if (xpc != null) {
                        return xpc.getPrivateKey();
                    }
                }
                catch (SecurityException e) {
                    Logger logger = this.getLogger();
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    AuthManager.logThrow(logger, Levels.HANDLED, AuthManager.class, "getPrivateKey", "get private key for alias {0}\ncaught exception", new Object[]{alias}, e);
                }
            }
        }
        return null;
    }
}

