/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.jeri.internal.http.ConnectionTimer;
import com.sun.jini.jeri.internal.http.HttpServerConnection;
import com.sun.jini.jeri.internal.http.HttpServerManager;
import com.sun.jini.jeri.internal.http.HttpSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.ssl.HttpsEndpoint;
import net.jini.jeri.ssl.SslServerEndpointImpl;
import net.jini.jeri.ssl.Utilities;

public final class HttpsServerEndpoint
implements ServerEndpoint {
    static final Logger logger = Utilities.serverLogger;
    static final HttpServerManager httpServerManager;
    static final ConnectionTimer connectionTimer;
    private final HttpsServerEndpointImpl impl;

    public static HttpsServerEndpoint getInstance(int port) {
        return new HttpsServerEndpoint(null, null, null, port, null, null);
    }

    public static HttpsServerEndpoint getInstance(String serverHost, int port) {
        return new HttpsServerEndpoint(null, null, serverHost, port, null, null);
    }

    public static HttpsServerEndpoint getInstance(String serverHost, int port, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new HttpsServerEndpoint(null, null, serverHost, port, socketFactory, serverSocketFactory);
    }

    public static HttpsServerEndpoint getInstance(Subject serverSubject, X500Principal[] serverPrincipals, String serverHost, int port) {
        return new HttpsServerEndpoint(serverSubject, serverPrincipals, serverHost, port, null, null);
    }

    public static HttpsServerEndpoint getInstance(Subject serverSubject, X500Principal[] serverPrincipals, String serverHost, int port, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new HttpsServerEndpoint(serverSubject, serverPrincipals, serverHost, port, socketFactory, serverSocketFactory);
    }

    private HttpsServerEndpoint(Subject serverSubject, X500Principal[] serverPrincipals, String serverHost, int port, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.impl = new HttpsServerEndpointImpl(this, serverSubject, serverPrincipals, serverHost, port, socketFactory, serverSocketFactory);
        logger.log(Level.FINE, "created {0}", this);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public Set getPrincipals() {
        return this.impl.serverPrincipals == null ? null : Collections.unmodifiableSet(this.impl.serverPrincipals);
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.impl.serverSocketFactory;
    }

    public String toString() {
        return "HttpsServerEndpoint" + this.impl.fieldsToString();
    }

    @Override
    public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        return this.impl.checkConstraints(constraints);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof HttpsServerEndpoint && this.impl.equals(((HttpsServerEndpoint)object).impl);
    }

    @Override
    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        return this.impl.enumerateListenEndpoints(listenContext);
    }

    static {
        HttpSettings hs = HttpsEndpoint.getHttpSettings();
        httpServerManager = new HttpServerManager(hs.getResponseAckTimeout());
        connectionTimer = new ConnectionTimer(hs.getServerConnectionTimeout());
    }

    private static final class HttpsServerEndpointImpl
    extends SslServerEndpointImpl {
        HttpsServerEndpointImpl(ServerEndpoint serverEndpoint, Subject serverSubject, X500Principal[] serverPrincipals, String serverHost, int port, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
            super(serverEndpoint, serverSubject, serverPrincipals, serverHost, port, socketFactory, serverSocketFactory);
        }

        @Override
        ServerEndpoint.ListenEndpoint createListenEndpoint() {
            return new HttpsListenEndpoint();
        }

        @Override
        Endpoint createEndpoint(String serverHost, SslServerEndpointImpl.SslListenCookie cookie) {
            return HttpsEndpoint.getInstance(serverHost, cookie.getPort(), this.socketFactory);
        }

        private final class HttpsServerConnection
        extends SslServerEndpointImpl.SslServerConnection {
            HttpServer httpServer;

            HttpsServerConnection(HttpsListenHandle listenHandle, Socket socket) throws IOException {
                super(HttpsServerEndpointImpl.this, listenHandle, socket);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void closeInternal(boolean removeFromListener) throws IOException {
                HttpsServerConnection httpsServerConnection = this;
                synchronized (httpsServerConnection) {
                    if (this.closed) {
                        return;
                    }
                }
                super.closeInternal(removeFromListener);
                if (this.httpServer != null) {
                    this.httpServer.shutdown(true);
                    this.httpServer = null;
                }
            }
        }

        private static final class HttpsInboundRequest
        implements InboundRequest {
            private final InboundRequest request;
            private final ServerConnection connection;
            private final InboundRequestHandle handle;

            HttpsInboundRequest(InboundRequest request, ServerConnection connection, InboundRequestHandle handle) {
                this.request = request;
                this.connection = connection;
                this.handle = handle;
            }

            @Override
            public void checkPermissions() {
                this.connection.checkPermissions(this.handle);
            }

            @Override
            public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
                return this.connection.checkConstraints(this.handle, constraints);
            }

            @Override
            public void populateContext(Collection context) {
                this.request.populateContext(context);
                this.connection.populateContext(this.handle, context);
            }

            @Override
            public InputStream getRequestInputStream() {
                return this.request.getRequestInputStream();
            }

            @Override
            public OutputStream getResponseOutputStream() {
                return this.request.getResponseOutputStream();
            }

            @Override
            public void abort() {
                this.request.abort();
            }
        }

        private static final class HttpsRequestDispatcher
        extends Utilities
        implements RequestDispatcher {
            private final RequestDispatcher requestDispatcher;
            private final HttpsServerConnection connection;

            HttpsRequestDispatcher(RequestDispatcher requestDispatcher, HttpsServerConnection connection) {
                this.requestDispatcher = requestDispatcher;
                this.connection = connection;
            }

            @Override
            public void dispatch(InboundRequest request) {
                block2: {
                    try {
                        HttpsInboundRequest wrappedRequest = new HttpsInboundRequest(request, this.connection, this.connection.processRequestData(request.getRequestInputStream(), request.getResponseOutputStream()));
                        wrappedRequest.checkPermissions();
                        this.requestDispatcher.dispatch(wrappedRequest);
                    }
                    catch (SecurityException e) {
                        if (!SslServerEndpointImpl.logger.isLoggable(Level.INFO)) break block2;
                        HttpsRequestDispatcher.logThrow(SslServerEndpointImpl.logger, Level.INFO, HttpsRequestDispatcher.class, "dispatch", "{0} throws", new Object[]{this.connection}, e);
                    }
                }
            }
        }

        private static final class HttpServer
        extends HttpServerConnection {
            private final HttpsServerConnection connection;

            HttpServer(Socket socket, RequestDispatcher requestDispatcher, HttpsServerConnection connection) throws IOException {
                super(socket, requestDispatcher, httpServerManager);
                this.connection = connection;
                connection.httpServer = this;
                this.start();
            }

            @Override
            protected void checkPermissions() {
                throw new AssertionError();
            }

            @Override
            protected void populateContext(Collection context) {
            }

            @Override
            protected InvocationConstraints checkConstraints(InvocationConstraints constraints) {
                throw new AssertionError();
            }

            @Override
            protected void idle() {
                connectionTimer.scheduleTimeout(this, false);
            }

            @Override
            protected void busy() {
                connectionTimer.cancelTimeout(this);
            }

            @Override
            public boolean shutdown(boolean force) {
                boolean result = super.shutdown(force);
                if (result) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                connectionTimer.cancelTimeout(this);
                return result;
            }
        }

        private final class HttpsListenHandle
        extends SslServerEndpointImpl.SslListenHandle {
            HttpsListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
                super(HttpsServerEndpointImpl.this, requestDispatcher, serverSocket);
            }

            @Override
            SslServerEndpointImpl.SslServerConnection serverConnection(Socket socket) throws IOException {
                return new HttpsServerConnection(this, socket);
            }

            @Override
            void handleConnection(SslServerEndpointImpl.SslServerConnection connection, RequestDispatcher requestDispatcher) {
                try {
                    new HttpServer((Socket)connection.sslSocket, (RequestDispatcher)new HttpsRequestDispatcher(requestDispatcher, (HttpsServerConnection)connection), (HttpsServerConnection)connection);
                }
                catch (IOException e) {
                    if (SslServerEndpointImpl.logger.isLoggable(Level.INFO)) {
                        HttpsListenHandle.logThrow(SslServerEndpointImpl.logger, Level.INFO, HttpsListenHandle.class, "handleConnection", "{0} throws", new Object[]{connection}, e);
                    }
                    try {
                        connection.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
            }
        }

        private final class HttpsListenEndpoint
        extends SslServerEndpointImpl.SslListenEndpoint {
            private HttpsListenEndpoint() {
                super(HttpsServerEndpointImpl.this);
            }

            @Override
            ServerEndpoint.ListenHandle createListenHandle(RequestDispatcher requestDispatcher, ServerSocket serverSocket) throws IOException {
                return new HttpsListenHandle(requestDispatcher, serverSocket);
            }
        }
    }
}

