/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.jeri.internal.connection.BasicConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.ConnectionContext;
import net.jini.jeri.ssl.SslConnection;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.AuthenticationPermission;

class SslEndpointImpl
extends Utilities
implements ConnectionEndpoint {
    static final Logger logger = clientLogger;
    private static final Map connectionMgrs = new WeakHashMap();
    private static final int CACHE_SIZE = 4;
    private static final ConnManagerFactory connectionManagerFactory = new BasicConnManagerFactory();
    final Endpoint endpoint;
    final String serverHost;
    final int port;
    final SocketFactory socketFactory;
    boolean disableSocketConnect;
    private ConnectionContextCache[] connectionContextCache = new ConnectionContextCache[4];
    private int cacheNext;
    ConnManager connectionManager;

    SslEndpointImpl(Endpoint endpoint, String serverHost, int port, SocketFactory socketFactory) {
        this.endpoint = endpoint;
        if (serverHost == null) {
            throw new NullPointerException("serverHost is null");
        }
        this.serverHost = serverHost;
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.port = port;
        this.socketFactory = socketFactory;
    }

    public String toString() {
        return SslEndpointImpl.getClassName(this) + this.fieldsToString();
    }

    final String fieldsToString() {
        return "[" + this.serverHost + ":" + this.port + (this.socketFactory != null ? ", " + this.socketFactory : "") + "]";
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.serverHost.hashCode() ^ this.port ^ (this.socketFactory != null ? this.socketFactory.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SslEndpointImpl other = (SslEndpointImpl)object;
        return this.serverHost.equals(other.serverHost) && this.port == other.port && Util.sameClassAndEquals(this.socketFactory, other.socketFactory);
    }

    final OutboundRequestIterator newRequest(InvocationConstraints constraints) {
        if (constraints == null) {
            throw new NullPointerException("Constraints cannot be null");
        }
        try {
            return this.newRequest(this.getCallContext(constraints));
        }
        catch (UnsupportedConstraintException e) {
            return new ExceptionOutboundRequestIterator(e);
        }
        catch (SecurityException e) {
            return new ExceptionOutboundRequestIterator(e);
        }
    }

    OutboundRequestIterator newRequest(CallContext callContext) {
        return this.getConnectionManager().newRequest(callContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnManager getConnectionManager() {
        Map map = connectionMgrs;
        synchronized (map) {
            if (this.connectionManager == null) {
                Reference ref = (Reference)connectionMgrs.get(this);
                ConnManager connManager = this.connectionManager = ref != null ? (ConnManager)ref.get() : null;
                if (this.connectionManager == null) {
                    this.connectionManager = connectionManagerFactory.create(this);
                    connectionMgrs.put(this, new WeakReference<ConnManager>(this.connectionManager));
                }
            }
            return this.connectionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallContext getCallContext(InvocationConstraints constraints) throws UnsupportedConstraintException {
        final AccessControlContext acc = AccessController.getContext();
        Subject clientSubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(acc);
            }
        });
        Set<Principal> clientPrincipals = SslEndpointImpl.getClientPrincipals(constraints.requirements());
        boolean requiredClient = clientPrincipals != null;
        boolean constrainedServer = SslEndpointImpl.getServerPrincipals(constraints) != null;
        Boolean getSubject = null;
        if (!requiredClient) {
            if (clientSubject == null) {
                clientPrincipals = Collections.EMPTY_SET;
            } else {
                Set<Principal> set = clientSubject.getPrincipals();
                synchronized (set) {
                    clientPrincipals = clientSubject.getPrincipals(X500Principal.class);
                }
            }
            if (clientPrincipals.isEmpty() && (getSubject = SslEndpointImpl.getSubjectPermitted()) == Boolean.FALSE) {
                clientPrincipals = Collections.singleton(UNKNOWN_PRINCIPAL);
            }
        }
        List contexts = new CopyOnRemoveList(this.getConnectionContexts(constraints, clientPrincipals));
        if (constrainedServer) {
            try {
                contexts = SslEndpointImpl.checkAuthenticationPermissions(contexts);
            }
            catch (SecurityException e) {
                if (!requiredClient && getSubject == null) {
                    getSubject = SslEndpointImpl.getSubjectPermitted();
                }
                if (requiredClient || getSubject == Boolean.TRUE) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "getCallContext", "new request for {0}\nwith {1}\nand {2}\nthrows", new Object[]{this.endpoint, constraints, SslEndpointImpl.subjectString(clientSubject)}, e);
                    }
                    throw e;
                }
                CallContext result = this.createCallContext(this.getConnectionContexts(constraints, Collections.singleton(UNKNOWN_PRINCIPAL)), null);
                if (logger.isLoggable(Levels.FAILED)) {
                    SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "getCallContext", "new request for {0}\nwith {1}\nand {2}\nwill fail but cannot throw because caller has no subject access\nreturns {3}\ncaught exception", new Object[]{this.endpoint, constraints, SslEndpointImpl.subjectString(clientSubject), result}, e);
                }
                return result;
            }
        }
        UnsupportedConstraintException unsupported = null;
        if (contexts.isEmpty()) {
            unsupported = new UnsupportedConstraintException("Constraints not supported: " + constraints);
        } else {
            boolean checkSubject;
            if (constrainedServer) {
                checkSubject = true;
            } else {
                if (getSubject == null) {
                    getSubject = SslEndpointImpl.getSubjectPermitted();
                }
                boolean bl = checkSubject = getSubject == Boolean.TRUE;
            }
            if (checkSubject) {
                try {
                    contexts = SslEndpointImpl.checkSubject(contexts, clientSubject, constrainedServer, constraints);
                }
                catch (UnsupportedConstraintException e) {
                    unsupported = e;
                }
            }
        }
        if (unsupported != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "getCallContext", "new request for {0}\nwith {1}\nand {2}\nthrows", new Object[]{this.endpoint, constraints, SslEndpointImpl.subjectString(clientSubject)}, unsupported);
            }
            throw unsupported;
        }
        CallContext result = this.createCallContext(contexts, clientSubject);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new request for {0}\nwith {1}\nand {2}\nreturns {3}", new Object[]{this.endpoint, constraints, SslEndpointImpl.subjectString(clientSubject), result});
        }
        return result;
    }

    private CallContext createCallContext(List contexts, Subject clientSubject) {
        boolean clientAuthRequired = true;
        boolean clientAuthPermitted = false;
        HashSet<Principal> clientPrincipals = null;
        HashSet<Principal> serverPrincipals = null;
        ArrayList<String> suites = new ArrayList<String>();
        boolean integrityRequired = false;
        boolean integrityPreferred = false;
        long connectionTimeout = -1L;
        int max = contexts.size();
        for (int i = 0; i < max; ++i) {
            ConnectionContext context = (ConnectionContext)contexts.get(i);
            if (context.client == null) {
                clientAuthRequired = false;
            } else {
                clientAuthPermitted = true;
                if (clientPrincipals == null) {
                    clientPrincipals = new HashSet<Principal>();
                }
                if (context.client != UNKNOWN_PRINCIPAL) {
                    clientPrincipals.add(context.client);
                }
            }
            if (context.server != null && context.server != UNKNOWN_PRINCIPAL) {
                if (serverPrincipals == null) {
                    serverPrincipals = new HashSet<Principal>();
                }
                serverPrincipals.add(context.server);
            }
            if (!suites.contains(context.cipherSuite)) {
                suites.add(context.cipherSuite);
            }
            if (context.getIntegrityRequired()) {
                integrityRequired = true;
            } else if (context.getIntegrityPreferred()) {
                integrityPreferred = true;
            }
            if (context.getConnectionTime() == -1L || connectionTimeout != -1L && connectionTimeout <= context.getConnectionTime()) continue;
            connectionTimeout = context.getConnectionTime();
        }
        return new CallContext(this.endpoint, this, clientAuthPermitted ? clientSubject : null, clientAuthRequired, clientPrincipals, serverPrincipals, suites, integrityRequired, integrityPreferred, connectionTimeout);
    }

    private static List checkSubject(List contexts, Subject clientSubject, boolean constrainedServer, InvocationConstraints constraints) throws UnsupportedConstraintException {
        Map publicCreds = SslEndpointImpl.getPublicCredentials(clientSubject);
        X500PrivateCredential[] privateCreds = clientSubject != null && constrainedServer ? (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(clientSubject)) : new X500PrivateCredential[]{};
        HashSet<Principal> missingPublic = new HashSet<Principal>();
        HashSet<Principal> missingPrivate = new HashSet<Principal>();
        int i = contexts.size();
        block0: while (--i >= 0) {
            ConnectionContext context = (ConnectionContext)contexts.get(i);
            if (context.client == null) continue;
            Collection certs = (Collection)publicCreds.get(context.client);
            if (certs == null) {
                logger.log(Levels.HANDLED, "missing principal or public credentials: {0}", context.client);
                contexts.remove(i);
                missingPublic.add(context.client);
                continue;
            }
            if (!constrainedServer) continue;
            int j = privateCreds.length;
            while (--j >= 0) {
                X509Certificate cert = privateCreds[j].getCertificate();
                if (cert == null || !certs.contains(cert)) continue;
                continue block0;
            }
            logger.log(Levels.HANDLED, "missing private credentials: {0}", context.client);
            contexts.remove(i);
            missingPrivate.add(context.client);
        }
        if (!contexts.isEmpty()) {
            return contexts;
        }
        throw new UnsupportedConstraintException("Constraints not supported: " + constraints + ";" + (missingPublic.isEmpty() ? "" : "\nmissing principals or public credentials: " + missingPublic) + (missingPrivate.isEmpty() ? "" : "\nmissing private credentials: " + missingPrivate));
    }

    private static Boolean getSubjectPermitted() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(getSubjectPermission);
            }
            catch (SecurityException e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private static List checkAuthenticationPermissions(List contexts) {
        if (contexts.isEmpty()) {
            return contexts;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return contexts;
        }
        HashMap<AuthenticationPermission, Boolean> perms = new HashMap<AuthenticationPermission, Boolean>();
        HashSet<SecurityException> exceptions = new HashSet<SecurityException>();
        int i = contexts.size();
        while (--i >= 0) {
            ConnectionContext context = (ConnectionContext)contexts.get(i);
            if (context.client == null) continue;
            if (context.server == UNKNOWN_PRINCIPAL) break;
            AuthenticationPermission p = new AuthenticationPermission(Collections.singleton(context.client), Collections.singleton(context.server), "connect");
            Object value = perms.get(p);
            if (Boolean.FALSE.equals(value)) {
                contexts.remove(i);
                continue;
            }
            if (Boolean.TRUE.equals(value)) continue;
            try {
                sm.checkPermission(p);
                perms.put(p, Boolean.TRUE);
            }
            catch (SecurityException e) {
                logger.log(Levels.HANDLED, "check authentication permission caught exception", e);
                perms.put(p, Boolean.FALSE);
                exceptions.add(e);
                contexts.remove(i);
            }
        }
        if (!contexts.isEmpty()) {
            return contexts;
        }
        if (exceptions.size() == 1) {
            throw (SecurityException)exceptions.iterator().next();
        }
        throw new SecurityException(((Object)exceptions).toString());
    }

    private static Map getPublicCredentials(Subject subject) {
        HashMap<X500Principal, ArrayList<X509Certificate>> publicCreds = new HashMap<X500Principal, ArrayList<X509Certificate>>();
        List certPaths = SubjectCredentials.getCertificateChains(subject);
        if (certPaths != null) {
            int i = certPaths.size();
            while (--i >= 0) {
                CertPath chain = (CertPath)certPaths.get(i);
                X509Certificate cert = SubjectCredentials.firstX509Cert(chain);
                X500Principal p = SubjectCredentials.getPrincipal(subject, cert);
                if (p == null) continue;
                ArrayList<X509Certificate> certs = (ArrayList<X509Certificate>)publicCreds.get(p);
                if (certs == null) {
                    certs = new ArrayList<X509Certificate>(1);
                    publicCreds.put(p, certs);
                }
                certs.add(cert);
            }
        }
        return publicCreds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConnectionContexts(InvocationConstraints constraints, Set clientPrincipals) {
        ConnectionContextCache[] connectionContextCacheArray = this.connectionContextCache;
        synchronized (this.connectionContextCache) {
            int i = 4;
            while (--i >= 0) {
                ConnectionContextCache cache = this.connectionContextCache[i];
                if (cache == null || !cache.constraints.equals(constraints) || !cache.clientPrincipals.equals(clientPrincipals)) continue;
                logger.log(Level.FINEST, "used connection cache");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return cache.connectionContexts;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Set<Principal> serverPrincipals = SslEndpointImpl.getServerPrincipals(constraints);
            if (serverPrincipals == null) {
                serverPrincipals = Collections.singleton(UNKNOWN_PRINCIPAL);
            }
            List contexts = Collections.unmodifiableList(SslEndpointImpl.computeConnectionContexts(SslEndpointImpl.getSupportedCipherSuites(), clientPrincipals, serverPrincipals, constraints));
            ConnectionContextCache[] connectionContextCacheArray2 = this.connectionContextCache;
            synchronized (this.connectionContextCache) {
                this.connectionContextCache[this.cacheNext] = new ConnectionContextCache(constraints, clientPrincipals, contexts);
                if (this.cacheNext == 0) {
                    this.cacheNext = 4;
                }
                --this.cacheNext;
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return contexts;
            }
        }
    }

    private static List computeConnectionContexts(String[] suites, Set clients, Set servers, InvocationConstraints constraints) {
        ArrayList<Object> result = new ArrayList<Object>(suites.length * (clients.size() + 1) * (servers.size() + 1));
        int suiteIndex = suites.length;
        while (--suiteIndex >= 0) {
            Principal client;
            String suite = suites[suiteIndex];
            Iterator cIter = clients.iterator();
            do {
                Principal server;
                if (cIter.hasNext()) {
                    client = (Principal)cIter.next();
                    assert (client != null);
                } else {
                    client = null;
                }
                Iterator sIter = servers.iterator();
                do {
                    if (sIter.hasNext()) {
                        server = (Principal)sIter.next();
                        assert (server != null);
                    } else {
                        server = null;
                    }
                    int i = 2;
                    while (--i >= 0) {
                        boolean integrity = i == 0;
                        ConnectionContext context = ConnectionContext.getInstance(suite, client, server, integrity, true, constraints);
                        if (context == null) continue;
                        result.add(new ComparableConnectionContext(context, suiteIndex));
                    }
                } while (server != null);
            } while (client != null);
        }
        Collections.sort(result);
        logger.log(Level.FINEST, "compute connection contexts produces {0}", result);
        int i = result.size();
        while (--i >= 0) {
            ComparableConnectionContext ccc = (ComparableConnectionContext)result.get(i);
            result.set(i, ccc.context);
        }
        return result;
    }

    @Override
    public Connection connect(OutboundRequestHandle handle) throws IOException {
        SslConnection connection = new SslConnection(CallContext.coerce(handle, this.endpoint), this.serverHost, this.port, this.socketFactory);
        connection.establishCallContext();
        return connection;
    }

    @Override
    public Connection connect(OutboundRequestHandle handle, Collection active, Collection idle) {
        CallContext context = CallContext.coerce(handle, this.endpoint);
        if (active == null || idle == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        SslConnection result = null;
        boolean checkedResolvePermission = false;
        ConnectionsIterator iter2 = new ConnectionsIterator(this.endpoint, active, idle);
        while (iter2.hasNext()) {
            SslConnection connection;
            block16: {
                boolean usingProxy;
                connection = (SslConnection)iter2.next();
                if (!connection.useFor(context)) continue;
                String phost = connection.getProxyHost();
                boolean bl = usingProxy = phost.length() != 0;
                if (usingProxy) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        try {
                            sm.checkConnect(this.serverHost, this.port);
                        }
                        catch (SecurityException e) {
                            if (logger.isLoggable(Levels.FAILED)) {
                                SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "connect", "choose connection for {0}\nthrows", new Object[]{this}, e);
                            }
                            throw e;
                        }
                    }
                } else {
                    if (!checkedResolvePermission) {
                        try {
                            this.checkResolvePermission();
                        }
                        catch (SecurityException e) {
                            if (logger.isLoggable(Levels.FAILED)) {
                                LogUtil.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "connect", "exception resolving host {0}", new Object[]{this.serverHost}, e);
                            }
                            throw e;
                        }
                        checkedResolvePermission = true;
                    }
                    try {
                        if (!connection.checkConnectPermission()) {
                        }
                        break block16;
                    }
                    catch (SecurityException e) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        LogUtil.logThrow(logger, Levels.HANDLED, SslEndpointImpl.class, "nextRequest", "access to reuse connection {0} denied", new Object[]{connection}, e);
                    }
                    continue;
                }
            }
            result = connection;
            break;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "choose connection for {0}\nwith active {1}\nand idle {2}\nreturns {3}", new Object[]{handle, active, idle, result});
        }
        return result;
    }

    private void checkResolvePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(this.serverHost, -1);
        }
    }

    private static final class ConnectionsIterator
    implements Iterator {
        private final Endpoint endpoint;
        private Collection active;
        private final Collection idle;
        private Iterator iter;

        ConnectionsIterator(Endpoint endpoint, Collection active, Collection idle) {
            this.endpoint = endpoint;
            this.active = active;
            this.idle = idle;
            this.iter = active.iterator();
            if (!this.iter.hasNext()) {
                this.active = null;
                this.iter = idle.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.iter.next();
            if (next == null) {
                throw new NullPointerException("Connection cannot be null");
            }
            if (!(next instanceof SslConnection)) {
                throw new IllegalArgumentException("Connection must be of type SslConnection: " + next);
            }
            SslConnection result = (SslConnection)next;
            if (!this.endpoint.equals(result.callContext.endpoint)) {
                throw new IllegalArgumentException("Connection has wrong endpoint: found " + result.callContext.endpoint + ", expected " + this.endpoint);
            }
            if (!this.iter.hasNext() && this.active != null) {
                this.active = null;
                this.iter = this.idle.iterator();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ComparableConnectionContext
    implements Comparable {
        final ConnectionContext context;
        private final int suiteIndex;

        ComparableConnectionContext(ConnectionContext context, int suiteIndex) {
            this.context = context;
            this.suiteIndex = suiteIndex;
        }

        public int compareTo(Object object) {
            ComparableConnectionContext other = (ComparableConnectionContext)object;
            int result = other.context.getPreferences() - this.context.getPreferences();
            if (result == 0) {
                result = this.suiteIndex - other.suiteIndex;
            }
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("ComparableConnectionContext[");
            this.context.fieldsToString(sb);
            sb.append(", index: ").append(this.suiteIndex);
            sb.append("]");
            return sb.toString();
        }
    }

    private static final class ConnectionContextCache {
        final InvocationConstraints constraints;
        final Set clientPrincipals;
        final List connectionContexts;

        ConnectionContextCache(InvocationConstraints constraints, Set clientPrincipals, List connectionContexts) {
            this.constraints = constraints;
            this.clientPrincipals = clientPrincipals;
            this.connectionContexts = connectionContexts;
        }
    }

    private static final class CopyOnRemoveList
    extends AbstractList {
        private List list;
        private boolean modified;

        CopyOnRemoveList(List list) {
            this.list = list;
        }

        @Override
        public Object get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Object remove(int index) {
            if (!this.modified) {
                this.list = new ArrayList(this.list);
                this.modified = true;
            }
            return this.list.remove(index);
        }
    }

    private static final class ExceptionOutboundRequestIterator
    implements OutboundRequestIterator {
        private final Exception exception;
        private boolean done = false;

        ExceptionOutboundRequestIterator(Exception exception) {
            this.exception = exception;
        }

        @Override
        public synchronized boolean hasNext() {
            return !this.done;
        }

        @Override
        public synchronized OutboundRequest next() throws IOException {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            if (this.exception instanceof SecurityException) {
                throw (SecurityException)this.exception;
            }
            throw (IOException)this.exception;
        }
    }
}

