/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lease;

import java.rmi.MarshalledObject;
import net.jini.core.lease.Lease;

public class LeaseUnmarshalException
extends Exception {
    private static final long serialVersionUID = -6736107321698417489L;
    private final Lease[] unmarshalledLeases;
    private final MarshalledObject[] stillMarshalledLeases;
    private final Throwable[] exceptions;

    public LeaseUnmarshalException(String message, Lease[] leases, MarshalledObject[] marshalledLeases, Throwable[] exceptions) {
        super(message);
        this.validate(marshalledLeases, exceptions);
        this.unmarshalledLeases = leases;
        this.stillMarshalledLeases = marshalledLeases;
        this.exceptions = exceptions;
    }

    public LeaseUnmarshalException(Lease[] leases, MarshalledObject[] marshalledLeases, Throwable[] exceptions) {
        this.validate(marshalledLeases, exceptions);
        this.unmarshalledLeases = leases;
        this.stillMarshalledLeases = marshalledLeases;
        this.exceptions = exceptions;
    }

    private void validate(MarshalledObject[] marshalledLeases, Throwable[] exceptions) {
        if (exceptions.length != marshalledLeases.length) {
            throw new IllegalArgumentException("exceptions.length (" + exceptions.length + ") is not equal to marshalledLeases.length (" + marshalledLeases.length + ")");
        }
    }

    public Lease[] getLeases() {
        return this.unmarshalledLeases;
    }

    public MarshalledObject[] getMarshalledLeases() {
        return this.stillMarshalledLeases;
    }

    public Throwable[] getExceptions() {
        return this.exceptions;
    }
}

