/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader;

import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.loader.RiverClassLoaderSpi;

public class RiverClassLoader {
    private static final Logger logger = Logger.getLogger(RiverClassLoader.class.getName());
    private static final RiverClassLoaderSpi spi = AccessController.doPrivileged(new PrivilegedAction<RiverClassLoaderSpi>(){

        @Override
        public RiverClassLoaderSpi run() {
            return RiverClassLoader.initSpi();
        }
    });

    private static RiverClassLoaderSpi initSpi() {
        ServiceLoader<RiverClassLoaderSpi> loader = ServiceLoader.load(RiverClassLoaderSpi.class);
        Iterator<RiverClassLoaderSpi> iter2 = loader.iterator();
        if (iter2.hasNext()) {
            try {
                RiverClassLoaderSpi firstSpi = iter2.next();
                logger.log(Level.CONFIG, "loaded: {0}", firstSpi);
                return firstSpi;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "error loading RiverClassLoaderSpi: {0}", new Object[]{e});
                throw new Error(e);
            }
        }
        return new DefaultRiverClassLoaderSpi();
    }

    public static Class<?> loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return spi.loadClass(codebase, name, defaultLoader);
    }

    public static Class<?> loadProxyClass(String codebase, String[] interfaceNames, ClassLoader defaultLoader) throws ClassNotFoundException, MalformedURLException {
        return spi.loadProxyClass(codebase, interfaceNames, defaultLoader);
    }

    public static String getClassAnnotation(Class<?> cls) {
        return spi.getClassAnnotation(cls);
    }

    public static ClassLoader getClassLoader(String codebase) throws MalformedURLException, SecurityException {
        return spi.getClassLoader(codebase);
    }

    public static Class<?> loadClass(String location, String className) throws MalformedURLException, ClassNotFoundException {
        return spi.loadClass(location, className, null);
    }

    private RiverClassLoader() {
    }

    private static class DefaultRiverClassLoaderSpi
    extends RiverClassLoaderSpi {
        @Override
        public Class<?> loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
            return RMIClassLoader.loadClass(codebase, name, defaultLoader);
        }

        @Override
        public Class<?> loadProxyClass(String codebase, String[] interfaceNames, ClassLoader defaultLoader) throws ClassNotFoundException, MalformedURLException {
            return RMIClassLoader.loadProxyClass(codebase, interfaceNames, defaultLoader);
        }

        @Override
        public String getClassAnnotation(Class<?> cl) {
            return RMIClassLoader.getClassAnnotation(cl);
        }

        @Override
        public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
            return RMIClassLoader.getClassLoader(codebase);
        }
    }
}

