/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader.pref;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.cert.Certificate;

class CodeSourceWithPermissionsRequired
extends CodeSource {
    private static final long serialVersionUID = 1L;
    private Permission[] permissions;

    public CodeSourceWithPermissionsRequired(URL codebase, Certificate[] certs, Permission[] perms) {
        super(codebase, certs);
        this.permissions = (Permission[])perms.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        sb.append(super.toString()).append("\n").append("Information only, minimum Permissions required for execution:\n");
        int l = this.permissions.length;
        for (int i = 0; i < l; ++i) {
            sb.append(this.permissions[i].toString());
        }
        return sb.toString();
    }

    Permission[] required() {
        return (Permission[])this.permissions.clone();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.permissions = (Permission[])this.permissions.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

