/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader.pref;

import com.sun.jini.loader.pref.internal.PreferredResources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import net.jini.loader.ClassAnnotation;
import net.jini.loader.DownloadPermission;
import net.jini.loader.pref.PreferredFactoryClassLoader;

public class PreferredClassLoader
extends URLClassLoader
implements ClassAnnotation {
    private static final String PREF_NAME = "META-INF/PREFERRED.LIST";
    private final URL firstURL;
    private final String exportAnnotation;
    private final PermissionCollection permissions;
    private final AccessControlContext acc;
    private final boolean requireDlPerm;
    private final URLStreamHandler jarHandler;
    private PreferredResources preferredResources;
    private boolean preferredResourcesInitialized = false;
    private static final Permission downloadPermission = new DownloadPermission();
    private static final Set<String> existSet = new HashSet<String>(11);

    public PreferredClassLoader(URL[] urls, ClassLoader parent, String exportAnnotation, boolean requireDlPerm) {
        this(urls, parent, exportAnnotation, requireDlPerm, null);
    }

    public PreferredClassLoader(URL[] urls, ClassLoader parent, String exportAnnotation, boolean requireDlPerm, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.firstURL = urls.length > 0 ? urls[0] : null;
        this.exportAnnotation = exportAnnotation != null ? exportAnnotation : PreferredClassLoader.urlsToPath(urls);
        this.requireDlPerm = requireDlPerm;
        this.jarHandler = factory != null ? factory.createURLStreamHandler("jar") : null;
        this.acc = AccessController.getContext();
        this.permissions = new Permissions();
        PreferredClassLoader.addPermissionsForURLs(urls, this.permissions, false);
    }

    static String urlsToPath(URL[] urls) {
        if (urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuffer path = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }

    public static PreferredClassLoader newInstance(final URL[] urls, final ClassLoader parent, final String exportAnnotation, final boolean requireDlPerm) {
        Permissions perms = new Permissions();
        PreferredClassLoader.addPermissionsForURLs(urls, perms, false);
        PreferredClassLoader.checkPermissions(perms);
        AccessControlContext acc = PreferredClassLoader.getLoaderAccessControlContext(urls);
        return (PreferredClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new PreferredFactoryClassLoader(urls, parent, exportAnnotation, requireDlPerm);
            }
        }, acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePreferredResources() throws IOException {
        InputStream prefIn;
        assert (Thread.holdsLock(this));
        assert (this.preferredResources == null);
        if (this.firstURL != null && (prefIn = this.getPreferredInputStream(this.firstURL)) != null) {
            try {
                this.preferredResources = new PreferredResources(prefIn);
            }
            finally {
                try {
                    prefIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream getPreferredInputStream(URL firstURL) throws IOException {
        URL prefListURL = null;
        try {
            URL baseURL;
            if (firstURL.getFile().endsWith("/")) {
                baseURL = firstURL;
            } else if (this.jarExists(firstURL)) {
                baseURL = this.getBaseJarURL(firstURL);
            } else {
                return null;
            }
            prefListURL = new URL(baseURL, PREF_NAME);
            URLConnection preferredConnection = this.getPreferredConnection(prefListURL, false);
            if (preferredConnection != null) {
                return preferredConnection.getInputStream();
            }
            return null;
        }
        catch (IOException e) {
            if (firstURL.getProtocol().equals("file") || e instanceof FileNotFoundException) {
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jarExists(URL firstURL) throws IOException {
        boolean exists;
        Set<String> set = existSet;
        synchronized (set) {
            exists = existSet.contains(firstURL.toString());
        }
        if (!exists) {
            URL baseURL = this.getBaseJarURL(firstURL);
            try {
                ((JarURLConnection)baseURL.openConnection()).getManifest();
                exists = true;
            }
            catch (IOException e) {
            }
            catch (NullPointerException e) {
                System.err.println("NPE thrown while trying to open connection :" + baseURL);
                e.printStackTrace(System.err);
            }
            if (!exists) {
                boolean bl = exists = this.getPreferredConnection(firstURL, true) != null;
            }
            if (exists) {
                Set<String> set2 = existSet;
                synchronized (set2) {
                    existSet.add(firstURL.toString());
                }
            }
        }
        return exists;
    }

    private URL getBaseJarURL(final URL url) throws MalformedURLException {
        if (this.jarHandler == null) {
            return new URL("jar", "", -1, url + "!/");
        }
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL("jar", "", -1, url + "!/", PreferredClassLoader.this.jarHandler);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getCause();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URLConnection getPreferredConnection(URL url, boolean closeAfter) throws IOException {
        if (url.getProtocol().equals("file")) {
            return url.openConnection();
        }
        URLConnection closeConn = null;
        URLConnection conn = null;
        try {
            conn = closeConn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) return conn;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            if (closeAfter) {
                hconn.setRequestMethod("HEAD");
            }
            int responseCode = hconn.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 203: {
                    return conn;
                }
                case 403: 
                case 404: 
                case 410: {
                    conn = null;
                    return conn;
                }
                default: {
                    throw new IOException("Indefinite http response for preferred list request:" + hconn.getResponseMessage());
                }
            }
        }
        catch (RuntimeException e) {
            if (!(e instanceof NullPointerException) && !(e.getCause() instanceof NullPointerException)) throw e;
            throw new IOException(url.toString(), e);
        }
        finally {
            if (closeAfter && closeConn != null) {
                try {
                    closeConn.getInputStream().close();
                }
                catch (IOException e) {
                }
                catch (RuntimeException e) {
                    if (!(e instanceof NullPointerException) && !(e.getCause() instanceof NullPointerException)) throw e;
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    protected boolean isPreferredResource(final String name, final boolean isClass) throws IOException {
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    boolean b = PreferredClassLoader.this.isPreferredResource0(name, isClass);
                    return b;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private synchronized boolean isPreferredResource0(String name, boolean isClass) throws IOException {
        if (!this.preferredResourcesInitialized) {
            this.initializePreferredResources();
            this.preferredResourcesInitialized = true;
        }
        if (this.preferredResources == null) {
            return false;
        }
        String resourceName = name;
        if (isClass) {
            resourceName = name.replace('.', '/') + ".class";
        }
        boolean resourcePreferred = false;
        int state = this.preferredResources.getNameState(resourceName, isClass);
        switch (state) {
            case 1: {
                resourcePreferred = false;
                break;
            }
            case 3: {
                resourcePreferred = true;
                break;
            }
            case 0: {
                Boolean wildcardPref = this.preferredResources.getWildcardPreference(resourceName);
                if (wildcardPref == null) {
                    wildcardPref = this.preferredResources.getDefaultPreference();
                }
                if (!wildcardPref.booleanValue()) break;
                resourcePreferred = this.findResourceUpdateState(name, resourceName);
                break;
            }
            case 2: {
                resourcePreferred = this.findResourceUpdateState(name, resourceName);
                if (resourcePreferred) break;
                throw new IOException("no resource found for complete preferred name");
            }
            default: {
                throw new Error("unknown preference state");
            }
        }
        return resourcePreferred;
    }

    private boolean findResourceUpdateState(String name, String resourceName) throws IOException {
        assert (Thread.holdsLock(this));
        boolean resourcePreferred = false;
        if (this.findResource(resourceName) != null) {
            this.preferredResources.setNameState(resourceName, 3);
            resourcePreferred = true;
        }
        return resourcePreferred;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            boolean preferred;
            try {
                preferred = this.isPreferredResource(name, true);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name + " (could not determine preferred setting; " + (this.firstURL != null ? "first URL: \"" + this.firstURL + "\"" : "no URLs") + ")", e);
            }
            if (preferred) {
                c = this.findClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        try {
            return this.isPreferredResource(name, false) ? this.findResource(name) : super.getResource(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        try {
            return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
        catch (IllegalArgumentException e) {
            return this.getPackage(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public String getClassAnnotation() {
        return this.exportAnnotation;
    }

    void checkPermissions() {
        PreferredClassLoader.checkPermissions(this.permissions);
    }

    private static void checkPermissions(PermissionCollection perms) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Enumeration<Permission> en = perms.elements();
            while (en.hasMoreElements()) {
                sm.checkPermission(en.nextElement());
            }
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        ProtectionDomain pd;
        SecurityManager sm;
        if (this.requireDlPerm && (sm = System.getSecurityManager()) != null && !(pd = new ProtectionDomain(codeSource, null, this, null)).implies(downloadPermission)) {
            throw new SecurityException("CodeSource not permitted to define class: " + codeSource);
        }
        return super.getPermissions(codeSource);
    }

    public String toString() {
        return super.toString() + "[\"" + this.exportAnnotation + "\"]";
    }

    static AccessControlContext getLoaderAccessControlContext(URL[] urls) {
        PermissionCollection perms = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codesource = new CodeSource(null, (Certificate[])null);
                Policy p = Policy.getPolicy();
                if (p != null) {
                    return p.getPermissions(codesource);
                }
                return new Permissions();
            }
        });
        perms.add(new RuntimePermission("createClassLoader"));
        perms.add(new PropertyPermission("java.*", "read"));
        PreferredClassLoader.addPermissionsForURLs(urls, perms, true);
        ProtectionDomain pd = new ProtectionDomain(new CodeSource(urls.length > 0 ? urls[0] : null, (Certificate[])null), perms, null, null);
        return new AccessControlContext(new ProtectionDomain[]{pd});
    }

    static void addPermissionsForURLs(URL[] urls, PermissionCollection perms, boolean forLoader) {
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            try {
                Permission p2;
                URLConnection urlConnection = url.openConnection();
                Permission p = urlConnection.getPermission();
                if (p == null) continue;
                if (p instanceof FilePermission) {
                    String path = p.getName();
                    int endIndex = path.lastIndexOf(File.separatorChar);
                    if (endIndex != -1) {
                        if ((path = path.substring(0, endIndex + 1)).endsWith(File.separator)) {
                            path = path + "-";
                        }
                        if (perms.implies(p2 = new FilePermission(path, "read"))) continue;
                        perms.add(p2);
                        continue;
                    }
                    if (perms.implies(p)) continue;
                    perms.add(p);
                    continue;
                }
                if (!perms.implies(p)) {
                    perms.add(p);
                }
                if (!forLoader) continue;
                URL hostURL = url;
                URLConnection conn = urlConnection;
                while (conn instanceof JarURLConnection) {
                    hostURL = ((JarURLConnection)conn).getJarFileURL();
                    conn = hostURL.openConnection();
                }
                String host = hostURL.getHost();
                if (host == null || !p.implies(new SocketPermission(host, "resolve")) || perms.implies(p2 = new SocketPermission(host, "connect,accept"))) continue;
                perms.add(p2);
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

