/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader.pref;

import au.net.zeus.collection.RC;
import au.net.zeus.collection.Ref;
import com.sun.jini.action.GetPropertyAction;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.loader.ClassAnnotation;
import net.jini.loader.pref.PreferredClassLoader;
import org.apache.river.impl.net.UriString;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class PreferredClassProvider
extends RMIClassLoaderSpi {
    private static final String PRIMITIVE_TYPES = "BCDFIJSZ";
    private final boolean requireDlPerm;
    private final boolean initialized;
    private static final Logger logger = Logger.getLogger("net.jini.loader.pref.PreferredClassProvider");
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    private static String codebaseProperty = null;
    private static final Map localLoaders;
    private static final ConcurrentMap<LoaderKey, ClassLoader> loaderTable;
    private static final ConcurrentMap<List<URI>, URL[]> urlCache;
    private static final ConcurrentMap<String, URI[]> uriCache;
    private final ConcurrentMap<ClassLoader, PermissionCollection> classLoaderPerms;

    public PreferredClassProvider() {
        this(false);
    }

    protected PreferredClassProvider(boolean requireDlPerm) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.requireDlPerm = requireDlPerm;
        NonBlockingHashMap inter = new NonBlockingHashMap();
        this.classLoaderPerms = RC.concurrentMap(inter, Ref.WEAK_IDENTITY, Ref.STRONG, 200L, 200L);
        this.initialized = true;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new SecurityException("uninitialized instance");
        }
    }

    private void checkLoader(ClassLoader loader, ClassLoader parent, URI[] uris, URL[] urls) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && loader != null && loader != parent) {
            assert (this.urlsMatchLoaderAnnotation(uris, loader));
            if (loader.getClass() == PreferredClassLoader.class) {
                ((PreferredClassLoader)loader).checkPermissions();
            } else {
                PermissionCollection perms = (PermissionCollection)this.classLoaderPerms.get(loader);
                if (perms == null) {
                    perms = new Permissions();
                    PreferredClassLoader.addPermissionsForURLs(urls, perms, false);
                    perms.setReadOnly();
                    this.classLoaderPerms.putIfAbsent(loader, perms);
                }
                Enumeration<Permission> en = perms.elements();
                while (en.hasMoreElements()) {
                    sm.checkPermission(en.nextElement());
                }
            }
        }
    }

    public Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        this.checkInitialized();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "name=\"{0}\", codebase={1}, defaultLoader={2}", new Object[]{name, codebase != null ? "\"" + codebase + "\"" : null, defaultLoader});
        }
        URI[] codebaseURIs = PreferredClassProvider.pathToURIs(codebase);
        URL[] codebaseURLs = this.asURL(codebaseURIs);
        String elementTypeName = null;
        int len = name.length();
        if (len > 0 && name.charAt(0) == '[') {
            int i;
            char c = '\u0000';
            for (i = 1; i < len && (c = name.charAt(i)) == '['; ++i) {
            }
            if (len == i + 1 && PRIMITIVE_TYPES.indexOf(c) != -1) {
                return Class.forName(name);
            }
            if (len > i + 2 && c == 'L' && name.charAt(len - 1) == ';') {
                elementTypeName = name.substring(i + 1, len - 1);
            }
        }
        SecurityManager sm = System.getSecurityManager();
        if (defaultLoader != null && (sm == null || codebaseURIs == null || this.urlsMatchLoaderAnnotation(codebaseURIs, defaultLoader))) {
            try {
                Class<?> c = Class.forName(name, false, defaultLoader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{name, PreferredClassProvider.getClassLoader(c)});
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                defaultLoader = null;
            }
        }
        ClassLoader contextLoader = PreferredClassProvider.getRMIContextClassLoader();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "(thread context class loader: {0})", contextLoader);
        }
        ClassLoader codebaseLoader = this.lookupLoader(codebaseURIs, codebaseURLs, contextLoader);
        if (defaultLoader != null && !(codebaseLoader instanceof PreferredClassLoader)) {
            try {
                Class<?> c = Class.forName(name, false, defaultLoader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{name, PreferredClassProvider.getClassLoader(c)});
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                defaultLoader = null;
            }
        }
        SecurityException secEx = null;
        if (sm != null) {
            try {
                this.checkLoader(codebaseLoader, contextLoader, codebaseURIs, codebaseURLs);
            }
            catch (SecurityException e) {
                secEx = e;
            }
        }
        if (defaultLoader != null) {
            boolean tryDL;
            boolean bl = tryDL = secEx != null;
            if (!tryDL) {
                try {
                    tryDL = !((PreferredClassLoader)codebaseLoader).isPreferredResource(elementTypeName != null ? elementTypeName : name, true);
                }
                catch (IOException e) {
                    ClassNotFoundException cnfe = new ClassNotFoundException(name + " (could not determine preferred setting;" + " original codebase: \"" + codebase + "\")", e);
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found, could not obtain preferred value", new Object[]{name}, cnfe);
                    }
                    throw cnfe;
                }
            }
            if (tryDL) {
                try {
                    Class<?> c = Class.forName(name, false, defaultLoader);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{name, PreferredClassProvider.getClassLoader(c)});
                    }
                    return c;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        try {
            Class<?> c = Class.forName(name, false, sm != null && secEx == null ? codebaseLoader : contextLoader);
            if (logger.isLoggable(Level.FINEST)) {
                String message = sm == null ? "class \"{0}\" found  via thread context class loader  (no security manager), defined by {1}" : (secEx != null ? "class \"{0}\" found  via thread context class loader  (access to codebase loader denied), defined by {1}" : "class \"{0}\" found via codebase loader, defined by {1}");
                logger.log(Level.FINEST, message, new Object[]{name, PreferredClassProvider.getClassLoader(c)});
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            if (sm == null) {
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (no security manager: codebase loader disabled)", e);
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via thread context class loader (no security manager)", new Object[]{name}, cnfe);
                }
                throw cnfe;
            }
            if (secEx != null) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    LogUtil.logThrow(logger, Levels.HANDLED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via thread context class loader (access to codebase loader denied)", new Object[]{name}, e);
                }
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (access to codebase loader denied)", secEx);
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via thread context class loader (access to codebase loader denied)", new Object[]{name}, cnfe);
                }
                throw cnfe;
            }
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via codebase loader", new Object[]{name}, e);
            }
            throw e;
        }
    }

    public String getClassAnnotation(Class cl) {
        this.checkInitialized();
        String name = cl.getName();
        int nameLength = name.length();
        if (nameLength > 0 && name.charAt(0) == '[') {
            int i;
            for (i = 1; nameLength > i && name.charAt(i) == '['; ++i) {
            }
            if (nameLength > i && name.charAt(i) != 'L') {
                return null;
            }
        }
        return this.getLoaderAnnotation(PreferredClassProvider.getClassLoader(cl), true);
    }

    protected String getClassAnnotation(ClassLoader loader) {
        this.checkInitialized();
        return codebaseProperty;
    }

    private String getLoaderAnnotation(ClassLoader loader, boolean check) {
        if (PreferredClassProvider.isLocalLoader(loader)) {
            return this.getClassAnnotation(loader);
        }
        String annotation = null;
        if (loader instanceof ClassAnnotation) {
            annotation = ((ClassAnnotation)((Object)loader)).getClassAnnotation();
        } else if (loader instanceof URLClassLoader) {
            try {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                if (urls != null) {
                    SecurityManager sm;
                    if (check && (sm = System.getSecurityManager()) != null) {
                        Permissions perms = new Permissions();
                        for (int i = 0; i < urls.length; ++i) {
                            Permission p = urls[i].openConnection().getPermission();
                            if (p == null || perms.implies(p)) continue;
                            sm.checkPermission(p);
                            perms.add(p);
                        }
                    }
                    annotation = PreferredClassLoader.urlsToPath(urls);
                }
            }
            catch (SecurityException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (annotation != null) {
            return annotation;
        }
        return this.getClassAnnotation(loader);
    }

    private static boolean isLocalLoader(ClassLoader loader) {
        return loader == null || localLoaders.containsKey(loader);
    }

    @Override
    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        this.checkInitialized();
        URI[] codebaseURIs = PreferredClassProvider.pathToURIs(codebase);
        URL[] codebaseURLs = this.asURL(codebaseURIs);
        ClassLoader contextLoader = PreferredClassProvider.getRMIContextClassLoader();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return contextLoader;
        }
        sm.checkPermission(getClassLoaderPermission);
        ClassLoader codebaseLoader = this.lookupLoader(codebaseURIs, codebaseURLs, contextLoader);
        this.checkLoader(codebaseLoader, contextLoader, codebaseURIs, codebaseURLs);
        return codebaseLoader;
    }

    public Class loadProxyClass(String codebase, String[] interfaceNames, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        String loaderName;
        ClassLoader loader;
        this.checkInitialized();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "interfaces={0}, codebase={1}, defaultLoader={2}", new Object[]{Arrays.asList(interfaceNames), codebase != null ? "\"" + codebase + "\"" : null, defaultLoader});
        }
        URI[] codebaseURIs = PreferredClassProvider.pathToURIs(codebase);
        URL[] codebaseURLs = this.asURL(codebaseURIs);
        ClassLoader contextLoader = PreferredClassProvider.getRMIContextClassLoader();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "(thread context class loader: {0})", contextLoader);
        }
        ClassLoader codebaseLoader = this.lookupLoader(codebaseURIs, codebaseURLs, contextLoader);
        SecurityManager sm = System.getSecurityManager();
        SecurityException secEx = null;
        if (sm != null) {
            try {
                this.checkLoader(codebaseLoader, contextLoader, codebaseURIs, codebaseURLs);
            }
            catch (SecurityException e) {
                secEx = e;
            }
        }
        if (defaultLoader != null) {
            boolean tryDL;
            boolean codebaseMatchesDL = false;
            boolean bl = tryDL = sm == null || secEx != null || codebaseURIs == null;
            if (!tryDL) {
                codebaseMatchesDL = this.urlsMatchLoaderAnnotation(codebaseURIs, defaultLoader);
                boolean bl2 = tryDL = codebaseMatchesDL || !(codebaseLoader instanceof PreferredClassLoader) || !this.interfacePreferred((PreferredClassLoader)codebaseLoader, interfaceNames, codebase);
            }
            if (tryDL) {
                try {
                    boolean preferCodebaseLoader = sm != null && secEx == null && !codebaseMatchesDL;
                    Class c = this.loadProxyClass(interfaceNames, defaultLoader, "defaultLoader", codebaseLoader, preferCodebaseLoader);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, PreferredClassProvider.getProxySuccessLogMessage(sm, secEx), PreferredClassProvider.getClassLoader(c));
                    }
                    return c;
                }
                catch (ClassNotFoundException e) {
                }
                catch (IllegalArgumentException e) {
                    ClassNotFoundException cnfe = new ClassNotFoundException("dynamic proxy class creation failed", e);
                    if (logger.isLoggable(Levels.FAILED)) {
                        logger.log(Levels.FAILED, "dynamic proxy class creation failed", e);
                    }
                    throw cnfe;
                }
            }
        }
        if (sm != null && secEx == null) {
            loader = codebaseLoader;
            loaderName = "codebase loader";
        } else {
            loader = contextLoader;
            loaderName = "thread context class loader";
        }
        try {
            Class c = this.loadProxyClass(interfaceNames, loader, loaderName, null, false);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, PreferredClassProvider.getProxySuccessLogMessage(sm, secEx), PreferredClassProvider.getClassLoader(c));
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            if (sm == null) {
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (no security manager: codebase loader disabled)", e);
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "proxy class resolution failed (no security manager)", cnfe);
                }
                throw cnfe;
            }
            if (secEx != null) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "proxy class resolution failed (access to codebase loader denied)", e);
                }
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (access to codebase loader denied)", secEx);
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "proxy class resolution failed (access to codebase loader denied)", cnfe);
                }
                throw cnfe;
            }
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "proxy class resolution failed", e);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            ClassNotFoundException cnfe = new ClassNotFoundException("dynamic proxy class creation failed", e);
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "dynamic proxy class creation failed", e);
            }
            throw cnfe;
        }
    }

    private static String getProxySuccessLogMessage(SecurityManager sm, SecurityException secEx) {
        if (sm == null) {
            return "(no security manager) proxy class defined by {0}";
        }
        if (secEx != null) {
            return "(access to codebase loader denied) proxy class defined by {0}";
        }
        return "proxy class defined by {0}";
    }

    private Class loadProxyClass(String[] interfaceNames, ClassLoader interfaceLoader, String interfaceLoaderName, ClassLoader otherLoader, boolean tryOtherLoaderFirst) throws ClassNotFoundException {
        Class[] classObjs = new Class[interfaceNames.length];
        boolean[] nonpublic = new boolean[]{false};
        ClassLoader proxyLoader = this.loadProxyInterfaces(interfaceNames, interfaceLoader, classObjs, nonpublic);
        if (logger.isLoggable(Level.FINEST)) {
            ClassLoader[] definingLoaders = new ClassLoader[classObjs.length];
            for (int i = 0; i < definingLoaders.length; ++i) {
                definingLoaders[i] = PreferredClassProvider.getClassLoader(classObjs[i]);
            }
            logger.log(Level.FINEST, "proxy interfaces loaded via {0}, defined by {1}", new Object[]{interfaceLoaderName, Arrays.asList(definingLoaders)});
        }
        if (!nonpublic[0]) {
            if (tryOtherLoaderFirst) {
                try {
                    return Proxy.getProxyClass(otherLoader, classObjs);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            proxyLoader = interfaceLoader;
        }
        return Proxy.getProxyClass(proxyLoader, classObjs);
    }

    private boolean interfacePreferred(PreferredClassLoader codebaseLoader, String[] interfaceNames, String codebase) throws ClassNotFoundException {
        for (int p = 0; p < interfaceNames.length; ++p) {
            try {
                if (!codebaseLoader.isPreferredResource(interfaceNames[p], true)) continue;
                return true;
            }
            catch (IOException e) {
                ClassNotFoundException cnfe = new ClassNotFoundException(interfaceNames[p] + " (could not determine preferred setting;" + " original codebase: \"" + codebase + "\")", e);
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadProxyClass", "class \"{0}\" not found, could not obtain preferred value", new Object[]{interfaceNames[p]}, cnfe);
                }
                throw cnfe;
            }
        }
        return false;
    }

    private URI[] getLoaderAnnotationURIs(ClassLoader loader) throws MalformedURLException {
        return PreferredClassProvider.pathToURIs(this.getLoaderAnnotation(loader, false));
    }

    private boolean urlsMatchLoaderAnnotation(URI[] urls, ClassLoader loader) {
        try {
            return Arrays.equals(urls, this.getLoaderAnnotationURIs(loader));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private ClassLoader loadProxyInterfaces(String[] interfaces, ClassLoader loader, Class[] classObjs, boolean[] useNonpublic) throws ClassNotFoundException {
        ClassLoader nonpublic = null;
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = Class.forName(interfaces[i], false, loader);
            Class<?> cl = classObjs[i];
            if (Modifier.isPublic(cl.getModifiers())) continue;
            ClassLoader current = PreferredClassProvider.getClassLoader(cl);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, PreferredClassProvider.class.getName(), "loadProxyClass", "non-public interface \"{0}\" defined by {1}", new Object[]{interfaces[i], current});
            }
            if (!useNonpublic[0]) {
                nonpublic = current;
                useNonpublic[0] = true;
                continue;
            }
            if (current == nonpublic) continue;
            throw new IllegalAccessError("non-public interfaces defined in different class loaders");
        }
        return nonpublic;
    }

    private static URI[] pathToURIs(String path) throws MalformedURLException {
        if (path == null) {
            return null;
        }
        URI[] urls = (URI[])uriCache.get(path);
        if (urls != null) {
            return urls;
        }
        StringTokenizer st = new StringTokenizer(path);
        urls = new URI[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                String uri = st.nextToken();
                uri = UriString.fixWindowsURI(uri);
                urls[i] = UriString.normalise(new URI(UriString.escapeIllegalCharacters(uri)));
                if (!urls[i].isAbsolute()) {
                    throw new MalformedURLException("URI is not absolute: " + urls[i].toString() + " in path: " + path);
                }
            }
            catch (URISyntaxException ex) {
                throw new MalformedURLException("URL's must be RFC 3986 Compliant: " + ex.getMessage());
            }
            ++i;
        }
        URI[] existed = uriCache.putIfAbsent(path, urls);
        if (existed != null) {
            urls = existed;
        }
        return urls;
    }

    private URL[] asURL(URI[] uris) throws MalformedURLException {
        if (uris == null) {
            return null;
        }
        List<URI> uriList = Arrays.asList(uris);
        URL[] result = (URL[])urlCache.get(uriList);
        if (result != null) {
            return result;
        }
        try {
            int l = uris.length;
            URL[] urls = new URL[l];
            for (int i = 0; i < l; ++i) {
                try {
                    urls[i] = uris[i] == null ? null : uris[i].toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    System.err.println("MalformedURLException: " + e + "was thrown ," + uris[i]);
                    throw e;
                }
            }
            URL[] existed = urlCache.putIfAbsent(uriList, urls);
            if (existed != null) {
                urls = existed;
            }
            return urls;
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
    }

    private static ClassLoader getRMIContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private ClassLoader findOriginLoader(final URI[] pathURLs, final ClassLoader parent) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return PreferredClassProvider.this.findOriginLoader0(pathURLs, parent);
            }
        });
    }

    private ClassLoader findOriginLoader0(URI[] pathURLs, ClassLoader parent) {
        for (ClassLoader ancestor = parent; ancestor != null; ancestor = ancestor.getParent()) {
            Object[] ancestorURLs;
            try {
                ancestorURLs = this.getLoaderAnnotationURIs(ancestor);
            }
            catch (MalformedURLException e) {
                continue;
            }
            if (!Arrays.equals(pathURLs, ancestorURLs)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "using an existing ancestor class loader which serves the requested codebase urls: {0}, urls: {1}", new Object[]{ancestor, ancestorURLs != null ? Arrays.asList(ancestorURLs) : null});
            }
            return ancestor;
        }
        return null;
    }

    private ClassLoader lookupLoader(URI[] uris, URL[] urls, ClassLoader parent) throws MalformedURLException {
        ClassLoader existed;
        if (uris == null) {
            return parent;
        }
        LoaderKey key = new LoaderKey(uris, parent, null);
        ClassLoader loader = (ClassLoader)loaderTable.get(key);
        if (loader == null && (loader = this.findOriginLoader(uris, parent)) == null && (existed = loaderTable.putIfAbsent(key, loader = this.createClassLoader(urls, parent, this.requireDlPerm))) != null) {
            loader = existed;
        }
        return loader;
    }

    protected ClassLoader createClassLoader(final URL[] urls, final ClassLoader parent, final boolean requireDlPerm) {
        this.checkInitialized();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new PreferredClassLoader(urls, parent, null, requireDlPerm);
            }
        }, PreferredClassLoader.getLoaderAccessControlContext(urls));
    }

    private static ClassLoader getClassLoader(final Class c) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    static {
        String prop = AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.codebase"));
        if (prop != null && prop.trim().length() > 0) {
            codebaseProperty = prop;
        }
        localLoaders = Collections.synchronizedMap(new WeakHashMap());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (ClassLoader loader = ClassLoader.getSystemClassLoader(); loader != null; loader = loader.getParent()) {
                    localLoaders.put(loader, null);
                }
                return null;
            }
        });
        NonBlockingHashMap intern = new NonBlockingHashMap();
        urlCache = RC.concurrentMap(intern, Ref.TIME, Ref.STRONG, 10000L, 10000L);
        NonBlockingHashMap intern1 = new NonBlockingHashMap();
        uriCache = RC.concurrentMap(intern1, Ref.TIME, Ref.STRONG, 1000L, 1000L);
        NonBlockingHashMap internal = new NonBlockingHashMap();
        loaderTable = RC.concurrentMap(internal, Ref.STRONG, Ref.WEAK_IDENTITY, 200L, 200L);
    }

    private static class LoaderKey
    extends WeakReference<ClassLoader> {
        private final URI[] uris;
        private final boolean nullParent;
        private final int hashValue;

        public LoaderKey(URI[] urls, ClassLoader parent, ReferenceQueue<ClassLoader> refQueue) {
            super(parent, refQueue);
            this.nullParent = parent == null;
            this.uris = urls;
            int h = this.nullParent ? 0 : parent.hashCode();
            for (int i = 0; i < urls.length; ++i) {
                h ^= this.uris[i].hashCode();
            }
            this.hashValue = h;
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object obj) {
            ClassLoader parent;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LoaderKey)) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            LoaderKey other = (LoaderKey)obj;
            return (this.nullParent ? other.nullParent : (parent = (ClassLoader)this.get()) != null && parent == other.get()) && Arrays.equals(this.uris, other.uris);
        }
    }
}

