/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class AuthenticationPermission
extends Permission {
    private static final long serialVersionUID = -4733723479228998183L;
    private static final int LISTEN = 1;
    private static final int CONNECT = 2;
    private static final int ACCEPT = 5;
    private static final int DELEGATE = 10;
    private String actions;
    private transient String[] me;
    private transient String[] peer;
    private transient int mask;

    public AuthenticationPermission(String name, String actions) {
        super(name);
        this.actions = actions;
        this.init();
    }

    public AuthenticationPermission(Set local, Set peer, String actions) {
        this(AuthenticationPermission.parseName(local, peer), actions);
    }

    private AuthenticationPermission(Data data, String actions) {
        super(data.name);
        this.me = data.me;
        this.peer = data.peer;
        this.actions = actions;
        this.parseActions();
    }

    private void init() {
        this.parseActions();
        this.parseName(new StringTokenizer(this.getName(), " ", true), false);
    }

    private void parseActions() {
        StringTokenizer st = new StringTokenizer(this.actions, " ,", true);
        boolean comma = false;
        while (st.hasMoreTokens()) {
            String act = st.nextToken();
            if (act.equals(" ")) continue;
            if (comma) {
                if (!act.equals(",")) {
                    comma = false;
                    break;
                }
            } else if (act.equalsIgnoreCase("connect")) {
                this.mask |= 2;
            } else if (act.equalsIgnoreCase("accept")) {
                this.mask |= 5;
            } else if (act.equalsIgnoreCase("delegate")) {
                this.mask |= 0xA;
            } else {
                if (!act.equalsIgnoreCase("listen")) break;
                this.mask |= 1;
            }
            comma = !comma;
        }
        if (!comma) {
            throw new IllegalArgumentException("invalid actions");
        }
    }

    private void parseName(StringTokenizer st, boolean peer) {
        ArrayList<String> vals = new ArrayList<String>(2);
        block0: while (st.hasMoreTokens()) {
            String nm;
            String cls = st.nextToken();
            if (cls.equals(" ")) continue;
            if (!peer && cls.equalsIgnoreCase("peer")) {
                this.parseName(st, true);
                break;
            }
            if (cls.equals("*")) {
                if (peer) {
                    throw new IllegalArgumentException("peer class cannot be *");
                }
                cls = null;
                vals = null;
            }
            do {
                if (st.hasMoreTokens()) continue;
                throw new IllegalArgumentException("missing name after class");
            } while ((nm = st.nextToken()).equals(" "));
            if (!nm.startsWith("\"")) {
                throw new IllegalArgumentException("name must be in quotes");
            }
            while (!nm.endsWith("\"")) {
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("name must be in quotes");
                }
                nm = nm + st.nextToken();
            }
            if (nm.equals("\"*\"")) {
                if (peer) {
                    throw new IllegalArgumentException("peer name cannot be \"*\"");
                }
                if (cls == null) continue;
                nm = null;
            } else {
                if (cls == null) {
                    throw new IllegalArgumentException("class cannot be * unless name is \"*\"");
                }
                nm = nm.substring(1, nm.length() - 1);
            }
            if (vals == null) continue;
            int i = vals.size();
            while (i > 0) {
                String ocls;
                String onm = (String)vals.get(--i);
                if (!cls.equals(ocls = (String)vals.get(--i))) continue;
                if (onm == null || onm != null && onm.equals(nm)) continue block0;
                if (nm != null) continue;
                vals.remove(i);
                vals.remove(i);
            }
            vals.add(cls);
            vals.add(nm);
        }
        String[] res = null;
        if (vals != null) {
            if (vals.isEmpty()) {
                throw new IllegalArgumentException("target name is missing elements");
            }
            res = vals.toArray(new String[vals.size()]);
        }
        if (peer) {
            this.peer = res;
        } else {
            this.me = res;
        }
    }

    private static String[] cons(Set s, StringBuffer b) {
        String[] vals = new String[s.size() * 2];
        int i = 0;
        Iterator iter2 = s.iterator();
        while (iter2.hasNext()) {
            Principal p;
            try {
                p = (Principal)iter2.next();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("sets must contain Principals");
            }
            String v = p.getClass().getName();
            if (i > 0) {
                b.append(' ');
            }
            b.append(v);
            vals[i++] = v;
            v = p.getName();
            b.append(" \"");
            b.append(v);
            b.append('\"');
            vals[i++] = v;
        }
        return vals;
    }

    private static Data parseName(Set me, Set peer) {
        if (me == null) {
            throw new NullPointerException("local principals must be non-empty");
        }
        if (me.isEmpty()) {
            throw new IllegalArgumentException("local principals must be non-empty");
        }
        Data data = new Data();
        StringBuffer b = new StringBuffer();
        data.me = AuthenticationPermission.cons(me, b);
        if (peer != null && !peer.isEmpty()) {
            b.append(" peer ");
            data.peer = AuthenticationPermission.cons(peer, b);
        }
        data.name = b.toString();
        return data;
    }

    @Override
    public boolean implies(Permission perm) {
        if (!(perm instanceof AuthenticationPermission)) {
            return false;
        }
        AuthenticationPermission ap = (AuthenticationPermission)perm;
        return (this.mask & ap.mask) == ap.mask && this.implies0(ap);
    }

    private boolean implies0(AuthenticationPermission ap) {
        return (this.me == null || ap.me != null && AuthenticationPermission.covers(this.me, ap.me)) && (ap.mask == 1 || this.peer == null || ap.peer != null && AuthenticationPermission.covers(ap.peer, this.peer));
    }

    private static boolean covers(String[] sup, String[] sub) {
        int i = sub.length;
        block0: while (i > 0) {
            String onm = sub[--i];
            String ocls = sub[--i];
            int j = sup.length;
            while (j > 0) {
                String cls;
                String nm = sup[--j];
                if (!(cls = sup[--j]).equals(ocls) || nm != null && (onm == null || !nm.equals(onm))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AuthenticationPermissionCollection();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticationPermission)) {
            return false;
        }
        AuthenticationPermission ap = (AuthenticationPermission)obj;
        return this.mask == ap.mask && AuthenticationPermission.same(this.me, ap.me) && (this.mask == 1 || AuthenticationPermission.same(this.peer, ap.peer));
    }

    private static boolean same(String[] s1, String[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null || s1.length != s2.length) {
            return false;
        }
        int i = s2.length;
        block0: while (i > 0) {
            String onm = s2[--i];
            String ocls = s2[--i];
            int j = s1.length;
            while (j > 0) {
                String cls;
                String nm = s1[--j];
                if (!(cls = s1[--j]).equals(ocls) || !(nm == null ? onm == null : nm.equals(onm))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int i;
        int h = this.mask;
        if (this.me != null) {
            i = this.me.length;
            while (--i >= 0) {
                if (this.me[i] == null) continue;
                h += this.me[i].hashCode();
            }
        }
        if (this.mask != 1 && this.peer != null) {
            i = this.peer.length;
            while (--i >= 0) {
                h += this.peer[i].hashCode();
            }
        }
        return h;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.init();
        }
        catch (RuntimeException e) {
            if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
                InvalidObjectException ee = new InvalidObjectException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
            throw e;
        }
    }

    static class AuthenticationPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -2967578431368213049L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", List.class, true)};
        private List permissions = new ArrayList();

        AuthenticationPermissionCollection() {
        }

        @Override
        public synchronized void add(Permission perm) {
            if (!(perm instanceof AuthenticationPermission)) {
                throw new IllegalArgumentException("element must be an AuthenticationPermission");
            }
            if (this.isReadOnly()) {
                throw new SecurityException("collection is read-only");
            }
            this.permissions.add(perm);
        }

        @Override
        public synchronized boolean implies(Permission perm) {
            if (!(perm instanceof AuthenticationPermission)) {
                return false;
            }
            AuthenticationPermission ap = (AuthenticationPermission)perm;
            int needed = ap.mask;
            int i = this.permissions.size();
            while (--i >= 0) {
                AuthenticationPermission cp = (AuthenticationPermission)this.permissions.get(i);
                if ((needed & cp.mask) == 0 || !cp.implies0(ap) || (needed &= ~cp.mask) != 0) continue;
                return true;
            }
            return false;
        }

        public synchronized Enumeration elements() {
            return Collections.enumeration(this.permissions);
        }

        @Override
        public synchronized void setReadOnly() {
            super.setReadOnly();
        }

        @Override
        public synchronized boolean isReadOnly() {
            return super.isReadOnly();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (this.permissions == null) {
                throw new InvalidObjectException("list cannot be null");
            }
            if (!this.permissions.getClass().equals(ArrayList.class)) {
                this.permissions = new ArrayList(this.permissions);
            }
            int i = this.permissions.size();
            while (--i >= 0) {
                if (this.permissions.get(i) instanceof AuthenticationPermission) continue;
                throw new InvalidObjectException("element must be an AuthenticationPermission");
            }
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
        }
    }

    private static final class Data {
        String name;
        String[] me;
        String[] peer;

        Data() {
        }
    }
}

