/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Permission;
import java.util.Collections;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;

public class BasicProxyPreparer
implements ProxyPreparer,
Serializable {
    private static final long serialVersionUID = 4439691869768577046L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("verify", Boolean.TYPE), new ObjectStreamField("methodConstraintsSpecified", Boolean.TYPE), new ObjectStreamField("methodConstraints", MethodConstraints.class), new ObjectStreamField("permissions", Permission[].class, true)};
    protected final boolean verify;
    protected final boolean methodConstraintsSpecified;
    protected final MethodConstraints methodConstraints;
    protected final Permission[] permissions;

    public BasicProxyPreparer() {
        this.verify = false;
        this.methodConstraintsSpecified = false;
        this.methodConstraints = null;
        this.permissions = new Permission[0];
    }

    public BasicProxyPreparer(boolean verify, Permission[] permissions) {
        this.verify = verify;
        this.methodConstraintsSpecified = false;
        this.methodConstraints = null;
        this.permissions = BasicProxyPreparer.checkPermissions(permissions);
    }

    private static Permission[] checkPermissions(Permission[] permissions) {
        if (permissions == null) {
            return new Permission[0];
        }
        permissions = (Permission[])permissions.clone();
        int i = permissions.length;
        while (--i >= 0) {
            if (permissions[i] != null) continue;
            throw new NullPointerException("Permission cannot be null");
        }
        return permissions;
    }

    public BasicProxyPreparer(boolean verify, MethodConstraints methodConstraints, Permission[] permissions) {
        this.verify = verify;
        this.methodConstraintsSpecified = true;
        this.methodConstraints = methodConstraints;
        this.permissions = BasicProxyPreparer.checkPermissions(permissions);
    }

    protected MethodConstraints getMethodConstraints(Object proxy) {
        if (this.methodConstraintsSpecified) {
            return this.methodConstraints;
        }
        if (proxy instanceof RemoteMethodControl) {
            return ((RemoteMethodControl)proxy).getConstraints();
        }
        return null;
    }

    protected Permission[] getPermissions(Object proxy) {
        return this.permissions;
    }

    @Override
    public Object prepareProxy(Object proxy) throws RemoteException {
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        this.verify(proxy);
        this.grant(proxy);
        return this.setConstraints(proxy);
    }

    protected void verify(Object proxy) throws RemoteException {
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        if (this.verify) {
            MethodConstraints mc = this.getMethodConstraints(proxy);
            Security.verifyObjectTrust(proxy, null, mc == null ? Collections.EMPTY_SET : Collections.singleton(mc));
        }
    }

    protected void grant(Object proxy) {
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        Permission[] perms = this.getPermissions(proxy);
        if (perms.length > 0) {
            try {
                Security.grant(proxy.getClass(), perms);
            }
            catch (UnsupportedOperationException e) {
                SecurityException se = new SecurityException("Dynamic permission grants are not supported");
                se.initCause(e);
                throw se;
            }
        }
    }

    protected Object setConstraints(Object proxy) {
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null");
        }
        if (!this.methodConstraintsSpecified) {
            return proxy;
        }
        if (!(proxy instanceof RemoteMethodControl)) {
            throw new SecurityException("Proxy must implement RemoteMethodControl");
        }
        return ((RemoteMethodControl)proxy).setConstraints(this.getMethodConstraints(proxy));
    }

    public String toString() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        StringBuffer sb = new StringBuffer(className).append('[');
        if (this.verify) {
            sb.append("verify");
        }
        if (this.methodConstraintsSpecified) {
            if (this.verify) {
                sb.append(", ");
            }
            sb.append(this.methodConstraints);
        }
        if (this.permissions.length > 0) {
            if (this.verify || this.methodConstraintsSpecified) {
                sb.append(", ");
            }
            sb.append('{');
            for (int i = 0; i < this.permissions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.permissions[i]);
            }
            sb.append('}');
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        BasicProxyPreparer other = (BasicProxyPreparer)object;
        if (this.verify != other.verify) {
            return false;
        }
        if (this.methodConstraintsSpecified != other.methodConstraintsSpecified) {
            return false;
        }
        if (this.methodConstraintsSpecified && (this.methodConstraints == null ? other.methodConstraints != null : !this.methodConstraints.equals(other.methodConstraints))) {
            return false;
        }
        if (this.permissions.length != other.permissions.length) {
            return false;
        }
        Permission[] otherPermissions = (Permission[])other.permissions.clone();
        int i = this.permissions.length;
        block0: while (--i >= 0) {
            Permission p = this.permissions[i];
            for (int j = i; j >= 0; --j) {
                if (!p.equals(otherPermissions[j])) continue;
                otherPermissions[j] = otherPermissions[i];
                continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().getName().hashCode();
        if (this.verify) {
            ++hash;
        }
        if (this.methodConstraintsSpecified) {
            hash += 65536;
            if (this.methodConstraints != null) {
                hash += this.methodConstraints.hashCode();
            }
        }
        int i = this.permissions.length;
        while (--i >= 0) {
            hash += this.permissions[i].hashCode();
        }
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (!this.methodConstraintsSpecified && this.methodConstraints != null) {
            throw new InvalidObjectException("Method constraints not specified but not null");
        }
        if (this.permissions == null) {
            throw new InvalidObjectException("Permissions cannot be null");
        }
        int i = this.permissions.length;
        while (--i >= 0) {
            if (this.permissions[i] != null) continue;
            throw new InvalidObjectException("Permission cannot be null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Permissions must be specified");
    }
}

