/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.sun.jini.jeri.internal.runtime.Util;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public final class ProxyTrustInvocationHandler
implements InvocationHandler,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -3270029468290295063L;
    private static final Class[] consArgs = new Class[]{InvocationHandler.class};
    private final RemoteMethodControl main;
    private final ProxyTrust boot;

    public ProxyTrustInvocationHandler(RemoteMethodControl main, ProxyTrust boot) {
        if (main == null || boot == null) {
            throw new NullPointerException("arguments cannot be null");
        }
        if (!(main instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("main proxy must implement TrustEquivalence");
        }
        if (!(boot instanceof RemoteMethodControl)) {
            throw new IllegalArgumentException("bootstrap proxy must implement RemoteMethodControl");
        }
        if (!(boot instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("bootstrap proxy must implement TrustEquivalence");
        }
        this.main = main;
        this.boot = boot;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> decl = method.getDeclaringClass();
        if (decl == Object.class) {
            String name = method.getName();
            if (name.equals("equals")) {
                Object obj = args[0];
                if (proxy == obj || obj != null && Util.sameProxyClass(proxy, obj) && this.equals(Proxy.getInvocationHandler(obj))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (name.equals("toString")) {
                return this.proxyToString(proxy);
            }
            if (name.equals("hashCode")) {
                return this.hashCode();
            }
            throw new IllegalArgumentException("unexpected Object method");
        }
        if (decl == RemoteMethodControl.class && method.getName().equals("setConstraints")) {
            if (Proxy.getInvocationHandler(proxy) != this) {
                throw new IllegalArgumentException("wrong invocation handler");
            }
            ProxyTrustInvocationHandler handler = new ProxyTrustInvocationHandler((RemoteMethodControl)this.invoke0(method, args), this.boot);
            return Proxy.newProxyInstance(proxy.getClass().getClassLoader(), proxy.getClass().getInterfaces(), (InvocationHandler)handler);
        }
        if (decl == TrustEquivalence.class) {
            if (!method.getName().equals("checkTrustEquivalence")) {
                throw new AssertionError((Object)"unknown TrustEquivalence method");
            }
            Object obj = args[0];
            if (proxy == obj || obj != null && Util.sameProxyClass(proxy, obj) && this.checkTrustEquivalence(Proxy.getInvocationHandler(obj))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.invoke0(method, args);
    }

    private Object invoke0(Method m, Object[] args) throws Throwable {
        Class<?> impl;
        Class<?> iface = m.getDeclaringClass();
        if (!Modifier.isPublic(iface.getModifiers()) && Modifier.isPublic((impl = this.main.getClass()).getModifiers()) && iface.isInstance(this.main)) {
            try {
                m = impl.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return m.invoke((Object)this.main, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException().initCause(e);
        }
    }

    @Override
    public boolean checkTrustEquivalence(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProxyTrustInvocationHandler)) {
            return false;
        }
        ProxyTrustInvocationHandler oh = (ProxyTrustInvocationHandler)obj;
        return ((TrustEquivalence)((Object)this.main)).checkTrustEquivalence(oh.main) && ((TrustEquivalence)((Object)this.boot)).checkTrustEquivalence(oh.boot);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProxyTrustInvocationHandler)) {
            return false;
        }
        ProxyTrustInvocationHandler oh = (ProxyTrustInvocationHandler)obj;
        return this.main.equals(oh.main) && this.boot.equals(oh.boot);
    }

    public int hashCode() {
        return this.main.hashCode() + this.boot.hashCode();
    }

    public String toString() {
        return "ProxyTrustInvocationHandler[main: " + this.main + ", boot: " + this.boot + "]";
    }

    private String proxyToString(Object proxy) {
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        Class<?> iface = null;
        int i = interfaces.length;
        while (--i >= 0 && interfaces[i] != RemoteMethodControl.class) {
            iface = interfaces[i];
        }
        if (iface == null) {
            return "Proxy[" + this + "]";
        }
        String n = iface.getName();
        int dot = n.lastIndexOf(46);
        if (dot >= 0) {
            n = n.substring(dot + 1);
        }
        return "Proxy[" + n + "," + this + "]";
    }

    protected ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator(this.boot);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (!(this.main instanceof TrustEquivalence)) {
            throw new InvalidObjectException("main proxy must implement TrustEquivalence");
        }
        if (!(this.boot instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("bootstrap proxy must implement RemoteMethodControl");
        }
        if (!(this.boot instanceof TrustEquivalence)) {
            throw new InvalidObjectException("bootstrap proxy must implement TrustEquivalence");
        }
    }
}

