/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jini.url.httpmd.DelegatingHttpURLConnection;
import net.jini.url.httpmd.HttpmdUtil;
import net.jini.url.httpmd.MdInputStream;

class HttpmdURLConnection
extends DelegatingHttpURLConnection {
    private final String algorithm;
    private final byte[] expectedDigest;
    private final URL content;

    HttpmdURLConnection(URL url) throws IOException, MalformedURLException {
        super(url);
        int length;
        String path = url.getPath() == null ? "" : url.getPath();
        int semiIndex = path.lastIndexOf(59);
        if (semiIndex < 0) {
            throw new MalformedURLException("Message digest parameter is missing");
        }
        int equalsIndex = path.indexOf(61, semiIndex);
        if (equalsIndex < 0) {
            throw new MalformedURLException("Message digest parameter is missing a '='");
        }
        this.algorithm = path.substring(semiIndex + 1, equalsIndex);
        try {
            MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            MalformedURLException t = new MalformedURLException("Message digest parameter algorithm is not found: " + this.algorithm);
            t.initCause(e);
            throw t;
        }
        String digest = path.substring(equalsIndex + 1);
        int comment = digest.indexOf(44);
        if (comment >= 0) {
            int i = digest.length();
            while (--i > comment) {
                char c = digest.charAt(i);
                if (HttpmdUtil.commentChar(c)) continue;
                throw new MalformedURLException("Comment contains illegal character: '" + c + "'");
            }
            digest = digest.substring(0, comment);
        }
        if ((length = digest.length()) == 0) {
            throw new MalformedURLException("Message digest parameter digest is empty");
        }
        try {
            this.expectedDigest = HttpmdUtil.stringDigest(digest);
        }
        catch (NumberFormatException e) {
            MalformedURLException t = new MalformedURLException("Message digest parameter has invalid format for digest: " + digest);
            t.initCause(e);
            throw t;
        }
        try {
            this.content = new URL("http", url.getHost(), url.getPort(), path.substring(0, semiIndex) + (url.getQuery() == null ? "" : url.getQuery()) + (url.getRef() == null ? "" : url.getRef()));
        }
        catch (MalformedURLException e) {
            MalformedURLException t = new MalformedURLException("Problem with content location");
            t.initCause(e);
            throw t;
        }
        this.delegateConnection = (HttpURLConnection)this.content.openConnection();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return new MdInputStream(this.url, this.delegateConnection.getInputStream(), MessageDigest.getInstance(this.algorithm), this.expectedDigest);
        }
        catch (NoSuchAlgorithmException e) {
            IOException t = new IOException("Message digest algorithm not found: " + this.algorithm);
            t.initCause(e);
            throw t;
        }
    }
}

