/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceItemFilter;
import org.apache.river.api.util.ResultStream;

public class ServiceResultStreamFilter
implements ResultStream<ServiceItem> {
    private final List<ServiceItemFilter> filters;
    private final ResultStream inputResultStream;

    public ServiceResultStreamFilter(ResultStream rs, ServiceItemFilter[] sf) {
        this.inputResultStream = rs;
        this.filters = new ArrayList<ServiceItemFilter>(sf.length);
        this.filters.addAll(Arrays.asList(sf));
    }

    @Override
    public ServiceItem get() throws IOException {
        Object item = this.inputResultStream.get();
        while (item != null) {
            if (item instanceof ServiceItem) {
                ServiceItem it = (ServiceItem)item;
                int l = this.filters.size();
                for (int i = 0; i < l; ++i) {
                    ServiceItemFilter filter = this.filters.get(i);
                    if (filter == null || !filter.check(it)) continue;
                    return it;
                }
            }
            item = this.inputResultStream.get();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.inputResultStream.close();
    }
}

