/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PrincipalGrant;

class CertificateGrant
extends PrincipalGrant {
    private static final long serialVersionUID = 1L;
    private final Collection<Certificate> certs;
    private final int hashCode;

    CertificateGrant(Certificate[] codeSourceCerts, Principal[] pals, Permission[] perms) {
        super(pals, perms);
        if (codeSourceCerts == null || codeSourceCerts.length == 0) {
            this.certs = Collections.EMPTY_SET;
        } else {
            this.certs = new HashSet<Certificate>(codeSourceCerts.length);
            this.certs.addAll(Arrays.asList(codeSourceCerts));
        }
        int hash = 3;
        hash = 83 * hash + (this.certs != null ? this.certs.hashCode() : 0);
        this.hashCode = hash = 83 * hash + super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        if (o instanceof CertificateGrant) {
            CertificateGrant c = (CertificateGrant)o;
            if (!super.equals(o)) {
                return false;
            }
            if (this.certs.equals(c.certs)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append("\nCertificate's: \n");
        Iterator<Certificate> it = this.certs.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public boolean implies(ProtectionDomain pd) {
        if (pd == null) {
            return false;
        }
        CodeSource c = null;
        Principal[] pals = null;
        if (pd != null) {
            c = pd.getCodeSource();
            pals = this.getPrincipals(pd);
        }
        return this.implies(c, pals);
    }

    @Override
    public boolean implies(ClassLoader cl, Principal[] p) {
        if (!this.implies(p)) {
            return false;
        }
        if (this.certs.isEmpty()) {
            return true;
        }
        if (cl == null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean implies(CodeSource codeSource, Principal[] p) {
        if (!this.implies(p)) {
            return false;
        }
        if (codeSource == null) {
            return false;
        }
        if (this.certs.isEmpty()) {
            return true;
        }
        Certificate[] signers = codeSource.getCertificates();
        List<Certificate> certificates = Arrays.asList(signers);
        return certificates.containsAll(this.certs);
    }

    @Override
    public PermissionGrantBuilder getBuilderTemplate() {
        PermissionGrantBuilder pgb = super.getBuilderTemplate();
        return pgb.certificates(this.certs.toArray(new Certificate[this.certs.size()])).context(2);
    }

    private Object writeReplace() {
        return this.getBuilderTemplate();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("PermissionGrantBuilder required");
    }
}

