/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.river.api.security.PermissionComparator;
import org.apache.river.api.security.PolicyUtils;

final class ConcurrentPermissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient PermissionPendingResolutionCollection unresolved;
    private final ConcurrentMap<Class<?>, PermissionCollection> permsMap;
    private volatile transient boolean allPermission;

    ConcurrentPermissions() {
        this.permsMap = new ConcurrentHashMap();
        this.unresolved = new PermissionPendingResolutionCollection();
        this.allPermission = false;
    }

    ConcurrentPermissions(int initialCapacity, float loadFactor, int concurrencyLevel, int unresolvedClassCount) {
        this.permsMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        this.unresolved = new PermissionPendingResolutionCollection(unresolvedClassCount, loadFactor, concurrencyLevel);
        this.allPermission = false;
    }

    @Override
    public void add(Permission permission) {
        PermissionCollection existed;
        Class<?> clas;
        PermissionCollection pc;
        if (permission == null) {
            return;
        }
        if (super.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
        }
        if (this.allPermission) {
            return;
        }
        if (permission instanceof AllPermission) {
            this.allPermission = true;
            this.permsMap.clear();
            this.unresolved.clear();
        }
        if (permission instanceof UnresolvedPermission) {
            this.unresolved.add(new PermissionPendingResolution((UnresolvedPermission)permission));
        }
        if ((pc = (PermissionCollection)this.permsMap.get(clas = permission.getClass())) == null && (existed = this.permsMap.putIfAbsent(clas, pc = this.getPC(permission))) != null) {
            pc = existed;
        }
        pc.add(permission);
    }

    private PermissionCollection getPC(Permission p) {
        if (p == null) {
            throw new NullPointerException("null Permission");
        }
        PermissionCollection pc = p.newPermissionCollection();
        if (pc == null) {
            pc = new PC();
        }
        return pc;
    }

    @Override
    public boolean implies(Permission permission) {
        PermissionCollection existed;
        if (permission == null) {
            return false;
        }
        if (this.allPermission) {
            return true;
        }
        if (permission instanceof UnresolvedPermission) {
            return false;
        }
        Class<?> clas = permission.getClass();
        PermissionCollection pc = (PermissionCollection)this.permsMap.get(clas);
        if (pc != null && pc.implies(permission)) {
            return true;
        }
        if (this.unresolved.awaitingResolution() == 0) {
            return false;
        }
        if (pc == null && (existed = this.permsMap.putIfAbsent(clas, pc = this.getPC(permission))) != null) {
            pc = existed;
        }
        this.unresolved.resolveCollection(permission, pc);
        return pc.implies(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        if (this.allPermission) {
            Permission[] pa = new Permission[]{new AllPermission()};
            return Collections.enumeration(Arrays.asList(pa));
        }
        ArrayList<PermissionPendingResolutionCollection> elem = new ArrayList<PermissionPendingResolutionCollection>(this.permsMap.size() + this.unresolved.awaitingResolution() + 2);
        if (this.unresolved.awaitingResolution() > 0) {
            elem.add(this.unresolved);
        }
        elem.addAll(this.permsMap.values());
        Iterator<PermissionCollection> perms = elem.iterator();
        return new PermissionEnumerator(perms);
    }

    private static class PermissionPendingResolutionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private ConcurrentHashMap<String, Collection<PermissionPendingResolution>> klasses;
        private AtomicInteger pending;

        PermissionPendingResolutionCollection() {
            this.klasses = new ConcurrentHashMap(2);
            this.pending = new AtomicInteger(0);
        }

        PermissionPendingResolutionCollection(int initialCapacity, float loadFactor, int concurrencyLevel) {
            this.klasses = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            this.pending = new AtomicInteger(0);
        }

        public int awaitingResolution() {
            return this.pending.get();
        }

        void clear() {
            this.klasses.clear();
            this.pending.set(0);
        }

        @Override
        public void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
            }
            if (permission == null) {
                throw new IllegalArgumentException("Null Permission");
            }
            if (permission.getClass() != PermissionPendingResolution.class || permission.getClass() != PermissionPendingResolution.class) {
                throw new IllegalArgumentException("Not instance of PermissionPendingResolution");
            }
            String klass = permission.getName();
            Collection<PermissionPendingResolution> klassMates = this.klasses.get(klass);
            if (klassMates != null) {
                klassMates.add((PermissionPendingResolution)permission);
                this.pending.incrementAndGet();
                return;
            }
            Collection<PermissionPendingResolution> klassMatesExists = null;
            HashSet pprs = new HashSet();
            klassMates = Collections.synchronizedSet(pprs);
            klassMatesExists = this.klasses.putIfAbsent(klass, klassMates);
            if (klassMatesExists == null) {
                klassMates.add((PermissionPendingResolution)permission);
                this.pending.incrementAndGet();
            } else {
                klassMatesExists.add((PermissionPendingResolution)permission);
                this.pending.incrementAndGet();
            }
        }

        PermissionCollection resolveCollection(Permission target, PermissionCollection holder) {
            if (target == null || holder == null) {
                throw new NullPointerException("target or holder cannot be null");
            }
            if (this.pending.get() == 0) {
                return holder;
            }
            String klass = target.getClass().getName();
            Collection<PermissionPendingResolution> klassMates = this.klasses.remove(klass);
            if (klassMates != null) {
                Collection<PermissionPendingResolution> existed;
                Iterator<PermissionPendingResolution> iter2 = klassMates.iterator();
                while (iter2.hasNext()) {
                    PermissionPendingResolution element = iter2.next();
                    Permission resolved = element.resolve(target.getClass());
                    if (resolved == null) continue;
                    holder.add(resolved);
                    iter2.remove();
                    this.pending.decrementAndGet();
                }
                if (klassMates.size() > 0 && (existed = this.klasses.putIfAbsent(klass, klassMates)) != null) {
                    existed.addAll(klassMates);
                }
            }
            return holder;
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            ArrayList<PermissionPendingResolution> all = new ArrayList<PermissionPendingResolution>();
            Iterator<Collection<PermissionPendingResolution>> iter2 = this.klasses.values().iterator();
            while (iter2.hasNext()) {
                all.addAll(iter2.next());
            }
            return Collections.enumeration(all);
        }
    }

    private static class PermissionPendingResolution
    extends Permission {
        private static final long serialVersionUID = 1L;
        private transient String type;
        private transient String name;
        private transient String actions;
        private transient Certificate[] targetCerts;
        private UnresolvedPermission unresolvedPermission;

        PermissionPendingResolution(UnresolvedPermission up) {
            super(up.getUnresolvedType());
            this.type = up.getUnresolvedType();
            this.name = up.getUnresolvedName();
            this.actions = up.getUnresolvedActions();
            this.targetCerts = up.getUnresolvedCerts();
            this.unresolvedPermission = up;
        }

        Permission resolve(Class targetType) {
            if (PolicyUtils.matchSubset(this.targetCerts, targetType.getSigners())) {
                try {
                    return PolicyUtils.instantiatePermission(targetType, this.name, this.actions);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PermissionPendingResolution)) {
                return false;
            }
            PermissionPendingResolution ob = (PermissionPendingResolution)obj;
            return this.unresolvedPermission.equals(ob.unresolvedPermission);
        }

        @Override
        public int hashCode() {
            return this.unresolvedPermission.hashCode();
        }

        @Override
        public String getActions() {
            return "";
        }

        @Override
        public PermissionCollection newPermissionCollection() {
            return new PermissionPendingResolutionCollection();
        }

        public UnresolvedPermission asUnresolvedPermission() {
            return this.unresolvedPermission;
        }
    }

    private static class PC
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private final Collection<Permission> perms = new ConcurrentSkipListSet<Permission>(new PermissionComparator());

        private PC() {
        }

        @Override
        public void add(Permission permission) {
            this.perms.add(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            if (this.perms.contains(permission)) {
                return true;
            }
            for (Permission p : this.perms) {
                if (!p.implies(permission)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.perms);
        }
    }

    private static final class PermissionEnumerator
    implements Enumeration<Permission> {
        private static final Enumeration<Permission> empty = new Enumeration<Permission>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public Permission nextElement() {
                throw new NoSuchElementException("Empty enumeration");
            }
        };
        private final Iterator<PermissionCollection> epc;
        private volatile Enumeration<Permission> currentPermSet;

        PermissionEnumerator(Iterator<PermissionCollection> epc) {
            this.epc = epc;
            this.currentPermSet = this.getNextPermSet();
        }

        private Enumeration<Permission> getNextPermSet() {
            Enumeration<Permission> result = null;
            if (this.epc.hasNext()) {
                Enumeration<Permission> e = null;
                PermissionCollection pc = this.epc.next();
                if (pc instanceof PermissionPendingResolutionCollection) {
                    HashSet<UnresolvedPermission> permissionSet = new HashSet<UnresolvedPermission>();
                    e = pc.elements();
                    while (e.hasMoreElements()) {
                        PermissionPendingResolution p = (PermissionPendingResolution)e.nextElement();
                        UnresolvedPermission up = p.asUnresolvedPermission();
                        permissionSet.add(up);
                    }
                    e = Collections.enumeration(permissionSet);
                } else if (pc != null) {
                    e = pc.elements();
                }
                if (e == null) {
                    e = empty;
                }
                result = e;
            }
            return result;
        }

        @Override
        public boolean hasMoreElements() {
            boolean result = false;
            if (this.currentPermSet != null) {
                result = this.currentPermSet.hasMoreElements();
            }
            while (!result) {
                Enumeration<Permission> next = this.getNextPermSet();
                if (next == null) {
                    return false;
                }
                this.currentPermSet = next;
                result = this.currentPermSet.hasMoreElements();
            }
            return result;
        }

        @Override
        public Permission nextElement() {
            return this.currentPermSet.nextElement();
        }
    }
}

