/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.river.api.security.Messages;
import org.apache.river.api.security.PolicyUtils;
import org.apache.river.api.security.Util;

class DefaultPolicyScanner {
    DefaultPolicyScanner() {
    }

    StreamTokenizer configure(StreamTokenizer st) {
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        return st;
    }

    void scanStream(Reader r, Collection<GrantEntry> grantEntries, List<KeystoreEntry> keystoreEntries) throws IOException, InvalidFormatException {
        StreamTokenizer st = this.configure(new StreamTokenizer(r));
        block5: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block5;
                }
                case -3: {
                    if (Util.equalsIgnoreCase("keystore", st.sval)) {
                        keystoreEntries.add(this.readKeystoreEntry(st));
                        continue block5;
                    }
                    if (Util.equalsIgnoreCase("grant", st.sval)) {
                        grantEntries.add(this.readGrantEntry(st));
                        continue block5;
                    }
                    this.handleUnexpectedToken(st, Messages.getString("security.89"));
                    continue block5;
                }
                case 59: {
                    continue block5;
                }
                default: {
                    this.handleUnexpectedToken(st);
                    continue block5;
                }
            }
            break;
        }
    }

    KeystoreEntry readKeystoreEntry(StreamTokenizer st) throws IOException, InvalidFormatException {
        String url = null;
        String type = null;
        if (st.nextToken() == 34) {
            url = st.sval;
            if (st.nextToken() == 34 || st.ttype == 44 && st.nextToken() == 34) {
                type = st.sval;
            } else {
                st.pushBack();
            }
        } else {
            this.handleUnexpectedToken(st, Messages.getString("security.8A"));
        }
        return new KeystoreEntry(url, type);
    }

    GrantEntry readGrantEntry(StreamTokenizer st) throws IOException, InvalidFormatException {
        String signer = null;
        String codebase = null;
        ArrayList<PrincipalEntry> principals = new ArrayList<PrincipalEntry>();
        Collection<PermissionEntry> permissions = null;
        block5: while (true) {
            switch (st.nextToken()) {
                case -3: {
                    if (Util.equalsIgnoreCase("signedby", st.sval)) {
                        if (st.nextToken() == 34) {
                            signer = st.sval;
                            continue block5;
                        }
                        this.handleUnexpectedToken(st, Messages.getString("security.8B"));
                        continue block5;
                    }
                    if (Util.equalsIgnoreCase("codebase", st.sval)) {
                        if (st.nextToken() == 34) {
                            codebase = st.sval;
                            continue block5;
                        }
                        this.handleUnexpectedToken(st, Messages.getString("security.8C"));
                        continue block5;
                    }
                    if (Util.equalsIgnoreCase("principal", st.sval)) {
                        principals.add(this.readPrincipalEntry(st));
                        continue block5;
                    }
                    this.handleUnexpectedToken(st);
                    continue block5;
                }
                case 44: {
                    continue block5;
                }
                case 123: {
                    permissions = this.readPermissionEntries(st);
                    break block5;
                }
                default: {
                    st.pushBack();
                    break block5;
                }
            }
            break;
        }
        return new GrantEntry(signer, codebase, principals, permissions);
    }

    PrincipalEntry readPrincipalEntry(StreamTokenizer st) throws IOException, InvalidFormatException {
        String classname = null;
        String name = null;
        if (st.nextToken() == -3) {
            classname = st.sval;
            st.nextToken();
        } else if (st.ttype == 42) {
            classname = "*";
            st.nextToken();
        }
        if (st.ttype == 34) {
            name = st.sval;
        } else if (st.ttype == 42) {
            name = "*";
        } else {
            this.handleUnexpectedToken(st, Messages.getString("security.8D"));
        }
        return new PrincipalEntry(classname, name);
    }

    Collection<PermissionEntry> readPermissionEntries(StreamTokenizer st) throws IOException, InvalidFormatException {
        HashSet<PermissionEntry> permissions = new HashSet<PermissionEntry>();
        block5: while (true) {
            switch (st.nextToken()) {
                case -3: {
                    if (Util.equalsIgnoreCase("permission", st.sval)) {
                        String klass = null;
                        String name = null;
                        String actions = null;
                        String signers = null;
                        if (st.nextToken() == -3) {
                            klass = st.sval;
                            if (st.nextToken() == 34) {
                                name = st.sval;
                                st.nextToken();
                            }
                            if (st.ttype == 44) {
                                st.nextToken();
                            }
                            if (st.ttype == 34) {
                                actions = st.sval;
                                if (st.nextToken() == 44) {
                                    st.nextToken();
                                }
                            }
                            if (st.ttype == -3 && Util.equalsIgnoreCase("signedby", st.sval)) {
                                if (st.nextToken() == 34) {
                                    signers = st.sval;
                                } else {
                                    this.handleUnexpectedToken(st);
                                }
                            } else {
                                st.pushBack();
                            }
                            PermissionEntry pe = new PermissionEntry(klass, name, actions, signers);
                            permissions.add(pe);
                            continue block5;
                        }
                    }
                    this.handleUnexpectedToken(st, Messages.getString("security.8E"));
                    continue block5;
                }
                case 59: {
                    continue block5;
                }
                case 125: {
                    break block5;
                }
                default: {
                    this.handleUnexpectedToken(st);
                    continue block5;
                }
            }
            break;
        }
        return permissions;
    }

    String composeStatus(StreamTokenizer st) {
        return st.toString();
    }

    final void handleUnexpectedToken(StreamTokenizer st, String message) throws InvalidFormatException {
        throw new InvalidFormatException(Messages.getString("security.8F", this.composeStatus(st), message));
    }

    final void handleUnexpectedToken(StreamTokenizer st) throws InvalidFormatException {
        throw new InvalidFormatException(Messages.getString("security.90", this.composeStatus(st)));
    }

    static class PermissionEntry {
        private final String klass;
        private final String name;
        private final String actions;
        private final String signers;

        PermissionEntry(String klass, String name, String actions, String signers) {
            if (klass == null) {
                throw new NullPointerException();
            }
            this.klass = klass;
            this.name = name == null ? "" : name;
            this.actions = actions == null ? "" : actions;
            this.signers = signers;
        }

        public String toString() {
            String endline = "\n";
            int l = this.getKlass() == null ? 0 : this.getKlass().length();
            l += this.getName() == null ? 0 : this.getName().length();
            l += this.getActions() == null ? 0 : this.getActions().length();
            l += this.getSigners() == null ? 0 : this.getSigners().length();
            StringBuffer sb = new StringBuffer(l += 8);
            if (this.getKlass() != null) {
                sb.append(this.getKlass()).append(endline);
            }
            if (this.getName() != null) {
                sb.append(this.getName()).append(endline);
            }
            if (this.getActions() != null) {
                sb.append(this.getActions()).append(endline);
            }
            if (this.getSigners() != null) {
                sb.append(this.getSigners()).append(endline);
            }
            return sb.toString();
        }

        String getKlass() {
            return this.klass;
        }

        String getName() {
            return this.name;
        }

        String getActions() {
            return this.actions;
        }

        String getSigners() {
            return this.signers;
        }
    }

    static class PrincipalEntry {
        public static final String WILDCARD = "*";
        private final String klass;
        private final String name;

        PrincipalEntry(String classname, String name) {
            this.klass = classname;
            this.name = name;
        }

        public String toString() {
            String newline = "\n";
            int l = this.getKlass() == null ? 0 : this.getKlass().length();
            l = l + this.getName() == null ? 0 : this.getName().length();
            StringBuffer sb = new StringBuffer(l += 4);
            if (this.getKlass() != null) {
                sb.append(this.getKlass()).append(newline);
            }
            if (this.getName() != null) {
                sb.append(this.getName()).append(newline);
            }
            return sb.toString();
        }

        String getKlass() {
            return this.klass;
        }

        String getName() {
            return this.name;
        }
    }

    static class GrantEntry {
        private final String signers;
        private final String codebase;
        private final Collection<PrincipalEntry> principals;
        private final Collection<PermissionEntry> permissions;

        GrantEntry(String signers, String codebase, Collection<PrincipalEntry> pe, Collection<PermissionEntry> perms) {
            this.signers = signers;
            this.codebase = codebase;
            this.principals = pe;
            this.permissions = perms;
        }

        public String toString() {
            String newline = "\n";
            StringBuilder sb = new StringBuilder(400);
            if (this.signers != null) {
                sb.append(this.signers).append(newline);
            }
            if (this.codebase != null) {
                sb.append(this.codebase).append(newline);
            }
            if (this.principals != null) {
                sb.append(this.principals).append(newline);
            }
            if (this.permissions != null) {
                sb.append(this.permissions).append(newline);
            }
            return sb.toString();
        }

        String getSigners() {
            return this.signers;
        }

        String getCodebase(Properties system) {
            if (system == null) {
                return this.codebase;
            }
            try {
                return PolicyUtils.expand(this.codebase, system);
            }
            catch (PolicyUtils.ExpansionFailedException ex) {
                ex.printStackTrace(System.err);
                return this.codebase;
            }
        }

        Collection<PrincipalEntry> getPrincipals(Properties system) {
            return this.principals;
        }

        Collection<PermissionEntry> getPermissions() {
            return this.permissions;
        }
    }

    static class KeystoreEntry {
        private final String url;
        private final String type;

        KeystoreEntry(String url, String type) {
            this.url = url;
            this.type = type;
        }

        public String toString() {
            String newline = "\n";
            int l = this.getUrl() == null ? 0 : this.getUrl().length();
            l += this.getType() == null ? 0 : this.getType().length();
            StringBuffer sb = new StringBuffer(l += 4);
            if (this.getUrl() != null) {
                sb.append(this.getUrl()).append(newline);
            }
            if (this.getType() != null) {
                sb.append(this.getType()).append(newline);
            }
            return sb.toString();
        }

        String getUrl() {
            return this.url;
        }

        String getType() {
            return this.type;
        }
    }

    public static class InvalidFormatException
    extends Exception {
        private static final long serialVersionUID = 5789786270390222184L;

        public InvalidFormatException(String arg0) {
            super(arg0);
        }
    }
}

