/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.Serializable;
import java.security.Permission;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Comparator;

public class PermissionComparator
implements Comparator<Permission>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char wildcard = "*".charAt(0);

    @Override
    public int compare(Permission o1, Permission o2) {
        int hash2;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        int hash1 = c1.hashCode();
        if (hash1 < (hash2 = c2.hashCode())) {
            return -1;
        }
        if (hash1 > hash2) {
            return 1;
        }
        if (o1 instanceof UnresolvedPermission && o2 instanceof UnresolvedPermission) {
            UnresolvedPermission u1 = (UnresolvedPermission)o1;
            UnresolvedPermission u2 = (UnresolvedPermission)o2;
            String type1 = u1.getUnresolvedType();
            String type2 = u2.getUnresolvedType();
            if (type1 == null) {
                if (type2 == null) {
                    return 0;
                }
                return -1;
            }
            if (type2 == null) {
                return 1;
            }
            int comparison = type1.compareTo(type2);
            if (comparison != 0) {
                return comparison;
            }
            String name1 = u1.getUnresolvedName();
            String name2 = u2.getUnresolvedName();
            if (name1 == null) {
                if (name2 == null) {
                    return 0;
                }
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            comparison = name1.compareTo(name2);
            if (comparison != 0) {
                return comparison;
            }
            String action1 = u1.getUnresolvedName();
            String action2 = u2.getUnresolvedName();
            if (action1 == null) {
                if (action2 == null) {
                    return 0;
                }
                return -1;
            }
            if (action2 == null) {
                return 1;
            }
            comparison = action1.compareTo(action2);
            if (comparison != 0) {
                return comparison;
            }
            Certificate[] cert1 = u1.getUnresolvedCerts();
            Certificate[] cert2 = u2.getUnresolvedCerts();
            if (cert1 == null) {
                if (cert2 == null) {
                    return 0;
                }
                return -1;
            }
            if (cert2 == null) {
                return 1;
            }
            int l1 = cert1.length;
            int l2 = cert2.length;
            if (l1 < l2) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            if (Arrays.asList(cert1).containsAll(Arrays.asList(cert2))) {
                return 0;
            }
            for (int i = 0; i < l1; ++i) {
                int c = cert1[i].toString().compareTo(cert2[i].toString());
                if (c == 0) continue;
                return c;
            }
            return -1;
        }
        String name1 = o1.getName();
        String name2 = o2.getName();
        if (name1 == null) {
            if (name2 == null) {
                return 0;
            }
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        int comparison = name1.compareTo(name2);
        if (comparison != 0) {
            return comparison;
        }
        String actions1 = o1.getActions();
        String actions2 = o2.getActions();
        if (actions1 == null) {
            if (actions2 == null) {
                return 0;
            }
            return -1;
        }
        if (actions2 == null) {
            return 1;
        }
        comparison = actions1.compareTo(actions2);
        if (comparison != 0) {
            return comparison;
        }
        if (c1.equals(c2)) {
            return 0;
        }
        return -1;
    }
}

