/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Guard;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.river.api.security.PermissionComparator;
import org.apache.river.api.security.PermissionGrantBuilder;

public abstract class PermissionGrant {
    private static final Guard PD_GUARD = new RuntimePermission("getProtectionDomain");
    private static final Guard CL_GUARD = new RuntimePermission("getClassLoader");
    private final Set<Permission> perms;
    private final boolean privileged;
    private final PermissionGrant decorated;

    public PermissionGrant() {
        this.perms = Collections.emptySet();
        this.privileged = false;
        this.decorated = null;
    }

    PermissionGrant(Permission[] perm) {
        this.decorated = null;
        if (perm == null || perm.length == 0) {
            this.perms = Collections.emptySet();
            this.privileged = false;
        } else {
            TreeSet<Permission> perms = new TreeSet<Permission>(new PermissionComparator());
            boolean privileged = false;
            int l = perm.length;
            for (int i = 0; i < l; ++i) {
                perms.add(perm[i]);
                if (!(perm[i] instanceof AllPermission)) continue;
                privileged = true;
            }
            this.perms = Collections.unmodifiableSet(perms);
            this.privileged = privileged;
        }
    }

    protected PermissionGrant(PermissionGrant decorated) {
        PD_GUARD.checkGuard(null);
        CL_GUARD.checkGuard(null);
        this.decorated = decorated;
        this.perms = Collections.emptySet();
        this.privileged = false;
    }

    protected final PermissionGrant decorated() {
        return this.decorated;
    }

    public final boolean isPrivileged() {
        if (this.decorated() != null) {
            return this.decorated().isPrivileged();
        }
        return this.privileged;
    }

    public abstract boolean implies(ProtectionDomain var1);

    public abstract boolean implies(ClassLoader var1, Principal[] var2);

    public abstract boolean implies(CodeSource var1, Principal[] var2);

    public final Collection<Permission> getPermissions() {
        if (this.decorated() != null) {
            return this.decorated().getPermissions();
        }
        return this.perms;
    }

    public abstract boolean isVoid();

    public abstract PermissionGrantBuilder getBuilderTemplate();
}

