/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.river.api.security.CertificateGrant;
import org.apache.river.api.security.ClassLoaderGrant;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PrincipalGrant;
import org.apache.river.api.security.ProtectionDomainGrant;
import org.apache.river.api.security.URIGrant;

class PermissionGrantBuilderImp
extends PermissionGrantBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final PermissionGrant nullGrant = new NullPermissionGrant();
    private URI[] uri;
    private Certificate[] certs;
    private Principal[] principals;
    private Permission[] permissions;
    private int context;
    private boolean hasDomain;
    private transient Collection<URI> uris;
    private transient WeakReference<ProtectionDomain> domain;

    PermissionGrantBuilderImp() {
        this.reset();
    }

    @Override
    public final PermissionGrantBuilder reset() {
        this.uri = null;
        if (this.uris != null) {
            this.uris.clear();
        }
        this.certs = null;
        this.domain = null;
        this.hasDomain = false;
        this.principals = null;
        this.permissions = null;
        this.context = -1;
        return this;
    }

    @Override
    public PermissionGrantBuilder context(int context) {
        if (context < 0) {
            throw new IllegalStateException("context must be >= 0");
        }
        if (context > 4) {
            throw new IllegalStateException("context must be <= 4");
        }
        this.context = context;
        return this;
    }

    @Override
    public PermissionGrantBuilder uri(URI uri) {
        if (this.uris == null) {
            this.uris = new ArrayList<URI>(6);
        }
        this.uris.add(uri);
        return this;
    }

    @Override
    public PermissionGrantBuilder clazz(Class cl) {
        ProtectionDomain pd;
        if (cl != null && (pd = cl.getProtectionDomain()) != null) {
            this.domain = new WeakReference<ProtectionDomain>(pd);
            this.hasDomain = true;
        }
        return this;
    }

    @Override
    public PermissionGrantBuilder setDomain(WeakReference<ProtectionDomain> pd) {
        this.domain = pd;
        if (this.domain != null) {
            this.hasDomain = true;
        }
        return this;
    }

    @Override
    public PermissionGrantBuilder certificates(Certificate[] certs) {
        this.certs = certs;
        return this;
    }

    @Override
    public PermissionGrantBuilder principals(Principal[] pals) {
        this.principals = pals;
        return this;
    }

    @Override
    public PermissionGrantBuilder permissions(Permission[] permissions) {
        this.permissions = permissions;
        return this;
    }

    @Override
    public PermissionGrant build() {
        switch (this.context) {
            case 0: {
                return new ClassLoaderGrant(this.domain, this.principals, this.permissions);
            }
            case 4: {
                if (this.uris != null && !this.uris.isEmpty()) {
                    this.uri = this.uris.toArray(new URI[this.uris.size()]);
                }
                if (this.uri == null) {
                    this.uri = new URI[0];
                }
                return new URIGrant(this.uri, this.certs, this.principals, this.permissions);
            }
            case 2: {
                return new CertificateGrant(this.certs, this.principals, this.permissions);
            }
            case 1: {
                return new ProtectionDomainGrant(this.domain, this.principals, this.permissions);
            }
            case 3: {
                return new PrincipalGrant(this.principals, this.permissions);
            }
        }
        return nullGrant;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.domain = this.hasDomain ? new WeakReference<ProtectionDomain>(null) : null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.uris != null && !this.uris.isEmpty()) {
            this.uri = this.uris.toArray(new URI[this.uris.size()]);
        }
        out.defaultWriteObject();
    }

    private Object readResolve() {
        if ((this.context == 0 || this.context == 1) && this.hasDomain) {
            return nullGrant;
        }
        return this.build();
    }

    private static class NullPermissionGrant
    extends PermissionGrant
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NullPermissionGrant() {
        }

        @Override
        public boolean implies(ProtectionDomain pd) {
            return false;
        }

        @Override
        public boolean implies(ClassLoader cl, Principal[] pal) {
            return false;
        }

        @Override
        public boolean implies(CodeSource codeSource, Principal[] pal) {
            return false;
        }

        @Override
        public boolean isVoid() {
            return true;
        }

        @Override
        public PermissionGrantBuilder getBuilderTemplate() {
            return new PermissionGrantBuilderImp();
        }

        public String toString() {
            return "Null PermissionGrant";
        }

        private Object readResolve() {
            return nullGrant;
        }
    }
}

