/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PermissionGrantBuilderImp;
import org.apache.river.api.security.PrincipalGrant;

class ProtectionDomainGrant
extends PrincipalGrant {
    private static final long serialVersionUID = 1L;
    private final WeakReference<ProtectionDomain> domain;
    private final int hashCode;

    ProtectionDomainGrant(WeakReference<ProtectionDomain> domain, Principal[] groups, Permission[] perm) {
        super(groups, perm);
        this.domain = domain;
        int hash = 7;
        hash = 13 * hash + (this.domain != null ? this.domain.hashCode() : 0);
        this.hashCode = hash = 13 * hash + super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        if (o instanceof ProtectionDomainGrant) {
            ProtectionDomainGrant c = (ProtectionDomainGrant)o;
            if (!super.equals(o)) {
                return false;
            }
            if (this.domain != null && this.domain.equals(c.domain)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(400);
        sb.append(super.toString()).append("ProtectionDomain: \n");
        ProtectionDomain pd = null;
        if (this.domain != null) {
            pd = (ProtectionDomain)this.domain.get();
            if (pd != null) {
                sb.append(pd.toString());
            } else {
                sb.append("Grant is void - ProtectionDomain is null");
            }
        } else {
            sb.append("Grant applies to all ProtectionDomain's");
        }
        return sb.toString();
    }

    @Override
    public boolean implies(ProtectionDomain pd) {
        return this.impliesProtectionDomain(pd) && this.implies(this.getPrincipals(pd));
    }

    @Override
    public boolean implies(ClassLoader cl, Principal[] pal) {
        return this.impliesClassLoader(cl) && this.implies(pal);
    }

    @Override
    public boolean implies(CodeSource codeSource, Principal[] pal) {
        return this.impliesCodeSource(codeSource) && this.implies(pal);
    }

    private boolean impliesProtectionDomain(ProtectionDomain pd) {
        if (this.domain == null) {
            return true;
        }
        if (pd == null) {
            return false;
        }
        if (this.domain.get() == null) {
            return false;
        }
        if (pd.equals(this.domain.get())) {
            return true;
        }
        return this.impliesClassLoader(pd.getClassLoader()) && this.impliesCodeSource(pd.getCodeSource());
    }

    private boolean impliesClassLoader(ClassLoader cl) {
        if (this.domain == null) {
            return true;
        }
        if (cl == null) {
            return false;
        }
        if (this.domain.get() == null) {
            return false;
        }
        ClassLoader thisloader = ((ProtectionDomain)this.domain.get()).getClassLoader();
        if (thisloader != null) {
            return thisloader.equals(cl);
        }
        return false;
    }

    private boolean impliesCodeSource(CodeSource codeSource) {
        block8: {
            ProtectionDomain pd;
            ProtectionDomain protectionDomain = pd = this.domain != null ? (ProtectionDomain)this.domain.get() : null;
            if (pd == null) {
                return false;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == codeSource) {
                return true;
            }
            if (cs == null && codeSource == null) {
                return true;
            }
            if (cs == null) {
                return false;
            }
            Object[] myCerts = cs.getCertificates();
            Object[] hisCerts = codeSource.getCertificates();
            if (myCerts != null && !Arrays.equals(myCerts, hisCerts)) {
                return false;
            }
            try {
                URI myLocation = cs.getLocation().toURI();
                URI hisLocation = codeSource.getLocation().toURI();
                if (myLocation.equals(hisLocation)) {
                    return true;
                }
            }
            catch (URISyntaxException ex) {
                URL myLocation = cs.getLocation();
                URL hisLocation = codeSource.getLocation();
                if (!myLocation.toExternalForm().equals(hisLocation.toExternalForm())) break block8;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isVoid() {
        if (super.isVoid()) {
            return true;
        }
        return this.domain != null && this.domain.get() == null;
    }

    @Override
    public PermissionGrantBuilder getBuilderTemplate() {
        PermissionGrantBuilder pgb = super.getBuilderTemplate();
        if (pgb instanceof PermissionGrantBuilderImp) {
            PermissionGrantBuilderImp pgbi = (PermissionGrantBuilderImp)pgb;
            pgbi.setDomain(this.domain).context(1);
        }
        return pgb;
    }

    private Object writeReplace() {
        return this.getBuilderTemplate();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("PermissionGrantBuilder required");
    }
}

