/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.river.api.security.CertificateGrant;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PolicyUtils;
import org.apache.river.impl.net.UriString;

class URIGrant
extends CertificateGrant {
    private static final long serialVersionUID = 1L;
    private final Collection<URI> location;
    private final int hashCode;

    URIGrant(URI[] uri, Certificate[] certs, Principal[] pals, Permission[] perm) {
        super(certs, pals, perm);
        int l = uri.length;
        ArrayList<URI> uris = new ArrayList<URI>(l);
        for (int i = 0; i < l; ++i) {
            try {
                uris.add(uri[i] != null ? UriString.normalise(uri[i]) : null);
                continue;
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace(System.err);
            }
        }
        this.location = Collections.unmodifiableCollection(uris);
        int hash = 3;
        hash = 67 * hash + (this.location != null ? this.location.hashCode() : 0);
        this.hashCode = hash = 67 * hash + super.hashCode();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.hashCode() != this.hashCode()) {
            return false;
        }
        if (o instanceof URIGrant) {
            URIGrant c = (URIGrant)o;
            if (!super.equals(o)) {
                return false;
            }
            if (this.location == c.location) {
                return true;
            }
            if (this.location.equals(c.location)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        return sb.append("\n").append("URI: ").append(this.location.toString()).append(super.toString()).append("\n").toString();
    }

    @Override
    public boolean implies(ClassLoader cl, Principal[] p) {
        if (!this.implies(p)) {
            return false;
        }
        if (this.location.isEmpty()) {
            return true;
        }
        Iterator<URI> it = this.location.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            return true;
        }
        if (cl == null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean implies(CodeSource codeSource, Principal[] p) {
        if (!this.implies(p)) {
            return false;
        }
        if (codeSource == null) {
            return false;
        }
        if (this.location.isEmpty()) {
            return true;
        }
        int l = this.location.size();
        URI[] uris = this.location.toArray(new URI[l]);
        for (int i = 0; i < l; ++i) {
            if (uris[i] != null) continue;
            return true;
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            return false;
        }
        URI implied = null;
        try {
            implied = AccessController.doPrivileged(new NormaliseURLAction(url));
        }
        catch (PrivilegedActionException ex) {
            Exception cause = ex.getException();
            cause.printStackTrace(System.err);
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (!this.implies(uris[i], implied)) continue;
            return true;
        }
        return false;
    }

    final boolean implies(URI grant, URI implied) {
        if (grant != null) {
            if (grant.equals(implied)) {
                return true;
            }
            if (!grant.getScheme().equals(implied.getScheme())) {
                return false;
            }
            String thisHost = grant.getHost();
            if (thisHost != null) {
                String thatHost = implied.getHost();
                if (thatHost == null) {
                    return false;
                }
                if ((thisHost.length() != 0 && !"localhost".equals(thisHost) || thatHost.length() != 0 && !"localhost".equals(thatHost)) && !thisHost.equals(thatHost)) {
                    boolean isPartialWild;
                    boolean hostNameMatches = false;
                    boolean bl = isPartialWild = thisHost.charAt(0) == '*';
                    if (isPartialWild) {
                        boolean isWild;
                        boolean bl2 = isWild = thisHost.length() == 1;
                        if (isWild) {
                            hostNameMatches = true;
                        } else {
                            int length = thisHost.length() - 1;
                            hostNameMatches = thatHost.regionMatches(thatHost.length() - length, thisHost, 1, length);
                        }
                    }
                    if (!hostNameMatches) {
                        return false;
                    }
                }
            }
            if (grant.getPort() != -1 && grant.getPort() != implied.getPort()) {
                return false;
            }
            String thisFile = grant.getPath();
            String thatFile = implied.getPath();
            if (thatFile == null || thisFile == null) {
                return false;
            }
            if (thisFile.endsWith("/-")) {
                if (!thatFile.startsWith(thisFile.substring(0, thisFile.length() - 2))) {
                    return false;
                }
            } else if (thisFile.endsWith("/*")) {
                if (!thatFile.startsWith(thisFile.substring(0, thisFile.length() - 2))) {
                    return false;
                }
                if (thatFile.indexOf("/", thisFile.length() - 1) != -1) {
                    return false;
                }
            } else if (!thisFile.equals(thatFile)) {
                if (!thisFile.endsWith("/")) {
                    if (!thatFile.equals(thisFile + "/")) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (grant.getFragment() != null && !grant.getFragment().equals(implied.getFragment())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public PermissionGrantBuilder getBuilderTemplate() {
        PermissionGrantBuilder pgb = super.getBuilderTemplate();
        Iterator<URI> it = this.location.iterator();
        while (it.hasNext()) {
            pgb.uri(it.next());
        }
        pgb.context(4);
        return pgb;
    }

    private Object writeReplace() {
        return this.getBuilderTemplate();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("PermissionGrantBuilder required");
    }

    private static class NormaliseURLAction
    implements PrivilegedExceptionAction<URI> {
        private final URL codesource;

        NormaliseURLAction(URL codebase) {
            this.codesource = codebase;
        }

        @Override
        public URI run() throws Exception {
            return PolicyUtils.normalizeURL(this.codesource);
        }
    }
}

