/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.config.builder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import org.apache.river.config.ConfigurationFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityConfigurationBuilder
implements ConfigurationFactory {
    private String serviceHost = null;
    private int servicePort = 0;
    private String registryHost = null;
    private int registryPort = 0;
    private String group = "org.apache.river.demo";
    private String codebase = "";
    private boolean disableMulticast = false;

    public int getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public String getServiceHost() {
        return this.serviceHost;
    }

    public void setServiceHost(String serviceHost) {
        this.serviceHost = serviceHost;
    }

    public String getRegistryHost() {
        return this.registryHost;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public boolean isDisableMulticast() {
        return this.disableMulticast;
    }

    public void setDisableMulticast(boolean disableMulticast) {
        this.disableMulticast = disableMulticast;
    }

    public String getConfigurationText() throws IOException {
        Properties p = new Properties();
        p.load(this.getClass().getResourceAsStream("velocity.properties"));
        VelocityEngine ve = new VelocityEngine(p);
        VelocityContext context = new VelocityContext();
        if (this.disableMulticast) {
            String mcstr = "multicastInterfaces = new java.net.NetworkInterface[] { } ;";
            context.put("multicastInterfaces", (Object)"multicastInterfaces = new java.net.NetworkInterface[] { } ;");
        }
        context.put("registryEndpoint", (Object)String.format("TcpServerEndpoint.getInstance(%s,%d)", this.stringToLiteral(this.registryHost), this.registryPort));
        context.put("serverEndpoint", (Object)String.format("TcpServerEndpoint.getInstance(%s,%d)", this.stringToLiteral(this.serviceHost), this.servicePort));
        context.put("groups", (Object)String.format("\"%s\"", this.group));
        Template template = ve.getTemplate(this.getClass().getResource("template.vm").toExternalForm());
        StringWriter sw = new StringWriter();
        template.merge((Context)context, (Writer)sw);
        return sw.toString();
    }

    private String stringToLiteral(String s) {
        if (s == null) {
            return "null";
        }
        return String.format("\"%s\"", s);
    }

    @Override
    public Configuration createConfiguration() throws ConfigurationException {
        try {
            StringReader sr = new StringReader(this.getConfigurationText());
            ConfigurationFile cf = new ConfigurationFile(sr, null);
            return cf;
        }
        catch (ConfigurationException c) {
            throw c;
        }
        catch (Exception e) {
            throw new ConfigurationException("", e);
        }
    }

    public void print(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        this.print(fw);
        fw.close();
    }

    public void print(Writer wr) throws IOException {
        wr.append(this.getConfigurationText());
    }
}

