/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.discovery;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import org.apache.river.extra.discovery.ServiceFinder;

public class UnicastServiceFinder
implements ServiceFinder {
    private static final Logger logger = Logger.getLogger(UnicastServiceFinder.class.getSimpleName());
    private LookupLocator[] lookupLocators;

    public UnicastServiceFinder(LookupLocator[] lookupLocators) {
        this.setLookupLocators(lookupLocators);
    }

    @Override
    public Object findNewService(ServiceTemplate template) throws RemoteException {
        Object proxy = null;
        for (int i = 0; i < this.lookupLocators.length && null == proxy; ++i) {
            try {
                ServiceRegistrar ssr = this.lookupLocators[i].getRegistrar();
                proxy = ssr.lookup(template);
                continue;
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Unable to lookup service on jini://" + this.lookupLocators[i].getHost() + ":" + this.lookupLocators[i].getPort(), ioe);
                continue;
            }
            catch (ClassNotFoundException cce) {
                logger.log(Level.WARNING, "Unable to lookup service on jini://" + this.lookupLocators[i].getHost() + ":" + this.lookupLocators[i].getPort(), cce);
            }
        }
        if (null == proxy) {
            throw new RemoteException("Cannot find valid service");
        }
        return proxy;
    }

    @Override
    public void terminate() {
    }

    private void setLookupLocators(LookupLocator[] lookupLocators) {
        if (null == lookupLocators) {
            throw new IllegalArgumentException("LookupLocator array cannot be null");
        }
        if (0 == lookupLocators.length) {
            throw new IllegalArgumentException("LookupLocator array must have length > 0");
        }
        this.lookupLocators = lookupLocators;
    }
}

