/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.helpers;

import java.net.URL;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import org.apache.river.extra.helpers.ConfigHelper;

public class ExportHelper
extends ConfigHelper {
    private static final Logger logger = Logger.getLogger(ExportHelper.class.getName());

    public ExportHelper(URL resource) throws ConfigurationException {
        super(resource);
    }

    public ExportHelper(Configuration configuration) {
        super(configuration);
    }

    public <T extends Remote> T export(T obj, Class<T> cls) throws ExportException, ConfigurationException {
        return this.export(obj, cls, null);
    }

    public <T extends Remote> T export(T obj, Class<T> cls, String component) throws ExportException, ConfigurationException {
        if (component == null) {
            component = this.getComponent(cls);
        }
        Exporter exp = this.getExporter(component);
        Remote exportedObj = exp.export(obj);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("proxy=" + exportedObj);
        }
        return (T)exportedObj;
    }

    public Exporter getExporter(String component) throws ConfigurationException {
        Exporter exp = (Exporter)this.configuration.getEntry(component, "exporter", Exporter.class, null);
        if (exp == null) {
            ServerEndpoint se = this.getServerEndpoint(component);
            InvocationLayerFactory ilf = this.getILFactory(component);
            boolean keepAlive = this.getKeepAlive(component);
            boolean dgc = this.getDgc(component);
            Uuid uuid = this.getUuid(component);
            exp = new BasicJeriExporter(se, ilf, dgc, keepAlive, uuid);
        }
        return exp;
    }

    private InvocationLayerFactory getILFactory(String component) throws ConfigurationException {
        InvocationLayerFactory ilf = (InvocationLayerFactory)this.configuration.getEntry(component, "ilf", InvocationLayerFactory.class, null);
        if (ilf == null) {
            InvocationConstraints ic = this.getInvocationConstraints(component);
            if (ic == null) {
                ic = InvocationConstraints.EMPTY;
            }
            BasicMethodConstraints serverConstraints = new BasicMethodConstraints(ic);
            ilf = new BasicILFactory(serverConstraints, null);
        }
        return ilf;
    }

    private ServerEndpoint getServerEndpoint(String component) throws ConfigurationException {
        ServerEndpoint se = (ServerEndpoint)this.configuration.getEntry(component, "serverEndpoint", ServerEndpoint.class, Configuration.NO_DEFAULT);
        if (se == null) {
            throw new NullPointerException("serverEndpoint is null in " + component);
        }
        return se;
    }

    private boolean getKeepAlive(String component) throws ConfigurationException {
        Boolean b = (Boolean)this.configuration.getEntry(component, "keepAlive", Boolean.TYPE, false);
        return b;
    }
}

