/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.helpers;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.apache.river.extra.helpers.ConfigHelper;

public class ProxyHelper
extends ConfigHelper {
    private static final Logger logger = Logger.getLogger(ProxyHelper.class.getName());

    public ProxyHelper(URL resource) throws ConfigurationException {
        super(resource);
    }

    public ProxyHelper(Configuration configuration) {
        super(configuration);
    }

    public <T> T prepare(T proxy, String component) throws RemoteException, ConfigurationException {
        if (component == null) {
            component = this.getComponent(proxy.getClass());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(component);
        }
        ProxyPreparer preparer = this.getPreparer(component);
        proxy = preparer.prepareProxy(proxy);
        return proxy;
    }

    private ProxyPreparer getPreparer(String component) throws ConfigurationException {
        ProxyPreparer preparer = (ProxyPreparer)this.configuration.getEntry(component, "preparer", ProxyPreparer.class, null);
        if (preparer == null) {
            boolean verify = this.getVerify(component);
            InvocationConstraints ic = this.getInvocationConstraints(component);
            if (ic == null) {
                preparer = new BasicProxyPreparer(verify, null);
            } else {
                BasicMethodConstraints mc = new BasicMethodConstraints(ic);
                preparer = new BasicProxyPreparer(verify, mc, null);
            }
        }
        return preparer;
    }
}

