/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.selfhealing;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.core.lookup.ServiceTemplate;
import org.apache.river.extra.discovery.ServiceFinder;

public class ServiceWrapper
implements InvocationHandler,
Administrable {
    private static final Logger logger = Logger.getLogger(ServiceWrapper.class.getSimpleName());
    private ServiceFinder finder;
    private ServiceTemplate template;
    private Object proxy;

    ServiceWrapper(ServiceFinder finder, ServiceTemplate template) {
        this.setServiceFinder(finder);
        this.setServiceTemplate(template);
    }

    @Override
    public Object invoke(Object ignored, Method method, Object[] args) throws Throwable {
        this.initServiceProxy();
        Object response = null;
        boolean serviceCallFailed = false;
        try {
            response = this.execute(method, args);
        }
        catch (RemoteException re) {
            logger.log(Level.WARNING, "Service invocation failed: " + re.getMessage(), re);
            serviceCallFailed = true;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Service invocation failed: " + t.getMessage(), t);
            serviceCallFailed = true;
        }
        if (serviceCallFailed) {
            logger.info("Service call failed.  Looking for replacement service");
            this.initServiceProxy();
            response = this.execute(method, args);
        }
        return response;
    }

    @Override
    public Object getAdmin() throws RemoteException {
        if (null == this.proxy) {
            throw new RemoteException("No service proxy");
        }
        return ((Administrable)this.proxy).getAdmin();
    }

    private Object execute(Method method, Object[] args) throws RemoteException {
        try {
            logger.finest("Invoking method [" + method + "] on " + this.proxy);
            return method.invoke(this.proxy, args);
        }
        catch (IllegalAccessException iae) {
            throw new RemoteException("Cannot execute method because " + iae.getMessage(), iae);
        }
        catch (IllegalArgumentException iae) {
            throw new RemoteException("Cannot execute method because " + iae.getMessage(), iae);
        }
        catch (InvocationTargetException ite) {
            throw new RemoteException("Cannot execute method because " + ite.getMessage(), ite);
        }
    }

    private void initServiceProxy() throws RemoteException {
        if (null == this.proxy) {
            logger.finer("Looking for a service proxy");
            this.proxy = this.finder.findNewService(this.template);
        }
    }

    private void setServiceFinder(ServiceFinder finder) {
        if (null == finder) {
            throw new IllegalArgumentException("ServiceFinder cannot be null");
        }
        this.finder = finder;
    }

    private void setServiceTemplate(ServiceTemplate template) {
        if (null == template) {
            throw new IllegalArgumentException("ServiceTemplate cannot be null");
        }
        this.template = template;
    }
}

