/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionDecorator<T>
extends AbstractCollection<Referrer<T>>
implements Collection<Referrer<T>> {
    private final Collection<T> col;
    private final ReferenceQueuingFactory<T, Referrer<T>> rqf;
    private final boolean enque;
    private final boolean temporary;

    CollectionDecorator(Collection<T> col, ReferenceQueuingFactory<T, Referrer<T>> rqf, boolean enque, boolean temporary) {
        this.col = col;
        this.rqf = rqf;
        this.enque = enque;
        this.temporary = temporary;
    }

    @Override
    public Iterator<Referrer<T>> iterator() {
        return new Iter<T>(this.col.iterator(), this.rqf);
    }

    @Override
    public int size() {
        return this.col.size();
    }

    @Override
    public boolean add(Referrer<T> t) {
        return this.col.add(t != null ? (Object)t.get() : null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iter<T>
    implements Iterator<Referrer<T>> {
        Iterator<T> iterator;
        private final ReferenceQueuingFactory<T, Referrer<T>> rqf;

        Iter(Iterator<T> it, ReferenceQueuingFactory<T, Referrer<T>> rqf) {
            this.iterator = it;
            this.rqf = rqf;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Referrer<T> next() {
            return this.rqf.referenced(this.iterator.next(), CollectionDecorator.this.enque, CollectionDecorator.this.temporary);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

