/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.EntryIteratorFacade;
import au.net.zeus.collection.ReferenceQueuingFactory;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntrySetFacade<O, R>
extends AbstractSet<O>
implements Set<O> {
    private Set<R> set;
    private ReferenceQueuingFactory<O, R> factory;

    EntrySetFacade(Set<R> set, ReferenceQueuingFactory<O, R> wf) {
        this.set = set;
        this.factory = wf;
    }

    @Override
    public int size() {
        this.factory.processQueue();
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        this.factory.processQueue();
        return this.set.isEmpty();
    }

    @Override
    public Iterator<O> iterator() {
        this.factory.processQueue();
        return new EntryIteratorFacade<O, R>(this.set.iterator(), this.factory);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean add(O e) {
        this.factory.processQueue();
        if (e == null) {
            return false;
        }
        return this.set.add(this.factory.referenced(e, true, false));
    }
}

