/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.CollectionDecorator;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.RefQueue;
import au.net.zeus.collection.RefReferenceQueue;
import au.net.zeus.collection.ReferenceIterator;
import au.net.zeus.collection.ReferenceProcessor;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import au.net.zeus.collection.SerializationOfReferenceCollection;
import au.net.zeus.collection.TimedRefQueue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceCollection<T>
extends AbstractCollection<T>
implements Collection<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<Referrer<T>> col;
    private final ReferenceQueuingFactory<T, Referrer<T>> rqf;
    private final Ref type;

    ReferenceCollection(Collection<Referrer<T>> col, Ref type, boolean gcThread, long gcCycle) {
        RefQueue que = null;
        if (type == Ref.TIME) {
            que = new TimedRefQueue();
        } else if (type != Ref.STRONG) {
            que = new RefReferenceQueue();
        }
        this.col = col;
        ReferenceProcessor<T> rp = new ReferenceProcessor<T>(col, type, que, gcThread, col);
        this.type = type;
        this.rqf = rp;
        rp.start(gcCycle);
    }

    ReferenceCollection(Collection<Referrer<T>> col, ReferenceQueuingFactory<T, Referrer<T>> rqf, Ref type) {
        this.col = col;
        this.rqf = rqf;
        this.type = type;
    }

    void processQueue() {
        this.rqf.processQueue();
    }

    ReferenceQueuingFactory<T, Referrer<T>> getRQF() {
        return this.rqf;
    }

    Ref getRef() {
        return this.type;
    }

    Referrer<T> wrapObj(T t, boolean enqueue, boolean temporary) {
        return this.rqf.referenced(t, enqueue, temporary);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.col.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.col.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.processQueue();
        return this.col.contains(this.wrapObj(o, false, true));
    }

    @Override
    public Iterator<T> iterator() {
        this.processQueue();
        return new ReferenceIterator<T>(this.col.iterator());
    }

    @Override
    public boolean add(T e) {
        this.processQueue();
        return this.col.add(this.wrapObj(e, true, false));
    }

    @Override
    public boolean remove(Object o) {
        this.processQueue();
        return this.col.remove(this.wrapObj(o, false, true));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.processQueue();
        return this.col.containsAll(new CollectionDecorator(c, this.getRQF(), false, true));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.processQueue();
        return this.col.addAll(new CollectionDecorator<T>(c, this.getRQF(), true, false));
    }

    @Override
    public void clear() {
        this.col.clear();
    }

    @Override
    public String toString() {
        return this.col.toString();
    }

    @Override
    public int hashCode() {
        if (this.col instanceof List || this.col instanceof Set) {
            return ((Object)this.col).hashCode();
        }
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.col instanceof List || this.col instanceof Set) {
            return ((Object)this.col).equals(o);
        }
        return false;
    }

    final Object writeReplace() throws ObjectStreamException {
        try {
            return SerializationOfReferenceCollection.create(this.getClass(), this.col, this.type);
        }
        catch (InstantiationException ex) {
            throw new WriteAbortedException("Unable to create serialization proxy", ex);
        }
        catch (IllegalAccessException ex) {
            throw new WriteAbortedException("Unable to create serialization proxy", ex);
        }
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }
}

