/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.example.browser.Browser;
import com.sun.jini.example.browser.EntryTreePanel;
import com.sun.jini.outrigger.AdminIterator;
import com.sun.jini.outrigger.JavaSpaceAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.Lease;
import net.jini.space.JavaSpace05;
import net.jini.space.MatchSet;

class SpaceBrowser
extends JFrame {
    private static final int MINIMUM_WINDOW_WIDTH = 320;
    private Browser browser;

    public SpaceBrowser(Object proxy, Browser browser) {
        super("SpaceBrowser");
        this.browser = browser;
        SpaceEntryPanel entryPanel = new SpaceEntryPanel(proxy);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new BrowserMenuBar(entryPanel), "North");
        this.getContentPane().add((Component)entryPanel, "Center");
        this.validate();
        this.pack();
        this.setSize(this.getSize().width < 320 ? 320 : this.getSize().width, this.getSize().height);
        Rectangle bounds = browser.getBounds();
        Dimension dialogSize = this.getPreferredSize();
        int xpos = bounds.x + (bounds.width - dialogSize.width) / 2;
        int ypos = bounds.y + (bounds.height - dialogSize.height) / 2;
        this.setLocation(xpos < 0 ? 0 : xpos, ypos < 0 ? 0 : ypos);
    }

    class SpaceEntryPanel
    extends EntryTreePanel {
        private Object proxy;

        public SpaceEntryPanel(Object proxy) {
            super(false);
            this.proxy = proxy;
            this.refreshPanel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Entry[] getEntryArray() {
            try {
                LinkedList<Entry> acc;
                block29: {
                    acc = new LinkedList<Entry>();
                    if (this.proxy instanceof JavaSpace05) {
                        MatchSet set = ((JavaSpace05)this.proxy).contents(Collections.singleton(null), null, -1L, Integer.MAX_VALUE);
                        Lease lease = set.getLease();
                        if (lease != null) {
                            lease = (Lease)((SpaceBrowser)SpaceBrowser.this).browser.leasePreparer.prepareProxy(lease);
                            ((SpaceBrowser)SpaceBrowser.this).browser.leaseMgr.renewUntil(lease, -1L, null);
                        }
                        try {
                            while (true) {
                                try {
                                    while (true) {
                                        Entry e;
                                        if ((e = set.next()) == null) {
                                            break block29;
                                        }
                                        acc.add(e);
                                    }
                                }
                                catch (UnusableEntryException e) {
                                    Browser.logger.log(Level.INFO, "unusable entry", e);
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            if (lease != null) {
                                try {
                                    ((SpaceBrowser)SpaceBrowser.this).browser.leaseMgr.cancel(lease);
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                    AdminIterator iter2 = ((JavaSpaceAdmin)this.proxy).contents(null, null, 128);
                    try {
                        while (true) {
                            try {
                                while (true) {
                                    Entry e;
                                    if ((e = iter2.next()) == null) {
                                        break block29;
                                    }
                                    acc.add(e);
                                }
                            }
                            catch (UnusableEntryException e) {
                                Browser.logger.log(Level.INFO, "unusable entry", e);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        try {
                            iter2.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return acc.toArray(new Entry[acc.size()]);
            }
            catch (Throwable t) {
                Browser.logger.log(Level.INFO, "obtaining entries failed", t);
                return null;
            }
        }
    }

    class BrowserMenuBar
    extends JMenuBar {
        private EntryTreePanel entryPanel;

        public BrowserMenuBar(EntryTreePanel entryPanel) {
            this.entryPanel = entryPanel;
            JMenu fileMenu = this.add(new JMenu("File"));
            JMenuItem mitem = fileMenu.add(new JMenuItem("Refresh"));
            mitem.addActionListener(SpaceBrowser.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    BrowserMenuBar.this.entryPanel.refreshPanel();
                }
            }));
            mitem = fileMenu.add(new JMenuItem("Close"));
            mitem.addActionListener(SpaceBrowser.this.browser.wrap(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    SpaceBrowser.this.setVisible(false);
                }
            }));
        }
    }
}

