/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerAdminProxy;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerProxy;
import com.sun.jini.fiddler.FiddlerRegistration;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements Serializable,
TrustVerifier {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl innerProxy;
    private final Uuid proxyID;

    ProxyVerifier(Fiddler innerProxy, Uuid proxyID) {
        if (!(innerProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("cannot construct verifier - canonical inner proxy is not an instance of RemoteMethodControl");
        }
        if (!(innerProxy instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("cannot construct verifier - canonical inner proxy is not an instance of TrustEquivalence");
        }
        this.innerProxy = (RemoteMethodControl)((Object)innerProxy);
        this.proxyID = proxyID;
    }

    @Override
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        Uuid inputProxyID;
        RemoteMethodControl inputProxy;
        if (obj == null || ctx == null) {
            throw new NullPointerException("arguments must not be null");
        }
        if (obj instanceof FiddlerProxy.ConstrainableFiddlerProxy) {
            inputProxy = (RemoteMethodControl)((Object)((FiddlerProxy)obj).server);
            inputProxyID = ((ReferentUuid)obj).getReferentUuid();
        } else if (obj instanceof FiddlerRegistration.ConstrainableFiddlerRegistration) {
            FiddlerRegistration reg = (FiddlerRegistration)obj;
            if (!this.isTrustedObject(reg.eventReg.getSource(), ctx)) {
                return false;
            }
            if (!this.isTrustedObject(reg.eventReg.getLease(), ctx)) {
                return false;
            }
            inputProxy = (RemoteMethodControl)((Object)reg.server);
            inputProxyID = this.proxyID;
        } else if (obj instanceof FiddlerLease.ConstrainableFiddlerLease) {
            inputProxy = (RemoteMethodControl)((Object)((FiddlerLease)obj).server);
            inputProxyID = ((FiddlerLease)obj).getServerID();
        } else if (obj instanceof FiddlerAdminProxy.ConstrainableFiddlerAdminProxy) {
            inputProxy = (RemoteMethodControl)((Object)((FiddlerAdminProxy)obj).server);
            inputProxyID = ((ReferentUuid)obj).getReferentUuid();
        } else if (obj instanceof RemoteMethodControl) {
            inputProxy = (RemoteMethodControl)obj;
            inputProxyID = this.proxyID;
        } else {
            return false;
        }
        MethodConstraints mConstraints = inputProxy.getConstraints();
        TrustEquivalence constrainedInnerProxy = (TrustEquivalence)((Object)this.innerProxy.setConstraints(mConstraints));
        return constrainedInnerProxy.checkTrustEquivalence(inputProxy) && this.proxyID.equals(inputProxyID);
    }
}

