/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;

public class Levels {
    public static final Level FAILED = Levels.createLevel("FAILED", 600, null);
    public static final Level HANDLED = Levels.createLevel("HANDLED", 550, null);

    private Levels() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    private static Level createLevel(String name, int value, String resourceBundleName) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ClassReplacingObjectOutputStream out = new ClassReplacingObjectOutputStream(bytes, LevelData.class, Level.class);
            out.writeObject(new LevelData(name, value, resourceBundleName));
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
            Level result = (Level)in.readObject();
            in.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static final class ClassReplacingObjectOutputStream
    extends ObjectOutputStream {
        private final ObjectStreamClass from;
        private final ObjectStreamClass to;

        ClassReplacingObjectOutputStream(OutputStream out, Class from, Class to) throws IOException {
            super(out);
            this.from = ObjectStreamClass.lookup(from);
            this.to = ObjectStreamClass.lookup(to);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            if (this.from.equals(desc)) {
                desc = this.to;
            }
            super.writeClassDescriptor(desc);
        }
    }

    private static final class LevelData
    implements Serializable {
        private static final long serialVersionUID = -8176160795706313070L;
        private final String name;
        private final int value;
        private final String resourceBundleName;
        private final String localizedLevelName;

        LevelData(String name, int value, String resourceBundleName) {
            this.name = name;
            this.value = value;
            this.resourceBundleName = resourceBundleName;
            this.localizedLevelName = resourceBundleName == null ? name : null;
        }
    }
}

