/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.mercury.ListenerProxy;
import com.sun.jini.mercury.MailboxBackEnd;
import com.sun.jini.mercury.ProxyUtil;
import com.sun.jini.mercury.RemoteEventIteratorData;
import com.sun.jini.mercury.RemoteEventIteratorImpl;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.proxy.ThrowThis;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.event.MailboxPullRegistration;
import net.jini.event.MailboxRegistration;
import net.jini.event.RemoteEventIterator;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class Registration
implements MailboxPullRegistration,
Serializable,
ReferentUuid {
    private static final long serialVersionUID = 2L;
    final Uuid registrationID;
    final MailboxBackEnd mailbox;
    final ListenerProxy listener;
    final Lease lease;

    static Registration create(Uuid id, MailboxBackEnd server, Lease lease) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableRegistration(id, server, lease, null);
        }
        return new Registration(id, server, lease);
    }

    private Registration(Uuid id, MailboxBackEnd srv, Lease l) {
        if (id == null || srv == null || l == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.registrationID = id;
        this.mailbox = srv;
        this.listener = ListenerProxy.create(id, srv);
        this.lease = l;
    }

    @Override
    public Lease getLease() {
        return this.lease;
    }

    @Override
    public RemoteEventListener getListener() {
        return this.listener;
    }

    @Override
    public void enableDelivery(RemoteEventListener target) throws RemoteException {
        if (target instanceof ListenerProxy && this.listener.equals((ListenerProxy)target)) {
            throw new IllegalArgumentException("Cannot resubmit a target that was provided by the EventMailbox service");
        }
        try {
            this.mailbox.enableDelivery(this.registrationID, target);
        }
        catch (ThrowThis tt) {
            tt.throwRemoteException();
        }
    }

    @Override
    public void disableDelivery() throws RemoteException {
        try {
            this.mailbox.disableDelivery(this.registrationID);
        }
        catch (ThrowThis tt) {
            tt.throwRemoteException();
        }
    }

    @Override
    public RemoteEventIterator getRemoteEvents() throws RemoteException {
        RemoteEventIteratorImpl i = null;
        try {
            RemoteEventIteratorData d = this.mailbox.getRemoteEvents(this.registrationID);
            i = new RemoteEventIteratorImpl(d.uuid, this.registrationID, this.mailbox, d.events);
        }
        catch (ThrowThis tt) {
            tt.throwRemoteException();
        }
        return i;
    }

    @Override
    public void addUnknownEvents(Collection unknownEvents) throws RemoteException {
        try {
            this.mailbox.addUnknownEvents(this.registrationID, unknownEvents);
        }
        catch (ThrowThis tt) {
            tt.throwRemoteException();
        }
    }

    @Override
    public Uuid getReferentUuid() {
        return this.registrationID;
    }

    public int hashCode() {
        return this.registrationID.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare(this, o);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.mailbox == null) {
            throw new InvalidObjectException("Registration.readObject failure - mailbox field is null");
        }
        if (this.registrationID == null) {
            throw new InvalidObjectException("Registration.readObject failure - registrationID field is null");
        }
        if (this.lease == null) {
            throw new InvalidObjectException("Registration.readObject failure - lease field is null");
        }
        if (this.listener == null) {
            throw new InvalidObjectException("Registration.readObject failure - listener field is null");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize Registration instance");
    }

    static final class ConstrainableRegistration
    extends Registration
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;
        private static final Method[] methodMap1 = new Method[]{ProxyUtil.getMethod(MailboxPullRegistration.class, "getRemoteEvents", new Class[0]), ProxyUtil.getMethod(MailboxBackEnd.class, "getRemoteEvents", new Class[]{Uuid.class}), ProxyUtil.getMethod(MailboxPullRegistration.class, "getRemoteEvents", new Class[0]), ProxyUtil.getMethod(MailboxBackEnd.class, "getNextBatch", new Class[]{Uuid.class, Uuid.class, Long.TYPE, Object.class}), ProxyUtil.getMethod(MailboxPullRegistration.class, "addUnknownEvents", new Class[]{Collection.class}), ProxyUtil.getMethod(MailboxBackEnd.class, "addUnknownEvents", new Class[]{Uuid.class, Collection.class}), ProxyUtil.getMethod(MailboxRegistration.class, "enableDelivery", new Class[]{RemoteEventListener.class}), ProxyUtil.getMethod(MailboxBackEnd.class, "enableDelivery", new Class[]{Uuid.class, RemoteEventListener.class}), ProxyUtil.getMethod(MailboxRegistration.class, "disableDelivery", new Class[0]), ProxyUtil.getMethod(MailboxBackEnd.class, "disableDelivery", new Class[]{Uuid.class})};
        private MethodConstraints methodConstraints;

        private ConstrainableRegistration(Uuid id, MailboxBackEnd server, Lease lease, MethodConstraints methodConstraints) {
            super(id, ConstrainableRegistration.constrainServer(server, methodConstraints), lease);
            this.methodConstraints = methodConstraints;
        }

        public RemoteEventIterator getRemoteEvents(long maxEvents, long timeout) throws RemoteException {
            return super.getRemoteEvents();
        }

        private static MailboxBackEnd constrainServer(MailboxBackEnd server, MethodConstraints methodConstraints) {
            return (MailboxBackEnd)((Object)((RemoteMethodControl)((Object)server)).setConstraints(ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMap1)));
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableRegistration(this.registrationID, this.mailbox, this.lease, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.mailbox);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.mailbox, methodMap1);
            if (!(this.lease instanceof ConstrainableLandlordLease)) {
                throw new InvalidObjectException("Registration.readObject failure - lease is not an instance of ConstrainableLandlordLease");
            }
            if (!(this.listener instanceof ListenerProxy.ConstrainableListenerProxy)) {
                throw new InvalidObjectException("Registration.readObject failure - listener is not an instance of ListenerProxy.ConstrainableListenerProxy");
            }
            if (this.registrationID != ((ListenerProxy.ConstrainableListenerProxy)this.listener).registrationID) {
                throw new InvalidObjectException("Registration.readObject failure - listener ID is not equal to proxy ID");
            }
        }
    }
}

