/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHolder;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.OutriggerServerImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.jini.id.Uuid;

class EntryHolderSet {
    private final Map holders = new HashMap();
    private final Hashtable idMap = new Hashtable();
    private final OutriggerServerImpl space;

    EntryHolderSet(OutriggerServerImpl space) {
        this.space = space;
    }

    EntryHolder holderFor(EntryRep rep) {
        return this.holderFor(rep.classFor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized EntryHolder holderFor(String className) {
        Map map = this.holders;
        synchronized (map) {
            EntryHolder holder = (EntryHolder)this.holders.get(className);
            if (holder == null) {
                holder = new EntryHolder(this.space, this.idMap);
                this.holders.put(className, holder);
            }
            return holder;
        }
    }

    LeasedResource getLeasedResource(Uuid cookie) {
        EntryHandle handle = this.handleFor(cookie);
        if (handle == null) {
            return null;
        }
        return handle.getLeasedResource();
    }

    EntryHandle handleFor(Object cookie) {
        return (EntryHandle)this.idMap.get(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(EntryHandle handle) {
        EntryHolder holder;
        Map map = this.holders;
        synchronized (map) {
            holder = (EntryHolder)this.holders.get(handle.rep().classFor());
        }
        if (holder == null) {
            return;
        }
        holder.remove(handle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reap() {
        EntryHolder[] content;
        Map map = this.holders;
        synchronized (map) {
            Collection values = this.holders.values();
            content = new EntryHolder[values.size()];
            values.toArray(content);
        }
        for (int i = 0; i < content.length; ++i) {
            content[i].reap();
        }
    }
}

