/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.TransitionWatcher;
import java.util.HashSet;
import java.util.Set;

class EntryTransition {
    private final EntryHandle handle;
    private final TransactableMgr txn;
    private final boolean available;
    private final boolean visible;
    private final boolean newEntry;
    private final Set watchers = new HashSet();

    EntryTransition(EntryHandle handle, TransactableMgr txn, boolean available, boolean visible, boolean newEntry) {
        if (handle == null) {
            throw new NullPointerException("entry must be non-null");
        }
        assert (!visible || available && visible);
        assert (!newEntry || available && visible);
        this.handle = handle;
        this.txn = txn;
        this.available = available;
        this.visible = visible;
        this.newEntry = newEntry;
    }

    EntryHandle getHandle() {
        return this.handle;
    }

    TransactableMgr getTxn() {
        return this.txn;
    }

    boolean isAvailable() {
        return this.available;
    }

    boolean isVisible() {
        return this.visible;
    }

    boolean isNewEntry() {
        return this.newEntry;
    }

    void processedBy(TransitionWatcher w) {
        this.watchers.add(w);
    }

    boolean hasProcessed(TransitionWatcher w) {
        return this.watchers.contains(w);
    }
}

